/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.sling.api.resource.ResourceDecorator;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.apache.sling.jcr.resource.internal.JcrResourceListener;
import org.apache.sling.jcr.resource.internal.JcrResourceResolver;
import org.apache.sling.jcr.resource.internal.JcrResourceResolverWebConsolePlugin;
import org.apache.sling.jcr.resource.internal.ResourceDecoratorTracker;
import org.apache.sling.jcr.resource.internal.helper.MapEntries;
import org.apache.sling.jcr.resource.internal.helper.Mapping;
import org.apache.sling.jcr.resource.internal.helper.ResourceProviderEntry;
import org.apache.sling.jcr.resource.internal.helper.RootResourceProviderEntry;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderEntry;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrResourceResolverFactoryImpl
implements JcrResourceResolverFactory,
ResourceResolverFactory {
    public static final String ALL_WORKSPACES = "*";
    public static final String PROP_PATH = "resource.resolver.searchpath";
    private static final String PROP_MANGLE_NAMESPACES = "resource.resolver.manglenamespaces";
    private static final String PROP_ALLOW_DIRECT = "resource.resolver.allowDirect";
    private static final String PROP_VIRTUAL = "resource.resolver.virtual";
    private static final String PROP_MAPPING = "resource.resolver.mapping";
    private static final String PROP_MAP_LOCATION = "resource.resolver.map.location";
    private static final String PROP_MULTIWORKSPACE = "resource.resolver.multiworkspace";
    private static final boolean DEFAULT_MULTIWORKSPACE = false;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private SlingRepository repository;
    private final ResourceDecoratorTracker resourceDecoratorTracker = new ResourceDecoratorTracker();
    private MapEntries mapEntries = MapEntries.EMPTY;
    private Mapping[] mappings;
    private BidiMap virtualURLMap;
    private boolean allowDirect = false;
    private String[] searchPath;
    private String mapRoot;
    private final RootResourceProviderEntry rootProviderEntry = new RootResourceProviderEntry();
    private boolean mangleNamespacePrefixes;
    private boolean useMultiWorkspaces;
    private Set<JcrResourceListener> resourceListeners;
    private ServiceTracker eventAdminTracker;
    private DynamicClassLoaderManager dynamicClassLoaderManager;
    private JcrResourceResolverWebConsolePlugin plugin;

    public ResourceDecoratorTracker getResourceDecoratorTracker() {
        return this.resourceDecoratorTracker;
    }

    @Override
    public ResourceResolver getResourceResolver(Session session) {
        HashMap<String, Object> authInfo = new HashMap<String, Object>(1);
        authInfo.put("user.jcr.session", session);
        try {
            return this.getResourceResolver(authInfo);
        }
        catch (org.apache.sling.api.resource.LoginException le) {
            throw new InternalError("Unexpected LoginException");
        }
    }

    public ResourceResolver getAdministrativeResourceResolver(Map<String, Object> authenticationInfo) throws org.apache.sling.api.resource.LoginException {
        return this.getResourceResolverInternal(authenticationInfo, true);
    }

    public ResourceResolver getResourceResolver(Map<String, Object> authenticationInfo) throws org.apache.sling.api.resource.LoginException {
        return this.getResourceResolverInternal(authenticationInfo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceResolver getResourceResolverInternal(Map<String, Object> authenticationInfo, boolean isAdmin) throws org.apache.sling.api.resource.LoginException {
        Session session;
        boolean logoutSession;
        block12: {
            logoutSession = true;
            try {
                String workspace = this.getWorkspace(authenticationInfo);
                if (isAdmin) {
                    session = this.getRepository().loginAdministrative(workspace);
                    break block12;
                }
                session = this.getSession(authenticationInfo);
                if (session == null) {
                    Credentials credentials = this.getCredentials(authenticationInfo);
                    session = this.getRepository().login(credentials, workspace);
                    break block12;
                }
                if (workspace != null) {
                    Session tmpSession = null;
                    try {
                        tmpSession = this.getRepository().loginAdministrative(workspace);
                        if (tmpSession.getUserID().equals(session.getUserID())) {
                            session = tmpSession;
                            tmpSession = null;
                        } else {
                            session = tmpSession.impersonate((Credentials)new SimpleCredentials(session.getUserID(), new char[0]));
                        }
                        break block12;
                    }
                    finally {
                        if (tmpSession != null) {
                            tmpSession.logout();
                        }
                    }
                }
                logoutSession = false;
            }
            catch (RepositoryException re) {
                throw this.getLoginException(re);
            }
        }
        session = this.handleImpersonation(session, authenticationInfo, logoutSession);
        JcrResourceProviderEntry sessionRoot = new JcrResourceProviderEntry(session, this.rootProviderEntry, this.getDynamicClassLoader(), this.useMultiWorkspaces);
        if (logoutSession) {
            return new JcrResourceResolver(sessionRoot, this, isAdmin, authenticationInfo, this.useMultiWorkspaces);
        }
        return new JcrResourceResolver(sessionRoot, this, isAdmin, authenticationInfo, this.useMultiWorkspaces){

            protected void closeSession() {
            }
        };
    }

    ClassLoader getDynamicClassLoader() {
        DynamicClassLoaderManager dclm = this.dynamicClassLoaderManager;
        if (dclm != null) {
            return dclm.getDynamicClassLoader();
        }
        return null;
    }

    String virtualToRealUri(String virtualUri) {
        return this.virtualURLMap != null ? (String)this.virtualURLMap.get((Object)virtualUri) : null;
    }

    String realToVirtualUri(String realUri) {
        return this.virtualURLMap != null ? (String)this.virtualURLMap.getKey((Object)realUri) : null;
    }

    public BidiMap getVirtualURLMap() {
        return this.virtualURLMap;
    }

    public Mapping[] getMappings() {
        return this.mappings;
    }

    String[] getSearchPath() {
        return this.searchPath;
    }

    boolean isMangleNamespacePrefixes() {
        return this.mangleNamespacePrefixes;
    }

    public String getMapRoot() {
        return this.mapRoot;
    }

    MapEntries getMapEntries() {
        return this.mapEntries;
    }

    String getDefaultWorkspaceName() {
        return this.repository.getDefaultWorkspace();
    }

    protected ResourceProviderEntry getRootProviderEntry() {
        return this.rootProviderEntry;
    }

    protected void activate(ComponentContext componentContext) {
        this.eventAdminTracker = new ServiceTracker(componentContext.getBundleContext(), EventAdmin.class.getName(), null);
        this.eventAdminTracker.open();
        Dictionary properties = componentContext.getProperties();
        TreeBidiMap virtuals = new TreeBidiMap();
        String[] virtualList = (String[])properties.get(PROP_VIRTUAL);
        for (int i = 0; virtualList != null && i < virtualList.length; ++i) {
            String[] parts = Mapping.split(virtualList[i]);
            virtuals.put((Object)parts[0], (Object)parts[2]);
        }
        this.virtualURLMap = virtuals;
        ArrayList<Mapping> maps = new ArrayList<Mapping>();
        String[] mappingList = (String[])properties.get(PROP_MAPPING);
        for (int i = 0; mappingList != null && i < mappingList.length; ++i) {
            maps.add(new Mapping(mappingList[i]));
        }
        Mapping[] tmp = maps.toArray(new Mapping[maps.size()]);
        Boolean directProp = (Boolean)properties.get(PROP_ALLOW_DIRECT);
        boolean bl = this.allowDirect = directProp != null ? directProp : true;
        if (this.allowDirect) {
            Mapping[] tmp2 = new Mapping[tmp.length + 1];
            tmp2[0] = Mapping.DIRECT;
            System.arraycopy(tmp, 0, tmp2, 1, tmp.length);
            this.mappings = tmp2;
        } else {
            this.mappings = tmp;
        }
        this.searchPath = OsgiUtil.toStringArray(properties.get(PROP_PATH));
        if (this.searchPath != null && this.searchPath.length > 0) {
            for (int i = 0; i < this.searchPath.length; ++i) {
                if (!this.searchPath[i].startsWith("/")) {
                    this.searchPath[i] = "/" + this.searchPath[i];
                }
                if (this.searchPath[i].endsWith("/")) continue;
                int n = i;
                this.searchPath[n] = this.searchPath[n] + "/";
            }
        }
        if (this.searchPath == null) {
            this.searchPath = new String[]{"/"};
        }
        this.mangleNamespacePrefixes = OsgiUtil.toBoolean(properties.get(PROP_MANGLE_NAMESPACES), (boolean)false);
        this.mapRoot = OsgiUtil.toString(properties.get(PROP_MAP_LOCATION), (String)"/etc/map");
        try {
            this.mapEntries = new MapEntries(this, this.getRepository());
        }
        catch (Exception e) {
            this.log.error("activate: Cannot access repository, failed setting up Mapping Support", (Throwable)e);
        }
        try {
            this.resourceListeners = new HashSet<JcrResourceListener>();
            this.resourceListeners.add(new JcrResourceListener(null, this, "/", "/", this.eventAdminTracker));
            this.useMultiWorkspaces = OsgiUtil.toBoolean(properties.get(PROP_MULTIWORKSPACE), (boolean)false);
            if (this.useMultiWorkspaces) {
                String[] listenerWorkspaces;
                for (String wspName : listenerWorkspaces = this.getAllWorkspaces()) {
                    if (wspName.equals(this.repository.getDefaultWorkspace())) continue;
                    this.resourceListeners.add(new JcrResourceListener(wspName, this, "/", "/", this.eventAdminTracker));
                }
            }
        }
        catch (Exception e) {
            this.log.error("activate: Cannot create resource listener; resource events for JCR resources will be disabled.", (Throwable)e);
        }
        try {
            this.plugin = new JcrResourceResolverWebConsolePlugin(componentContext.getBundleContext(), this);
        }
        catch (Throwable ignore) {
            this.log.debug("activate: unable to setup web console plugin.", ignore);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        if (this.plugin != null) {
            this.plugin.dispose();
            this.plugin = null;
        }
        if (this.mapEntries != null) {
            this.mapEntries.dispose();
            this.mapEntries = MapEntries.EMPTY;
        }
        if (this.eventAdminTracker != null) {
            this.eventAdminTracker.close();
            this.eventAdminTracker = null;
        }
        if (this.resourceListeners != null && !this.resourceListeners.isEmpty()) {
            for (JcrResourceListener resourceListener : this.resourceListeners) {
                resourceListener.dispose();
            }
            this.resourceListeners = null;
        }
        this.resourceDecoratorTracker.close();
    }

    protected void bindResourceProvider(ResourceProvider provider, Map<String, Object> props) {
        this.rootProviderEntry.bindResourceProvider(provider, props, this.eventAdminTracker);
    }

    protected void unbindResourceProvider(ResourceProvider provider, Map<String, Object> props) {
        this.rootProviderEntry.unbindResourceProvider(provider, props, this.eventAdminTracker);
    }

    protected void bindResourceDecorator(ResourceDecorator decorator, Map<String, Object> props) {
        this.resourceDecoratorTracker.bindResourceDecorator(decorator, props);
    }

    protected void unbindResourceDecorator(ResourceDecorator decorator, Map<String, Object> props) {
        this.resourceDecoratorTracker.unbindResourceDecorator(decorator, props);
    }

    protected SlingRepository getRepository() {
        return this.repository;
    }

    private org.apache.sling.api.resource.LoginException getLoginException(RepositoryException re) {
        if (re instanceof LoginException) {
            return new org.apache.sling.api.resource.LoginException(re.getMessage(), re.getCause());
        }
        return new org.apache.sling.api.resource.LoginException("Unable to login " + re.getMessage(), (Throwable)re);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getAllWorkspaces() throws RepositoryException {
        Session session = null;
        try {
            session = this.repository.loginAdministrative(null);
            String[] stringArray = session.getWorkspace().getAccessibleWorkspaceNames();
            return stringArray;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private Session getSession(Map<String, Object> authenticationInfo) {
        Object sessionObject;
        if (authenticationInfo != null && (sessionObject = authenticationInfo.get("user.jcr.session")) instanceof Session) {
            return (Session)sessionObject;
        }
        return null;
    }

    private String getWorkspace(Map<String, Object> authenticationInfo) {
        Object workspaceObject;
        if (authenticationInfo != null && (workspaceObject = authenticationInfo.get("user.jcr.workspace")) instanceof String) {
            return (String)workspaceObject;
        }
        return null;
    }

    private String getSudoUser(Map<String, Object> authenticationInfo) {
        Object sudoObject;
        if (authenticationInfo != null && (sudoObject = authenticationInfo.get("user.impersonation")) instanceof String) {
            return (String)sudoObject;
        }
        return null;
    }

    private Session handleImpersonation(Session session, Map<String, Object> authenticationInfo, boolean logoutSession) throws org.apache.sling.api.resource.LoginException {
        String sudoUser = this.getSudoUser(authenticationInfo);
        if (sudoUser != null && !session.getUserID().equals(sudoUser)) {
            try {
                SimpleCredentials creds = new SimpleCredentials(sudoUser, new char[0]);
                this.copyAttributes(creds, authenticationInfo);
                creds.setAttribute("user.impersonator", (Object)session.getUserID());
                Session session2 = session.impersonate((Credentials)creds);
                return session2;
            }
            catch (RepositoryException re) {
                throw this.getLoginException(re);
            }
            finally {
                if (logoutSession) {
                    session.logout();
                }
            }
        }
        return session;
    }

    private Credentials getCredentials(Map<String, Object> authenticationInfo) {
        if (authenticationInfo == null) {
            return null;
        }
        Object credentialsObject = authenticationInfo.get("user.jcr.credentials");
        if (credentialsObject instanceof Credentials) {
            return (Credentials)credentialsObject;
        }
        Object userId = authenticationInfo.get("user.name");
        if (userId instanceof String) {
            Object password = authenticationInfo.get("user.password");
            SimpleCredentials credentials = new SimpleCredentials((String)userId, password instanceof char[] ? (char[])password : new char[]{});
            this.copyAttributes(credentials, authenticationInfo);
            return credentials;
        }
        return null;
    }

    private void copyAttributes(SimpleCredentials target, Map<String, Object> source) {
        for (Map.Entry<String, Object> current : source.entrySet()) {
            if (!JcrResourceResolverFactoryImpl.isAttributeVisible(current.getKey())) continue;
            target.setAttribute(current.getKey(), current.getValue());
        }
    }

    static boolean isAttributeVisible(String name) {
        return !name.equals("user.jcr.credentials") && !name.contains("password");
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.dynamicClassLoaderManager = dynamicClassLoaderManager;
    }

    protected void unbindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        if (this.dynamicClassLoaderManager == dynamicClassLoaderManager) {
            this.dynamicClassLoaderManager = null;
        }
    }

    public static final class ResourcePattern {
        public final Pattern pattern;
        public final String replacement;

        public ResourcePattern(Pattern p, String r) {
            this.pattern = p;
            this.replacement = r;
        }
    }
}

