/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.NodeIterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrNodeResourceIterator
implements Iterator<Resource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrNodeResourceIterator.class);
    private ResourceResolver resourceResolver;
    private NodeIterator nodes;
    private Resource nextResult;
    private final ClassLoader dynamicClassLoader;

    public JcrNodeResourceIterator(ResourceResolver resourceResolver, NodeIterator nodes, ClassLoader dynamicClassLoader) {
        this.resourceResolver = resourceResolver;
        this.nodes = nodes;
        this.nextResult = this.seek();
        this.dynamicClassLoader = dynamicClassLoader;
    }

    @Override
    public boolean hasNext() {
        return this.nextResult != null;
    }

    @Override
    public Resource next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Resource result = this.nextResult;
        this.nextResult = this.seek();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Resource seek() {
        while (this.nodes.hasNext()) {
            try {
                JcrNodeResource resource = new JcrNodeResource(this.resourceResolver, this.nodes.nextNode(), this.dynamicClassLoader);
                LOGGER.debug("seek: Returning Resource {}", (Object)resource);
                return resource;
            }
            catch (Throwable t) {
                LOGGER.error("seek: Problem creating Resource for next node, skipping", t);
            }
        }
        LOGGER.debug("seek: No more nodes, iterator exhausted");
        return null;
    }
}

