/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.jcr.resource.internal.helper.ResourceProviderEntry;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrResourceProviderEntry
extends ResourceProviderEntry {
    private static final long serialVersionUID = 5672648586247261128L;
    private final ResourceProviderEntry delegatee;
    private final Session session;

    public JcrResourceProviderEntry(Session session, ResourceProviderEntry delegatee, ClassLoader dynamicClassLoader, boolean useMultiWorkspaces) {
        super("/", new ResourceProvider[]{new JcrResourceProvider(session, dynamicClassLoader, useMultiWorkspaces)});
        this.delegatee = delegatee;
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public boolean addResourceProvider(String prefix, ResourceProvider provider, Comparable<?> comparable) {
        return this.delegatee.addResourceProvider(prefix, provider, comparable);
    }

    @Override
    public boolean removeResourceProvider(String prefix, ResourceProvider provider, Comparable<?> comparable) {
        return this.delegatee.removeResourceProvider(prefix, provider, comparable);
    }

    @Override
    public ResourceProviderEntry get(String key) {
        ResourceProviderEntry rpe = super.get(key);
        if (rpe == null) {
            rpe = this.delegatee.get(key);
        }
        return rpe;
    }

    @Override
    public Collection<ResourceProviderEntry> values() {
        ArrayList<ResourceProviderEntry> list = new ArrayList<ResourceProviderEntry>(super.values());
        list.addAll(this.delegatee.values());
        return list;
    }

    @Override
    public boolean containsKey(String key) {
        return super.containsKey(key) || this.delegatee.containsKey(key);
    }

    @Override
    public ResourceProvider[] getResourceProviders() {
        ResourceProvider[] delegateeProviders = this.delegatee.getResourceProviders();
        ResourceProvider[] superProviders = super.getResourceProviders();
        if (delegateeProviders == null && superProviders == null) {
            return null;
        }
        if (delegateeProviders == null) {
            delegateeProviders = new ResourceProvider[]{};
        }
        if (superProviders == null) {
            superProviders = new ResourceProvider[]{};
        }
        ResourceProvider[] resourceProviders = new ResourceProvider[delegateeProviders.length + superProviders.length];
        System.arraycopy(delegateeProviders, 0, resourceProviders, 0, delegateeProviders.length);
        System.arraycopy(superProviders, 0, resourceProviders, delegateeProviders.length, superProviders.length);
        return resourceProviders;
    }

    @Override
    public String toString() {
        return this.delegatee.toString();
    }
}

