/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.resource.JcrResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrPropertyMap
implements ValueMap {
    private static Logger LOGGER = LoggerFactory.getLogger(JcrPropertyMap.class);
    private final Node node;
    final Map<String, CacheEntry> cache;
    final Map<String, Object> valueCache;
    boolean fullyRead;
    private final ClassLoader dynamicClassLoader;

    public JcrPropertyMap(Node node) {
        this(node, null);
    }

    public JcrPropertyMap(Node node, ClassLoader dynamicCL) {
        this.node = node;
        this.cache = new LinkedHashMap<String, CacheEntry>();
        this.valueCache = new LinkedHashMap<String, Object>();
        this.fullyRead = false;
        this.dynamicClassLoader = dynamicCL;
    }

    Node getNode() {
        return this.node;
    }

    public <T> T get(String key, Class<T> type) {
        if (type == null) {
            return (T)this.get(key);
        }
        CacheEntry entry = this.cache.get(key);
        if (entry == null) {
            entry = this.read(key);
        }
        if (entry == null) {
            return null;
        }
        return this.convertToType(entry, type);
    }

    public <T> T get(String key, T defaultValue) {
        if (defaultValue == null) {
            return (T)this.get(key);
        }
        Class<?> type = this.normalizeClass(defaultValue.getClass());
        Class<Object> value = this.get(key, (T)type);
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        CacheEntry entry = this.cache.get(key);
        if (entry == null) {
            entry = this.read((String)key);
        }
        Object value = entry == null ? null : entry.defaultValue;
        return value;
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        this.readFully();
        return this.valueCache.containsValue(value);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        this.readFully();
        return this.cache.size();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        this.readFully();
        return this.valueCache.entrySet();
    }

    public Set<String> keySet() {
        this.readFully();
        return this.cache.keySet();
    }

    public Collection<Object> values() {
        this.readFully();
        return this.valueCache.values();
    }

    public String getPath() {
        try {
            return this.node.getPath();
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    CacheEntry read(String key) {
        if (this.fullyRead && key.indexOf(47) == -1) {
            return null;
        }
        String name = ISO9075.encodePath(key);
        try {
            if (this.node.hasProperty(name)) {
                Property prop = this.node.getProperty(name);
                CacheEntry entry = new CacheEntry(prop);
                this.cache.put(key, entry);
                this.valueCache.put(key, entry.defaultValue);
                return entry;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }

    void readFully() {
        if (!this.fullyRead) {
            try {
                PropertyIterator pi = this.node.getProperties();
                while (pi.hasNext()) {
                    Property prop = pi.nextProperty();
                    String name = prop.getName();
                    String key = ISO9075.decode(name);
                    if (this.cache.containsKey(key)) continue;
                    CacheEntry entry = new CacheEntry(prop);
                    this.cache.put(key, entry);
                    this.valueCache.put(key, entry.defaultValue);
                }
                this.fullyRead = true;
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map<? extends String, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    private <T> T convertToType(CacheEntry entry, Class<T> type) {
        Object result = null;
        try {
            boolean array = type.isArray();
            if (entry.isMulti) {
                if (array) {
                    result = this.convertToArray(entry, type.getComponentType());
                } else if (entry.values.length > 0) {
                    result = this.convertToType(entry, -1, entry.values[0], type);
                }
            } else {
                result = array ? this.convertToArray(entry, type.getComponentType()) : this.convertToType(entry, -1, entry.values[0], type);
            }
        }
        catch (ValueFormatException vfe) {
            LOGGER.info("converToType: Cannot convert value of " + entry.defaultValue + " to " + type, (Throwable)vfe);
        }
        catch (RepositoryException re) {
            LOGGER.info("converToType: Cannot get value of " + entry.defaultValue, (Throwable)re);
        }
        return (T)result;
    }

    private <T> T[] convertToArray(CacheEntry entry, Class<T> type) throws ValueFormatException, RepositoryException {
        ArrayList<T> values = new ArrayList<T>();
        for (int i = 0; i < entry.values.length; ++i) {
            T value = this.convertToType(entry, i, entry.values[i], type);
            if (value == null) continue;
            values.add(value);
        }
        Object[] result = (Object[])Array.newInstance(type, values.size());
        return values.toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T convertToType(CacheEntry entry, int index, Value jcrValue, Class<T> type) throws ValueFormatException, RepositoryException {
        block34: {
            if (type.isInstance(entry.defaultValue)) {
                return (T)entry.defaultValue;
            }
            if (String.class == type) {
                return (T)jcrValue.getString();
            }
            if (Byte.class == type) {
                return (T)Byte.valueOf((byte)jcrValue.getLong());
            }
            if (Short.class == type) {
                return (T)Short.valueOf((short)jcrValue.getLong());
            }
            if (Integer.class == type) {
                return (T)Integer.valueOf((int)jcrValue.getLong());
            }
            if (Long.class == type) {
                if (jcrValue.getType() == 2) {
                    if (index == -1) {
                        return (T)Long.valueOf(entry.property.getLength());
                    }
                    return (T)Long.valueOf(entry.property.getLengths()[index]);
                }
                return (T)Long.valueOf(jcrValue.getLong());
            }
            if (Float.class == type) {
                return (T)Float.valueOf((float)jcrValue.getDouble());
            }
            if (Double.class == type) {
                return (T)Double.valueOf(jcrValue.getDouble());
            }
            if (Boolean.class == type) {
                return (T)Boolean.valueOf(jcrValue.getBoolean());
            }
            if (Date.class == type) {
                return (T)jcrValue.getDate().getTime();
            }
            if (Calendar.class == type) {
                return (T)jcrValue.getDate();
            }
            if (Value.class == type) {
                return (T)jcrValue;
            }
            if (Property.class == type) {
                return (T)entry.property;
            }
            if (Serializable.class.isAssignableFrom(type) && jcrValue.getType() == 2) {
                Object object;
                java.io.ObjectInputStream ois = null;
                try {
                    ois = new ObjectInputStream(jcrValue.getStream(), this.dynamicClassLoader);
                    Object obj = ois.readObject();
                    if (!type.isInstance(obj)) break block34;
                    object = obj;
                }
                catch (ClassNotFoundException cnfe) {
                    break block34;
                }
                catch (IOException ioe) {
                    break block34;
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
                return (T)object;
            }
        }
        return null;
    }

    private Class<?> normalizeClass(Class<?> type) {
        if (Calendar.class.isAssignableFrom(type)) {
            type = Calendar.class;
        } else if (Date.class.isAssignableFrom(type)) {
            type = Date.class;
        } else if (Value.class.isAssignableFrom(type)) {
            type = Value.class;
        } else if (Property.class.isAssignableFrom(type)) {
            type = Property.class;
        }
        return type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectInputStream
    extends java.io.ObjectInputStream {
        private ClassLoader classloader;

        public ObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classloader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            if (this.classloader != null) {
                return Class.forName(classDesc.getName(), true, this.classloader);
            }
            return super.resolveClass(classDesc);
        }
    }

    static final class CacheEntry {
        public final Property property;
        public final boolean isMulti;
        public final Value[] values;
        public final Object defaultValue;

        private Value createValue(Object obj, Session session) throws RepositoryException {
            Value value = JcrResourceUtil.createValue(obj, session);
            if (value == null && obj instanceof Serializable) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(obj);
                    oos.close();
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    value = session.getValueFactory().createValue((InputStream)bais);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            return value;
        }

        public CacheEntry(Property prop) throws RepositoryException {
            this.property = prop;
            if (prop.getDefinition().isMultiple()) {
                this.isMulti = true;
                this.values = prop.getValues();
            } else {
                this.isMulti = false;
                this.values = new Value[]{prop.getValue()};
            }
            this.defaultValue = JcrResourceUtil.toJavaObject(prop);
        }

        public CacheEntry(Object value, Session session) throws RepositoryException {
            this.property = null;
            this.defaultValue = value;
            if (value.getClass().isArray()) {
                this.isMulti = true;
                Object[] values = (Object[])value;
                this.values = new Value[values.length];
                for (int i = 0; i < values.length; ++i) {
                    this.values[i] = this.createValue(values[i], session);
                    if (this.values[i] != null) continue;
                    throw new IllegalArgumentException("Value can't be stored in the repository: " + values[i]);
                }
            } else {
                this.isMulti = false;
                this.values = new Value[]{this.createValue(value, session)};
                if (this.values[0] == null) {
                    throw new IllegalArgumentException("Value can't be stored in the repository: " + value);
                }
            }
        }
    }
}

