/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrResourceListener
implements EventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrResourceListener.class);
    private final Session session;
    private final String startPath;
    private final String mountPrefix;
    private final ResourceResolver resolver;
    private ServiceTracker eventAdminTracker;

    public JcrResourceListener(SlingRepository repository, JcrResourceResolverFactory factory, String startPath, String mountPrefix, ServiceTracker eventAdminTracker) throws RepositoryException {
        this.session = repository.loginAdministrative(null);
        this.resolver = factory.getResourceResolver(this.session);
        this.startPath = startPath;
        this.eventAdminTracker = eventAdminTracker;
        this.mountPrefix = mountPrefix.equals("/") ? null : mountPrefix;
        this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 31, this.startPath, true, null, null, false);
    }

    public void dispose() {
        try {
            this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        }
        catch (RepositoryException e) {
            LOGGER.warn("Unable to remove session listener: " + this, (Throwable)e);
        }
        this.session.logout();
    }

    public void onEvent(EventIterator events) {
        String resourceSuperType;
        String resourceType;
        Resource resource;
        EventAdmin localEA = (EventAdmin)this.eventAdminTracker.getService();
        if (localEA == null) {
            return;
        }
        HashSet addedPaths = new HashSet();
        HashSet removedPaths = new HashSet();
        HashSet<String> changedPaths = new HashSet<String>();
        while (events.hasNext()) {
            Event event = events.nextEvent();
            try {
                HashSet<String> set = null;
                String nodePath = event.getPath();
                if (event.getType() == 4 || event.getType() == 8 || event.getType() == 16) {
                    int lastSlash = nodePath.lastIndexOf(47);
                    nodePath = nodePath.substring(0, lastSlash);
                    set = changedPaths;
                } else if (event.getType() == 1) {
                    set = addedPaths;
                } else if (event.getType() == 2) {
                    set = removedPaths;
                }
                if (set == null) continue;
                if (this.mountPrefix != null) {
                    set.add(this.mountPrefix + nodePath);
                    continue;
                }
                set.add(nodePath);
            }
            catch (RepositoryException e) {
                LOGGER.error("Error during modification: {}", (Object)e.getMessage());
            }
        }
        addedPaths.removeAll(removedPaths);
        changedPaths.removeAll(removedPaths);
        changedPaths.removeAll(addedPaths);
        for (String path : addedPaths) {
            resource = this.resolver.getResource(path);
            if (resource == null) continue;
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("path", path);
            resourceType = resource.getResourceType();
            resourceSuperType = resource.getResourceSuperType();
            if (resourceType != null) {
                ((Dictionary)properties).put("resourceType", resource.getResourceType());
            }
            if (resourceSuperType != null) {
                ((Dictionary)properties).put("resourceSuperType", resource.getResourceSuperType());
            }
            localEA.postEvent(new org.osgi.service.event.Event("org/apache/sling/api/resource/Resource/ADDED", properties));
        }
        for (String path : changedPaths) {
            resource = this.resolver.getResource(path);
            if (resource == null) continue;
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("path", path);
            resourceType = resource.getResourceType();
            resourceSuperType = resource.getResourceSuperType();
            if (resourceType != null) {
                ((Dictionary)properties).put("resourceType", resource.getResourceType());
            }
            if (resourceSuperType != null) {
                ((Dictionary)properties).put("resourceSuperType", resource.getResourceSuperType());
            }
            localEA.postEvent(new org.osgi.service.event.Event("org/apache/sling/api/resource/Resource/CHANGED", properties));
        }
        for (String path : removedPaths) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("path", path);
            localEA.postEvent(new org.osgi.service.event.Event("org/apache/sling/api/resource/Resource/REMOVED", properties));
        }
    }
}

