/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.adapter.SlingAdaptable;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.QuerySyntaxException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.resource.JcrResourceUtil;
import org.apache.sling.jcr.resource.internal.JcrResourceResolverFactoryImpl;
import org.apache.sling.jcr.resource.internal.helper.MapEntries;
import org.apache.sling.jcr.resource.internal.helper.MapEntry;
import org.apache.sling.jcr.resource.internal.helper.RedirectResource;
import org.apache.sling.jcr.resource.internal.helper.ResourcePathIterator;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResourceIterator;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderEntry;
import org.apache.sling.jcr.resource.internal.helper.starresource.StarResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrResourceResolver2
extends SlingAdaptable
implements ResourceResolver {
    private static final String MANGLE_NAMESPACE_IN_SUFFIX = "_";
    private static final String MANGLE_NAMESPACE_IN_PREFIX = "/_";
    private static final String MANGLE_NAMESPACE_IN = "/_([^_]+)_";
    private static final String MANGLE_NAMESPACE_OUT_SUFFIX = ":";
    private static final String MANGLE_NAMESPACE_OUT_PREFIX = "/";
    private static final String MANGLE_NAMESPACE_OUT = "/([^:/]+):";
    public static final String PROP_REG_EXP = "sling:match";
    public static final String PROP_REDIRECT_INTERNAL = "sling:internalRedirect";
    public static final String PROP_ALIAS = "sling:alias";
    public static final String PROP_REDIRECT_EXTERNAL = "sling:redirect";
    public static final String PROP_REDIRECT_EXTERNAL_STATUS = "sling:status";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final JcrResourceProviderEntry rootProvider;
    private final JcrResourceResolverFactoryImpl factory;
    private final MapEntries resourceMapper;

    public JcrResourceResolver2(JcrResourceProviderEntry rootProvider, JcrResourceResolverFactoryImpl factory, MapEntries resourceMapper) {
        this.rootProvider = rootProvider;
        this.factory = factory;
        this.resourceMapper = resourceMapper;
    }

    public Resource resolve(String absPath) {
        return this.resolve(null, absPath);
    }

    public Resource resolve(HttpServletRequest request) {
        return this.resolve(request, request.getPathInfo());
    }

    public Resource resolve(HttpServletRequest request, String absPath) {
        if (absPath == null) {
            absPath = MANGLE_NAMESPACE_OUT_PREFIX;
        } else if (!absPath.startsWith(MANGLE_NAMESPACE_OUT_PREFIX)) {
            absPath = MANGLE_NAMESPACE_OUT_PREFIX + absPath;
        }
        absPath = this.unmangleNamespaces(absPath);
        String[] realPathList = new String[]{absPath};
        String requestPath = request != null ? JcrResourceResolver2.getMapPath(request.getScheme(), request.getServerName(), request.getServerPort(), absPath) : JcrResourceResolver2.getMapPath("http", "localhost", 80, absPath);
        this.log.debug("resolve: Resolving request path {}", (Object)requestPath);
        for (int i = 0; i < 100; ++i) {
            String[] mappedPath = null;
            for (MapEntry mapEntry : this.resourceMapper.getResolveMaps()) {
                mappedPath = mapEntry.replace(requestPath);
                if (mappedPath == null) continue;
                this.log.debug("resolve: MapEntry {} matches, mapped path is {}", (Object)mapEntry, (Object)mappedPath);
                if (mapEntry.isInternal()) {
                    this.log.debug("resolve: Redirecting internally");
                    break;
                }
                this.log.debug("resolve: Returning external redirect");
                return new RedirectResource(this, absPath, mappedPath[0]);
            }
            if (mappedPath == null) {
                this.log.debug("resolve: Request path {} does not match any MapEntry", (Object)requestPath);
                break;
            }
            if (!mappedPath[0].contains("://")) {
                this.log.debug("resolve: Mapped path is for resource tree");
                realPathList = mappedPath;
                break;
            }
            try {
                URI uri = new URI(mappedPath[0]);
                requestPath = JcrResourceResolver2.getMapPath(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath());
                realPathList = new String[]{uri.getPath()};
                this.log.debug("resolve: Mapped path is an URL, using new request path {}", (Object)requestPath);
                continue;
            }
            catch (URISyntaxException use) {
                throw new ResourceNotFoundException(absPath);
            }
        }
        Object res = null;
        for (int i = 0; res == null && i < realPathList.length; ++i) {
            String realPath = realPathList[i];
            if (StarResource.appliesTo(realPath)) {
                this.log.debug("resolve: Mapped path {} is a Star Resource", (Object)realPath);
                res = new StarResource(this, this.ensureAbsPath(realPath), this.factory.getJcrResourceTypeProviders());
                continue;
            }
            if (realPath.startsWith(MANGLE_NAMESPACE_OUT_PREFIX)) {
                this.log.debug("resolve: Try absolute mapped path {}", (Object)realPath);
                res = this.resolveInternal(realPath);
                continue;
            }
            String[] searchPath = this.getSearchPath();
            for (int spi = 0; res == null && spi < searchPath.length; ++spi) {
                this.log.debug("resolve: Try relative mapped path with search path entry {}", (Object)searchPath[spi]);
                res = this.resolveInternal(searchPath[spi] + realPath);
            }
        }
        if (res == null) {
            String resourcePath = this.ensureAbsPath(realPathList[0]);
            this.log.debug("resolve: Path {} does not resolve, returning NonExistingResource at {}", (Object)absPath, (Object)resourcePath);
            res = new NonExistingResource((ResourceResolver)this, resourcePath);
            int index = resourcePath.indexOf(46);
            if (index != -1) {
                res.getResourceMetadata().setResolutionPathInfo(resourcePath.substring(index));
            }
        } else {
            this.log.debug("resolve: Path {} resolves to Resource {}", (Object)absPath, res);
        }
        return res;
    }

    public String map(String resourcePath) {
        return this.map(null, resourcePath);
    }

    public String map(HttpServletRequest request, String resourcePath) {
        String schemehostport;
        String mappedPath;
        String fragmentQuery;
        int fragmentQueryMark = resourcePath.indexOf(35);
        if (fragmentQueryMark < 0) {
            fragmentQueryMark = resourcePath.indexOf(63);
        }
        if (fragmentQueryMark >= 0) {
            fragmentQuery = resourcePath.substring(fragmentQueryMark);
            mappedPath = resourcePath.substring(0, fragmentQueryMark);
            this.log.debug("map: Splitting resource path '{}' into '{}' and '{}'", new Object[]{resourcePath, mappedPath, fragmentQuery});
        } else {
            fragmentQuery = null;
            mappedPath = resourcePath;
        }
        if (request != null) {
            schemehostport = MapEntry.getURI(request.getScheme(), request.getServerName(), request.getServerPort(), MANGLE_NAMESPACE_OUT_PREFIX);
            this.log.debug("map: Mapping path {} for {}", (Object)resourcePath, (Object)schemehostport);
        } else {
            schemehostport = null;
            this.log.debug("map: Mapping path {} for default", (Object)resourcePath);
        }
        Resource res = this.resolveInternal(mappedPath);
        if (res != null) {
            String resolutionPathInfo = res.getResourceMetadata().getResolutionPathInfo();
            this.log.debug("map: Path maps to resource {} with path info {}", (Object)res, (Object)resolutionPathInfo);
            LinkedList<String> names = new LinkedList<String>();
            while (res != null) {
                String alias = this.getProperty(res, PROP_ALIAS);
                if (alias == null) {
                    alias = ResourceUtil.getName((Resource)res);
                }
                if (alias != null && alias.length() > 0) {
                    names.add(alias);
                }
                res = ResourceUtil.getParent((Resource)res);
            }
            StringBuilder buf = new StringBuilder();
            while (!names.isEmpty()) {
                buf.append('/');
                buf.append((String)names.removeLast());
            }
            if (resolutionPathInfo != null) {
                buf.append(resolutionPathInfo);
            }
            mappedPath = buf.toString();
            this.log.debug("map: Alias mapping resolves to path {}", (Object)mappedPath);
        }
        boolean mappedPathIsUrl = false;
        for (MapEntry mapEntry : this.resourceMapper.getMapMaps()) {
            String[] mappedPaths = mapEntry.replace(mappedPath);
            if (mappedPaths == null) continue;
            this.log.debug("map: Match for Entry {}", (Object)mapEntry);
            mappedPath = mappedPaths[0];
            boolean bl = mappedPathIsUrl = !mapEntry.isInternal();
            if (mappedPathIsUrl && schemehostport != null) {
                for (String candidate : mappedPaths) {
                    if (!candidate.startsWith(schemehostport)) continue;
                    mappedPath = candidate.substring(schemehostport.length() - 1);
                    mappedPathIsUrl = false;
                    this.log.debug("map: Found host specific mapping {} resolving to {}", (Object)candidate, (Object)mappedPath);
                    break;
                }
            }
            this.log.debug("resolve: MapEntry {} matches, mapped path is {}", (Object)mapEntry, (Object)mappedPath);
            break;
        }
        if (mappedPath == null) {
            mappedPath = resourcePath;
        }
        if (mappedPathIsUrl) {
            try {
                URI uri = new URI(mappedPath);
                String path = this.mangleNamespaces(uri.getPath());
                if (request != null && request.getContextPath() != null && request.getContextPath().length() > 0) {
                    path = request.getContextPath().concat(path);
                }
                mappedPath = new URI(uri.getScheme(), uri.getAuthority(), path, uri.getQuery(), uri.getFragment()).toString();
            }
            catch (URISyntaxException use) {
                this.log.warn("map: Unable to mangle namespaces for " + mappedPath + " returning unmangled", (Throwable)use);
            }
            this.log.debug("map: Returning URL {} as mapping for path {}", (Object)mappedPath, (Object)resourcePath);
        } else {
            mappedPath = this.mangleNamespaces(mappedPath);
            if (request != null && request.getContextPath() != null && request.getContextPath().length() > 0) {
                mappedPath = request.getContextPath().concat(mappedPath);
            }
            this.log.debug("map: Returning path {} (after mangling, incl. context) for {}", (Object)mappedPath, (Object)resourcePath);
        }
        if (fragmentQuery != null) {
            mappedPath = mappedPath.concat(fragmentQuery);
        }
        return mappedPath;
    }

    public String[] getSearchPath() {
        return (String[])this.factory.getSearchPath().clone();
    }

    public Resource getResource(String path) {
        if (path.startsWith(MANGLE_NAMESPACE_OUT_PREFIX)) {
            return (path = ResourceUtil.normalize((String)path)) != null ? this.getResourceInternal(path) : null;
        }
        for (String prefix : this.factory.getSearchPath()) {
            Resource res = this.getResource(prefix + path);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public Resource getResource(Resource base, String path) {
        if (!path.startsWith(MANGLE_NAMESPACE_OUT_PREFIX) && base != null) {
            path = base.getPath() + MANGLE_NAMESPACE_OUT_PREFIX + path;
        }
        return this.getResource(path);
    }

    public Iterator<Resource> listChildren(Resource parent) {
        return this.rootProvider.listChildren(parent);
    }

    public Iterator<Resource> findResources(String query, String language) throws SlingException {
        try {
            QueryResult res = JcrResourceUtil.query(this.getSession(), query, language);
            return new JcrNodeResourceIterator(this, res.getNodes(), this.rootProvider.getResourceTypeProviders(), this.factory.getDynamicClassLoader());
        }
        catch (InvalidQueryException iqe) {
            throw new QuerySyntaxException(iqe.getMessage(), query, language, (Throwable)iqe);
        }
        catch (RepositoryException re) {
            throw new SlingException(re.getMessage(), (Throwable)re);
        }
    }

    public Iterator<Map<String, Object>> queryResources(String query, String language) throws SlingException {
        try {
            QueryResult result = JcrResourceUtil.query(this.getSession(), query, language);
            final String[] colNames = result.getColumnNames();
            final RowIterator rows = result.getRows();
            return new Iterator<Map<String, Object>>(){

                @Override
                public boolean hasNext() {
                    return rows.hasNext();
                }

                @Override
                public Map<String, Object> next() {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    try {
                        Value[] values = rows.nextRow().getValues();
                        for (int i = 0; i < values.length; ++i) {
                            Value v = values[i];
                            if (v == null) continue;
                            row.put(colNames[i], JcrResourceUtil.toJavaObject(values[i]));
                        }
                    }
                    catch (RepositoryException re) {
                        JcrResourceResolver2.this.log.error("queryResources$next: Problem accessing row values", (Throwable)re);
                    }
                    return row;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }
        catch (InvalidQueryException iqe) {
            throw new QuerySyntaxException(iqe.getMessage(), query, language, (Throwable)iqe);
        }
        catch (RepositoryException re) {
            throw new SlingException(re.getMessage(), (Throwable)re);
        }
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Session.class) {
            return (AdapterType)this.getSession();
        }
        return (AdapterType)super.adaptTo(type);
    }

    private Session getSession() {
        return this.rootProvider.getSession();
    }

    public static String getMapPath(String scheme, String host, int port, String path) {
        if (port < 0) {
            port = "https".equals(scheme) ? 443 : 80;
        }
        return scheme + MANGLE_NAMESPACE_OUT_PREFIX + host + "." + port + path;
    }

    private Resource resolveInternal(String absPath) {
        Resource resource = null;
        String curPath = absPath;
        try {
            ResourcePathIterator it = new ResourcePathIterator(absPath);
            while (it.hasNext() && resource == null) {
                curPath = it.next();
                resource = this.getResourceInternal(curPath);
            }
        }
        catch (Exception ex) {
            throw new SlingException("Problem trying " + curPath + " for request path " + absPath, (Throwable)ex);
        }
        if (resource != null) {
            String rpi = absPath.substring(curPath.length());
            resource.getResourceMetadata().setResolutionPathInfo(rpi);
            this.log.debug("resolveInternal: Found resource {} with path info {} for {}", new Object[]{resource, rpi, absPath});
        } else {
            resource = this.getResourceInternal(MANGLE_NAMESPACE_OUT_PREFIX);
            StringBuilder resolutionPath = new StringBuilder();
            StringTokenizer tokener = new StringTokenizer(absPath, MANGLE_NAMESPACE_OUT_PREFIX);
            while (resource != null && tokener.hasMoreTokens()) {
                String childNameRaw = tokener.nextToken();
                Resource nextResource = this.getChildInternal(resource, childNameRaw);
                if (nextResource != null) {
                    resource = nextResource;
                    resolutionPath.append(MANGLE_NAMESPACE_OUT_PREFIX).append(childNameRaw);
                    continue;
                }
                String childName = null;
                ResourcePathIterator rpi = new ResourcePathIterator(childNameRaw);
                while (rpi.hasNext() && nextResource == null) {
                    childName = rpi.next();
                    nextResource = this.getChildInternal(resource, childName);
                }
                resource = nextResource;
                resolutionPath.append(MANGLE_NAMESPACE_OUT_PREFIX).append(childName);
                if (nextResource == null) continue;
                break;
            }
            if (resource != null) {
                String path = resolutionPath.toString();
                String pathInfo = absPath.substring(path.length());
                resource.getResourceMetadata().setResolutionPath(path);
                resource.getResourceMetadata().setResolutionPathInfo(pathInfo);
                this.log.debug("resolveInternal: Found resource {} with path info {} for {}", new Object[]{resource, pathInfo, absPath});
            }
        }
        return resource;
    }

    private Resource getChildInternal(Resource parent, String childName) {
        Resource child = this.getResource(parent, childName);
        if (child != null) {
            String alias = this.getProperty(child, PROP_REDIRECT_INTERNAL);
            if (alias != null) {
                this.log.warn("getChildInternal: Internal redirect to {} for Resource {} is not supported yet, ignoring", (Object)alias, (Object)child);
            }
            return child;
        }
        Iterator<Resource> children = this.listChildren(parent);
        while (children.hasNext()) {
            child = children.next();
            String alias = this.getProperty(child, PROP_ALIAS);
            if (!childName.equals(alias)) continue;
            this.log.debug("getChildInternal: Found Resource {} with alias {} to use", (Object)child, (Object)childName);
            return child;
        }
        this.log.debug("getChildInternal: Resource {} has no child {}", (Object)parent, (Object)childName);
        return null;
    }

    protected Resource getResourceInternal(String path) {
        Resource resource = this.rootProvider.getResource(this, path);
        if (resource != null) {
            resource.getResourceMetadata().setResolutionPath(path);
            return resource;
        }
        this.log.debug("getResourceInternal: Cannot resolve path '{}' to a resource", (Object)path);
        return null;
    }

    public String getProperty(Resource res, String propName) {
        String prop;
        ValueMap props = (ValueMap)res.adaptTo(ValueMap.class);
        if (props != null && (prop = (String)props.get(propName, String.class)) != null) {
            this.log.debug("getProperty: Resource {} has property {}={}", new Object[]{res, propName, prop});
            return prop;
        }
        if ((res = this.getResource(res, "jcr:content")) != null) {
            return this.getProperty(res, propName);
        }
        return null;
    }

    private String ensureAbsPath(String path) {
        if (!path.startsWith(MANGLE_NAMESPACE_OUT_PREFIX)) {
            path = this.getSearchPath()[0] + path;
        }
        return path;
    }

    private String mangleNamespaces(String absPath) {
        if (this.factory.isMangleNamespacePrefixes() && absPath.contains(MANGLE_NAMESPACE_OUT_SUFFIX)) {
            Pattern p = Pattern.compile(MANGLE_NAMESPACE_OUT);
            Matcher m = p.matcher(absPath);
            StringBuffer buf = new StringBuffer();
            while (m.find()) {
                String replacement = MANGLE_NAMESPACE_IN_PREFIX + m.group(1) + MANGLE_NAMESPACE_IN_SUFFIX;
                m.appendReplacement(buf, replacement);
            }
            m.appendTail(buf);
            absPath = buf.toString();
        }
        return absPath;
    }

    private String unmangleNamespaces(String absPath) {
        if (this.factory.isMangleNamespacePrefixes() && absPath.contains(MANGLE_NAMESPACE_IN_PREFIX)) {
            Pattern p = Pattern.compile(MANGLE_NAMESPACE_IN);
            Matcher m = p.matcher(absPath);
            StringBuffer buf = new StringBuffer();
            while (m.find()) {
                String namespace = m.group(1);
                try {
                    this.getSession().getNamespaceURI(namespace);
                    String replacement = MANGLE_NAMESPACE_OUT_PREFIX + namespace + MANGLE_NAMESPACE_OUT_SUFFIX;
                    m.appendReplacement(buf, replacement);
                }
                catch (NamespaceException ne) {
                    this.log.debug("unmangleNamespaces: '{}' is not a prefix, not unmangling", (Object)namespace);
                }
                catch (RepositoryException re) {
                    this.log.warn("unmangleNamespaces: Problem checking namespace '{}'", (Object)namespace, (Object)re);
                }
            }
            m.appendTail(buf);
            absPath = buf.toString();
        }
        return absPath;
    }
}

