/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.jcr.Session;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.apache.sling.jcr.resource.JcrResourceTypeProvider;
import org.apache.sling.jcr.resource.internal.JcrResourceListener;
import org.apache.sling.jcr.resource.internal.JcrResourceResolver2;
import org.apache.sling.jcr.resource.internal.JcrResourceResolverWebConsolePlugin;
import org.apache.sling.jcr.resource.internal.helper.MapEntries;
import org.apache.sling.jcr.resource.internal.helper.Mapping;
import org.apache.sling.jcr.resource.internal.helper.ResourceProviderEntry;
import org.apache.sling.jcr.resource.internal.helper.ResourceProviderEntryException;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderEntry;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrResourceResolverFactoryImpl
implements JcrResourceResolverFactory {
    public static final String PROP_PATH = "resource.resolver.searchpath";
    private static final String PROP_MANGLE_NAMESPACES = "resource.resolver.manglenamespaces";
    private static final String PROP_ALLOW_DIRECT = "resource.resolver.allowDirect";
    private static final String PROP_VIRTUAL = "resource.resolver.virtual";
    private static final String PROP_MAPPING = "resource.resolver.mapping";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private SlingRepository repository;
    protected final List<JcrResourceTypeProviderEntry> jcrResourceTypeProviders = new ArrayList<JcrResourceTypeProviderEntry>();
    private JcrResourceTypeProvider[] jcrResourceTypeProvidersArray;
    private final List<ServiceReference> delayedResourceProviders = new LinkedList<ServiceReference>();
    protected List<ServiceReference> delayedJcrResourceTypeProviders = new LinkedList<ServiceReference>();
    protected ComponentContext componentContext;
    private MapEntries mapEntries = MapEntries.EMPTY;
    private Mapping[] mappings;
    private BidiMap virtualURLMap;
    private boolean allowDirect = false;
    private String[] searchPath;
    private ResourceProviderEntry rootProviderEntry = new ResourceProviderEntry("/", null, null);
    private boolean mangleNamespacePrefixes;
    private JcrResourceListener resourceListener;
    private ServiceTracker eventAdminTracker;
    private DynamicClassLoaderManager dynamicClassLoaderManager;
    private JcrResourceResolverWebConsolePlugin plugin;

    public ResourceResolver getResourceResolver(Session session) {
        JcrResourceProviderEntry sessionRoot = new JcrResourceProviderEntry(session, this.rootProviderEntry, this.getJcrResourceTypeProviders(), this.getDynamicClassLoader());
        return new JcrResourceResolver2(sessionRoot, this, this.mapEntries);
    }

    protected JcrResourceTypeProvider[] getJcrResourceTypeProviders() {
        return this.jcrResourceTypeProvidersArray;
    }

    ClassLoader getDynamicClassLoader() {
        DynamicClassLoaderManager dclm = this.dynamicClassLoaderManager;
        if (dclm != null) {
            return dclm.getDynamicClassLoader();
        }
        return null;
    }

    String virtualToRealUri(String virtualUri) {
        return this.virtualURLMap != null ? (String)this.virtualURLMap.get((Object)virtualUri) : null;
    }

    String realToVirtualUri(String realUri) {
        return this.virtualURLMap != null ? (String)this.virtualURLMap.getKey((Object)realUri) : null;
    }

    public BidiMap getVirtualURLMap() {
        return this.virtualURLMap;
    }

    public Mapping[] getMappings() {
        return this.mappings;
    }

    String[] getSearchPath() {
        return this.searchPath;
    }

    boolean isMangleNamespacePrefixes() {
        return this.mangleNamespacePrefixes;
    }

    MapEntries getMapEntries() {
        return this.mapEntries;
    }

    protected ResourceProviderEntry getRootProviderEntry() {
        return this.rootProviderEntry;
    }

    protected void activate(ComponentContext componentContext) {
        this.eventAdminTracker = new ServiceTracker(componentContext.getBundleContext(), EventAdmin.class.getName(), null);
        this.eventAdminTracker.open();
        this.componentContext = componentContext;
        Dictionary properties = componentContext.getProperties();
        TreeBidiMap virtuals = new TreeBidiMap();
        String[] virtualList = (String[])properties.get(PROP_VIRTUAL);
        for (int i = 0; virtualList != null && i < virtualList.length; ++i) {
            String[] parts = Mapping.split(virtualList[i]);
            virtuals.put((Object)parts[0], (Object)parts[2]);
        }
        this.virtualURLMap = virtuals;
        ArrayList<Mapping> maps = new ArrayList<Mapping>();
        String[] mappingList = (String[])properties.get(PROP_MAPPING);
        for (int i = 0; mappingList != null && i < mappingList.length; ++i) {
            maps.add(new Mapping(mappingList[i]));
        }
        Mapping[] tmp = maps.toArray(new Mapping[maps.size()]);
        Boolean directProp = (Boolean)properties.get(PROP_ALLOW_DIRECT);
        boolean bl = this.allowDirect = directProp != null ? directProp : true;
        if (this.allowDirect) {
            Mapping[] tmp2 = new Mapping[tmp.length + 1];
            tmp2[0] = Mapping.DIRECT;
            System.arraycopy(tmp, 0, tmp2, 1, tmp.length);
            this.mappings = tmp2;
        } else {
            this.mappings = tmp;
        }
        this.searchPath = OsgiUtil.toStringArray(properties.get(PROP_PATH));
        if (this.searchPath != null && this.searchPath.length > 0) {
            for (int i = 0; i < this.searchPath.length; ++i) {
                if (!this.searchPath[i].startsWith("/")) {
                    this.searchPath[i] = "/" + this.searchPath[i];
                }
                if (this.searchPath[i].endsWith("/")) continue;
                int n = i;
                this.searchPath[n] = this.searchPath[n] + "/";
            }
        }
        if (this.searchPath == null) {
            this.searchPath = new String[]{"/"};
        }
        this.mangleNamespacePrefixes = OsgiUtil.toBoolean(properties.get(PROP_MANGLE_NAMESPACES), (boolean)false);
        for (ServiceReference reference : this.delayedResourceProviders) {
            this.bindResourceProvider(reference);
        }
        this.delayedResourceProviders.clear();
        this.processDelayedJcrResourceTypeProviders();
        try {
            this.mapEntries = new MapEntries(this, this.getRepository());
            this.plugin = new JcrResourceResolverWebConsolePlugin(componentContext.getBundleContext(), this);
        }
        catch (Exception e) {
            this.log.error("activate: Cannot access repository, failed setting up Mapping Support", (Throwable)e);
        }
        try {
            this.resourceListener = new JcrResourceListener(this.repository, this, "/", "/", this.eventAdminTracker);
        }
        catch (Exception e) {
            this.log.error("activate: Cannot create resource listener; resource events for JCR resources will be disabled.", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        if (this.plugin != null) {
            this.plugin.dispose();
            this.plugin = null;
        }
        if (this.mapEntries != null) {
            this.mapEntries.dispose();
            this.mapEntries = MapEntries.EMPTY;
        }
        if (this.eventAdminTracker != null) {
            this.eventAdminTracker.close();
            this.eventAdminTracker = null;
        }
        if (this.resourceListener != null) {
            this.resourceListener.dispose();
            this.resourceListener = null;
        }
        this.componentContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDelayedJcrResourceTypeProviders() {
        List<JcrResourceTypeProviderEntry> list = this.jcrResourceTypeProviders;
        synchronized (list) {
            for (ServiceReference reference : this.delayedJcrResourceTypeProviders) {
                this.addJcrResourceTypeProvider(reference);
            }
            this.delayedJcrResourceTypeProviders.clear();
            this.updateJcrResourceTypeProvidersArray();
        }
    }

    protected void addJcrResourceTypeProvider(ServiceReference reference) {
        Long id = (Long)reference.getProperty("service.id");
        long ranking = -1L;
        if (reference.getProperty("service.ranking") != null) {
            ranking = (Long)reference.getProperty("service.ranking");
        }
        this.jcrResourceTypeProviders.add(new JcrResourceTypeProviderEntry(id, ranking, (JcrResourceTypeProvider)this.componentContext.locateService("JcrResourceTypeProvider", reference)));
        Collections.sort(this.jcrResourceTypeProviders, new Comparator<JcrResourceTypeProviderEntry>(){

            @Override
            public int compare(JcrResourceTypeProviderEntry o1, JcrResourceTypeProviderEntry o2) {
                if (o1.ranking < o2.ranking) {
                    return 1;
                }
                if (o1.ranking > o2.ranking) {
                    return -1;
                }
                if (o1.serviceId < o2.serviceId) {
                    return -1;
                }
                if (o1.serviceId > o2.serviceId) {
                    return 1;
                }
                return 0;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindResourceProvider(ServiceReference reference) {
        String serviceName = this.getServiceName(reference);
        if (this.componentContext == null) {
            this.log.debug("bindResourceProvider: Delaying {}", (Object)serviceName);
            this.delayedResourceProviders.add(reference);
        } else {
            this.log.debug("bindResourceProvider: Binding {}", (Object)serviceName);
            String[] roots = OsgiUtil.toStringArray((Object)reference.getProperty("provider.roots"));
            if (roots != null && roots.length > 0) {
                EventAdmin localEA = (EventAdmin)this.eventAdminTracker.getService();
                ResourceProvider provider = (ResourceProvider)this.componentContext.locateService("ResourceProvider", reference);
                JcrResourceResolverFactoryImpl jcrResourceResolverFactoryImpl = this;
                synchronized (jcrResourceResolverFactoryImpl) {
                    for (String root : roots) {
                        if (root.endsWith("/") && root.length() > 1) {
                            root = root.substring(0, root.length() - 1);
                        }
                        try {
                            this.rootProviderEntry.addResourceProvider(root, provider);
                            this.log.debug("bindResourceProvider: {}={} ({})", new Object[]{root, provider, serviceName});
                            if (localEA == null) continue;
                            Hashtable<String, String> props = new Hashtable<String, String>();
                            ((Dictionary)props).put("path", root);
                            localEA.postEvent(new Event("org/apache/sling/api/resource/ResourceProvider/ADDED", props));
                        }
                        catch (ResourceProviderEntryException rpee) {
                            this.log.error("bindResourceProvider: Cannot register ResourceProvider {} for {}: ResourceProvider {} is already registered", new Object[]{provider, root, rpee.getExisting().getResourceProvider()});
                        }
                    }
                }
            }
            this.log.debug("bindResourceProvider: Bound {}", (Object)serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindResourceProvider(ServiceReference reference) {
        String serviceName = this.getServiceName(reference);
        this.log.debug("unbindResourceProvider: Unbinding {}", (Object)serviceName);
        String[] roots = OsgiUtil.toStringArray((Object)reference.getProperty("provider.roots"));
        if (roots != null && roots.length > 0) {
            EventAdmin localEA = (EventAdmin)(this.eventAdminTracker != null ? this.eventAdminTracker.getService() : null);
            JcrResourceResolverFactoryImpl jcrResourceResolverFactoryImpl = this;
            synchronized (jcrResourceResolverFactoryImpl) {
                for (String root : roots) {
                    if (root.endsWith("/") && root.length() > 1) {
                        root = root.substring(0, root.length() - 1);
                    }
                    this.rootProviderEntry.removeResourceProvider(root);
                    this.log.debug("unbindResourceProvider: root={} ({})", (Object)root, (Object)serviceName);
                    if (localEA == null) continue;
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("path", root);
                    localEA.postEvent(new Event("org/apache/sling/api/resource/ResourceProvider/REMOVED", props));
                }
            }
        }
        this.log.debug("unbindResourceProvider: Unbound {}", (Object)serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindJcrResourceTypeProvider(ServiceReference reference) {
        List<JcrResourceTypeProviderEntry> list = this.jcrResourceTypeProviders;
        synchronized (list) {
            if (this.componentContext == null) {
                this.delayedJcrResourceTypeProviders.add(reference);
            } else {
                this.addJcrResourceTypeProvider(reference);
                this.updateJcrResourceTypeProvidersArray();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindJcrResourceTypeProvider(ServiceReference reference) {
        List<JcrResourceTypeProviderEntry> list = this.jcrResourceTypeProviders;
        synchronized (list) {
            this.delayedJcrResourceTypeProviders.remove(reference);
            long id = (Long)reference.getProperty("service.id");
            Iterator<JcrResourceTypeProviderEntry> i = this.jcrResourceTypeProviders.iterator();
            while (i.hasNext()) {
                JcrResourceTypeProviderEntry current = i.next();
                if (current.serviceId != id) continue;
                i.remove();
            }
            this.updateJcrResourceTypeProvidersArray();
        }
    }

    protected void updateJcrResourceTypeProvidersArray() {
        JcrResourceTypeProvider[] providers = null;
        if (this.jcrResourceTypeProviders.size() > 0) {
            providers = new JcrResourceTypeProvider[this.jcrResourceTypeProviders.size()];
            int index = 0;
            Iterator<JcrResourceTypeProviderEntry> i = this.jcrResourceTypeProviders.iterator();
            while (i.hasNext()) {
                providers[index] = i.next().provider;
                ++index;
            }
        }
        this.jcrResourceTypeProvidersArray = providers;
    }

    protected SlingRepository getRepository() {
        return this.repository;
    }

    private String getServiceName(ServiceReference reference) {
        if (this.log.isDebugEnabled()) {
            StringBuilder snBuilder = new StringBuilder(64);
            snBuilder.append('{');
            snBuilder.append(reference.toString());
            snBuilder.append('/');
            snBuilder.append(reference.getProperty("service.id"));
            snBuilder.append('}');
            return snBuilder.toString();
        }
        return null;
    }

    protected void bindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.dynamicClassLoaderManager = dynamicClassLoaderManager;
    }

    protected void unbindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        if (this.dynamicClassLoaderManager == dynamicClassLoaderManager) {
            this.dynamicClassLoaderManager = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected static final class JcrResourceTypeProviderEntry {
        final long serviceId;
        final long ranking;
        final JcrResourceTypeProvider provider;

        public JcrResourceTypeProviderEntry(long id, long ranking, JcrResourceTypeProvider p) {
            this.serviceId = id;
            this.ranking = ranking;
            this.provider = p;
        }
    }

    public static final class ResourcePattern {
        public final Pattern pattern;
        public final String replacement;

        public ResourcePattern(Pattern p, String r) {
            this.pattern = p;
            this.replacement = r;
        }
    }
}

