/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.ConfigurationPrinter;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.internal.JcrResourceResolverFactoryImpl;
import org.apache.sling.jcr.resource.internal.helper.MapEntries;
import org.apache.sling.jcr.resource.internal.helper.MapEntry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrResourceResolverWebConsolePlugin
extends AbstractWebConsolePlugin
implements ConfigurationPrinter {
    private static final long serialVersionUID = 0L;
    private static final String ATTR_TEST = "plugin.test";
    private static final String ATTR_SUBMIT = "plugin.submit";
    private static final String ATTR_RESULT = "plugin.result";
    private final transient JcrResourceResolverFactoryImpl resolverFactory;
    private transient ServiceRegistration service;

    JcrResourceResolverWebConsolePlugin(BundleContext context, JcrResourceResolverFactoryImpl resolverFactory) {
        this.resolverFactory = resolverFactory;
        this.activate(context);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "JCRResourceResolver2 Web Console Plugin");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("service.pid", ((Object)((Object)this)).getClass().getName());
        ((Dictionary)props).put("felix.webconsole.label", this.getLabel());
        this.service = context.registerService(new String[]{"javax.servlet.Servlet", ConfigurationPrinter.SERVICE}, (Object)this, props);
    }

    void dispose() {
        if (this.service != null) {
            this.service.unregister();
            this.deactivate();
            this.service = null;
        }
    }

    public String getLabel() {
        return "jcrresolver";
    }

    public String getTitle() {
        return "JCR ResourceResolver";
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String test = (String)request.getAttribute(ATTR_TEST);
        if (test == null) {
            test = "";
        }
        String result = (String)request.getAttribute(ATTR_RESULT);
        PrintWriter pw = response.getWriter();
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        MapEntries mapEntries = this.resolverFactory.getMapEntries();
        this.titleHtml(pw, "Configuration Test", "To test the configuration, enter an URL or a resource path into the field and click 'Resolve' to resolve the URL or click 'Map' to map the resource path");
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>Test</td>");
        pw.print("<td class='content' colspan='2'>");
        pw.print("<form method='post'>");
        pw.println("<input type='text' name='plugin.test' value='" + test + "' class='input' size='50'>");
        pw.println("&nbsp;&nbsp;<input type='submit' name='plugin.submit' value='Resolve' class='submit'>");
        pw.println("&nbsp;&nbsp;<input type='submit' name='plugin.submit' value='Map' class='submit'>");
        pw.print("</form>");
        pw.print("</td>");
        pw.println("</tr>");
        if (result != null) {
            pw.println("<tr class='content'>");
            pw.println("<td class='content'>&nbsp;</td>");
            pw.println("<td class='content' colspan='2'>" + result + "</td>");
            pw.println("</tr>");
        }
        this.separator(pw);
        this.dumpMapHtml(pw, "Resolver Map Entries", "Lists the entries used by the ResourceResolver.resolve methods to map URLs to Resources", mapEntries.getResolveMaps());
        this.separator(pw);
        this.dumpMapHtml(pw, "Mapping Map Entries", "Lists the entries used by the ResourceResolver.map methods to map Resource Paths to URLs", mapEntries.getMapMaps());
        pw.println("</table>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String test = request.getParameter(ATTR_TEST);
        if (test != null && test.length() > 0) {
            request.setAttribute(ATTR_TEST, (Object)test);
            Session session = null;
            try {
                ResolverRequest helper = new ResolverRequest(request, test);
                session = this.resolverFactory.getRepository().loginAdministrative(null);
                ResourceResolver resolver = this.resolverFactory.getResourceResolver(session);
                String result = "Map".equals(request.getParameter(ATTR_SUBMIT)) ? resolver.map((HttpServletRequest)helper, helper.getPathInfo()) : resolver.resolve((HttpServletRequest)helper, helper.getPathInfo());
                request.setAttribute(ATTR_RESULT, (Object)result.toString());
            }
            catch (Throwable t) {
                request.setAttribute(ATTR_RESULT, (Object)("Test Failure: " + t));
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
        this.doGet(request, response);
    }

    public void printConfiguration(PrintWriter pw) {
        MapEntries mapEntries = this.resolverFactory.getMapEntries();
        this.dumpMapText(pw, "Resolver Map Entries", mapEntries.getResolveMaps());
        this.separator(pw);
        this.dumpMapText(pw, "Mapping Map Entries", mapEntries.getMapMaps());
    }

    private void dumpMapHtml(PrintWriter pw, String title, String description, Collection<MapEntry> list) {
        this.titleHtml(pw, title, description);
        pw.println("<tr class='content'>");
        pw.println("<th class='content'>Pattern</th>");
        pw.println("<th class='content'>Replacement</th>");
        pw.println("<th class='content'>Redirect</th>");
        pw.println("</tr>");
        for (MapEntry entry : list) {
            String[] repls;
            pw.println("<tr class='content'>");
            pw.println("<td class='content' style='vertical-align: top'>" + entry.getPattern() + "</td>");
            pw.print("<td class='content' style='vertical-align: top'>");
            for (String repl : repls = entry.getRedirect()) {
                pw.print(repl + "<br/>");
            }
            pw.println("</td>");
            pw.print("<td class='content' style='vertical-align: top'>");
            if (entry.isInternal()) {
                pw.print("internal");
            } else {
                pw.print("external: " + entry.getStatus());
            }
            pw.println("</td>");
        }
    }

    private void titleHtml(PrintWriter pw, String title, String description) {
        pw.println("<tr class='content'>");
        pw.println("<th colspan='3'class='content container'>" + title + "</th>");
        pw.println("</tr>");
        if (description != null) {
            pw.println("<tr class='content'>");
            pw.println("<td colspan='3'class='content'>" + description + "</th>");
            pw.println("</tr>");
        }
    }

    private void dumpMapText(PrintWriter pw, String title, Collection<MapEntry> list) {
        pw.println(title);
        String format = "%25s%25s%15s\r\n";
        pw.printf("%25s%25s%15s\r\n", "Pattern", "Replacement", "Redirect");
        for (MapEntry entry : list) {
            List<String> redir = Arrays.asList(entry.getRedirect());
            String status = entry.isInternal() ? "internal" : "external: " + entry.getStatus();
            pw.printf("%25s%25s%15s\r\n", entry.getPattern(), redir, status);
        }
    }

    private void separator(PrintWriter pw) {
        pw.println("<tr class='content'>");
        pw.println("<td class='content' colspan='3'>&nbsp;</td>");
        pw.println("</tr>");
    }

    private static class ResolverRequest
    extends HttpServletRequestWrapper {
        private final URI uri;

        public ResolverRequest(HttpServletRequest request, String uriString) throws URISyntaxException {
            super(request);
            this.uri = new URI(uriString);
        }

        public String getScheme() {
            return this.uri.getScheme();
        }

        public String getServerName() {
            return this.uri.getHost();
        }

        public int getServerPort() {
            return this.uri.getPort();
        }

        public String getPathInfo() {
            return this.uri.getPath();
        }
    }
}

