/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.commons.collections.BidiMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.JcrResourceResolver2;
import org.apache.sling.jcr.resource.internal.JcrResourceResolverFactoryImpl;
import org.apache.sling.jcr.resource.internal.helper.MapEntry;
import org.apache.sling.jcr.resource.internal.helper.Mapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapEntries
implements EventListener {
    public static MapEntries EMPTY = new MapEntries();
    private static final String ANY_SCHEME_HOST = "[^/]+/[^/]+";
    private static final String MAP_ROOT = "/etc/map";
    private static final String MAP_ROOT_PREFIX = "/etc/map/";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JcrResourceResolverFactoryImpl factory;
    private JcrResourceResolver2 resolver;
    private Session session;
    private List<MapEntry> resolveMaps;
    private Collection<MapEntry> mapMaps;
    private boolean initializing = false;

    private MapEntries() {
        this.session = null;
        this.factory = null;
        this.resolver = null;
        this.resolveMaps = Collections.emptyList();
        this.mapMaps = Collections.emptyList();
    }

    public MapEntries(JcrResourceResolverFactoryImpl factory, SlingRepository repository) throws RepositoryException {
        this.factory = factory;
        this.session = repository.loginAdministrative(null);
        this.resolver = (JcrResourceResolver2)factory.getResourceResolver(this.session);
        this.init();
        try {
            this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 255, "/", true, null, null, false);
        }
        catch (RepositoryException re) {
            this.log.error("MapEntries<init>: Failed registering as observation listener", (Throwable)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        MapEntries mapEntries = this;
        synchronized (mapEntries) {
            if (this.session == null) {
                return;
            }
            this.initializing = true;
        }
        try {
            ArrayList<MapEntry> newResolveMaps = new ArrayList<MapEntry>();
            TreeMap<String, MapEntry> newMapMaps = new TreeMap<String, MapEntry>();
            this.loadResolverMap(this.resolver, newResolveMaps, newMapMaps);
            this.loadVanityPaths(this.resolver, newResolveMaps);
            this.loadConfiguration(this.factory, newResolveMaps);
            this.loadMapConfiguration(this.factory, newMapMaps);
            this.resolveMaps = newResolveMaps;
            this.mapMaps = new TreeSet(newMapMaps.values());
        }
        finally {
            mapEntries = this;
            synchronized (mapEntries) {
                this.initializing = false;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Session oldSession;
        MapEntries mapEntries = this;
        synchronized (mapEntries) {
            if (this.initializing) {
                try {
                    this.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            oldSession = this.session;
            this.session = null;
        }
        if (oldSession != null) {
            try {
                oldSession.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
            }
            catch (RepositoryException re) {
                this.log.error("dispose: Failed unregistering as observation listener", (Throwable)re);
            }
            try {
                oldSession.logout();
            }
            catch (Exception e) {
                this.log.error("dispose: Unexpected problem logging out", (Throwable)e);
            }
        }
        this.resolver = null;
        this.factory = null;
    }

    public List<MapEntry> getResolveMaps() {
        return this.resolveMaps;
    }

    public Collection<MapEntry> getMapMaps() {
        return this.mapMaps;
    }

    public Session getSession() {
        return this.session;
    }

    public void onEvent(EventIterator events) {
        boolean handleEvent = false;
        while (!handleEvent && this.session != null && events.hasNext()) {
            Event event = events.nextEvent();
            try {
                String path = event.getPath();
                handleEvent = MAP_ROOT.equals(path) || path.startsWith(MAP_ROOT_PREFIX) || path.endsWith("/sling:vanityPath") || path.endsWith("/sling:vanityOrder") || path.endsWith("/sling:redirect");
            }
            catch (Throwable t) {
                this.log.warn("onEvent: Cannot complete event handling", t);
            }
        }
        if (handleEvent) {
            if (this.session != null) {
                try {
                    this.init();
                }
                catch (Throwable t) {
                    this.log.warn("onEvent: Failed initializing after changes", t);
                }
            } else {
                this.log.info("onEvent: Already disposed, not reinitializing");
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("onEvent: Ignoring irrelevant events");
        }
    }

    private void loadResolverMap(JcrResourceResolver2 resolver, Collection<MapEntry> resolveEntries, Map<String, MapEntry> mapEntries) {
        Resource res = resolver.getResource(MAP_ROOT);
        if (res != null) {
            this.gather(resolver, resolveEntries, mapEntries, res, "");
        }
    }

    private void gather(JcrResourceResolver2 resolver, Collection<MapEntry> resolveEntries, Map<String, MapEntry> mapEntries, Resource parent, String parentPath) {
        Iterator children = ResourceUtil.listChildren((Resource)parent);
        while (children.hasNext()) {
            List<MapEntry> childMapEntries;
            MapEntry childResolveEntry;
            String childPath;
            Resource child = (Resource)children.next();
            String name = resolver.getProperty(child, "sling:match");
            boolean trailingSlash = false;
            if (name == null) {
                name = ResourceUtil.getName((Resource)child).concat("/");
                trailingSlash = true;
            }
            if (!(childPath = parentPath.concat(name)).endsWith("$")) {
                String childParent = childPath;
                if (!trailingSlash) {
                    childParent = childParent.concat("/");
                }
                this.gather(resolver, resolveEntries, mapEntries, child, childParent);
            }
            if ((childResolveEntry = MapEntry.createResolveEntry(childPath, child, trailingSlash)) != null) {
                resolveEntries.add(childResolveEntry);
            }
            if ((childMapEntries = MapEntry.createMapEntry(childPath, child, trailingSlash)) == null) continue;
            for (MapEntry mapEntry : childMapEntries) {
                this.addMapEntry(mapEntries, mapEntry.getPattern(), mapEntry.getRedirect()[0], mapEntry.getStatus());
            }
        }
    }

    private void loadVanityPaths(JcrResourceResolver2 resolver, List<MapEntry> entries) {
        String queryString = "SELECT sling:vanityPath, sling:redirect FROM sling:VanityPath WHERE sling:vanityPath IS NOT NULL ORDER BY sling:vanityOrder DESC";
        Iterator<Resource> i = resolver.findResources("SELECT sling:vanityPath, sling:redirect FROM sling:VanityPath WHERE sling:vanityPath IS NOT NULL ORDER BY sling:vanityOrder DESC", "sql");
        while (i.hasNext()) {
            String[] pVanityPaths;
            Resource resource = i.next();
            ValueMap row = (ValueMap)resource.adaptTo(ValueMap.class);
            if (row == null) continue;
            for (String pVanityPath : pVanityPaths = (String[])row.get("sling:vanityPath", (Object)new String[0])) {
                if (pVanityPath == null || pVanityPath.trim().length() <= 0) continue;
                String url = "^[^/]+/[^/]+" + pVanityPath.trim();
                String redirect = resource.getPath();
                if (ResourceUtil.getName((String)redirect).equals("jcr:content")) {
                    redirect = ResourceUtil.getParent((String)redirect);
                }
                int status = (Boolean)row.get("sling:redirect", (Object)false) != false ? 302 : -1;
                entries.add(new MapEntry(url + "$", status, false, redirect + ".html"));
                entries.add(new MapEntry(url + "(\\..*)", status, false, redirect + "$1"));
            }
        }
    }

    private void loadConfiguration(JcrResourceResolverFactoryImpl factory, List<MapEntry> entries) {
        Mapping[] mappings;
        BidiMap virtuals = factory.getVirtualURLMap();
        if (virtuals != null) {
            for (Map.Entry virtualEntry : virtuals.entrySet()) {
                String intPath;
                String extPath = (String)virtualEntry.getKey();
                if (extPath.equals(intPath = (String)virtualEntry.getValue())) continue;
                String url = "^[^/]+/[^/]+" + extPath + "$";
                String redirect = intPath;
                entries.add(new MapEntry(url, -1, false, redirect));
            }
        }
        if ((mappings = factory.getMappings()) != null) {
            HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
            for (Mapping mapping : mappings) {
                if (!mapping.mapsInbound()) continue;
                String url = mapping.getTo();
                String alias = mapping.getFrom();
                if (url.length() <= 0) continue;
                ArrayList<String> aliasList = (ArrayList<String>)map.get(url);
                if (aliasList == null) {
                    aliasList = new ArrayList<String>();
                    map.put(url, aliasList);
                }
                aliasList.add(alias);
            }
            for (Map.Entry entry : map.entrySet()) {
                entries.add(new MapEntry(ANY_SCHEME_HOST + (String)entry.getKey(), -1, false, ((List)entry.getValue()).toArray(new String[0])));
            }
        }
    }

    private void loadMapConfiguration(JcrResourceResolverFactoryImpl factory, Map<String, MapEntry> entries) {
        BidiMap virtuals;
        Mapping[] mappings = factory.getMappings();
        if (mappings != null) {
            for (int i = mappings.length - 1; i >= 0; --i) {
                String alias;
                String url;
                Mapping mapping = mappings[i];
                if (!mapping.mapsOutbound() || (url = mapping.getTo()).equals(alias = mapping.getFrom())) continue;
                this.addMapEntry(entries, alias, url, -1);
            }
        }
        if ((virtuals = factory.getVirtualURLMap()) != null) {
            for (Map.Entry virtualEntry : virtuals.entrySet()) {
                String intPath;
                String extPath = (String)virtualEntry.getKey();
                if (extPath.equals(intPath = (String)virtualEntry.getValue())) continue;
                String path = "^" + intPath + "$";
                String url = extPath;
                this.addMapEntry(entries, path, url, -1);
            }
        }
    }

    private void addMapEntry(Map<String, MapEntry> entries, String path, String url, int status) {
        MapEntry entry = entries.get(path);
        if (entry == null) {
            entry = new MapEntry(path, status, false, url);
        } else {
            String[] redir = entry.getRedirect();
            String[] newRedir = new String[redir.length + 1];
            System.arraycopy(redir, 0, newRedir, 0, redir.length);
            newRedir[redir.length] = url;
            entry = new MapEntry(entry.getPattern(), entry.getStatus(), false, newRedir);
        }
        entries.put(path, entry);
    }
}

