/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.jcr.resource.internal.helper.ResourceProviderEntryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceProviderEntry
implements Comparable<ResourceProviderEntry> {
    private final String path;
    private final String prefix;
    private final ResourceProvider provider;
    private ResourceProviderEntry[] entries;

    public ResourceProviderEntry(String path, ResourceProvider provider) {
        this(path, provider, null);
    }

    public ResourceProviderEntry(String path, ResourceProvider provider, ResourceProviderEntry[] entries) {
        if (path.endsWith("/")) {
            this.path = path.substring(0, path.length() - 1);
            this.prefix = path;
        } else {
            this.path = path;
            this.prefix = path + "/";
        }
        this.provider = provider;
        this.entries = entries;
    }

    public ResourceProvider getResourceProvider() {
        return this.provider;
    }

    public ResourceProviderEntry[] getEntries() {
        return this.entries;
    }

    public Resource getResource(ResourceResolver resourceResolver, String path) {
        return this.getResource(resourceResolver, path, path);
    }

    public Iterator<Resource> listChildren(final Resource resource) {
        return new Iterator<Resource>(){
            private final Iterator<ResourceProvider> providers;
            private Iterator<Resource> resources;
            private Resource nextResource;
            private Map<String, Resource> delayed;
            private Set<String> visited;
            private Iterator<Resource> delayedIter;
            {
                String path = resource.getPath();
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                LinkedHashSet providersSet = new LinkedHashSet();
                ResourceProviderEntry.this.getResourceProviders(path, providersSet);
                this.providers = providersSet.iterator();
                this.delayed = new HashMap<String, Resource>();
                this.visited = new HashSet<String>();
                this.nextResource = this.seek();
            }

            @Override
            public boolean hasNext() {
                return this.nextResource != null;
            }

            @Override
            public Resource next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Resource result = this.nextResource;
                this.nextResource = this.seek();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }

            private Resource seek() {
                block4: {
                    String resPath;
                    Resource res;
                    while (true) {
                        if ((this.resources == null || !this.resources.hasNext()) && this.providers.hasNext()) {
                            ResourceProvider provider = this.providers.next();
                            this.resources = provider.listChildren(resource);
                            continue;
                        }
                        if (this.resources == null || !this.resources.hasNext()) break block4;
                        res = this.resources.next();
                        resPath = res.getPath();
                        if (this.visited.contains(resPath)) {
                            this.delayed.remove(resPath);
                            continue;
                        }
                        if (!(res instanceof SyntheticResource)) break;
                        this.delayed.put(resPath, res);
                    }
                    this.visited.add(resPath);
                    return res;
                }
                if (this.delayedIter == null) {
                    this.delayedIter = this.delayed.values().iterator();
                }
                return this.delayedIter.hasNext() ? this.delayedIter.next() : null;
            }
        };
    }

    public boolean addResourceProvider(String prefix, ResourceProvider provider) {
        if (prefix.equals(this.path)) {
            throw new ResourceProviderEntryException("ResourceProviderEntry for prefix already exists", this);
        }
        if (prefix.startsWith(this.prefix)) {
            prefix = prefix.substring(this.prefix.length());
            if (this.entries != null) {
                for (int i = 0; i < this.entries.length; ++i) {
                    ResourceProviderEntry entry = this.entries[i];
                    if (entry.addResourceProvider(prefix, provider)) {
                        return true;
                    }
                    if (!entry.prefix.startsWith(prefix) || entry.prefix.charAt(prefix.length()) != '/') continue;
                    ResourceProviderEntry newEntry = new ResourceProviderEntry(prefix, provider);
                    newEntry.addResourceProvider(entry.path, entry.provider);
                    this.entries[i] = newEntry;
                    return true;
                }
            }
            ResourceProviderEntry entry = new ResourceProviderEntry(prefix, provider);
            if (this.entries == null) {
                this.entries = new ResourceProviderEntry[]{entry};
            } else {
                TreeSet<ResourceProviderEntry> set = new TreeSet<ResourceProviderEntry>();
                set.addAll(Arrays.asList(this.entries));
                set.add(entry);
                this.entries = set.toArray(new ResourceProviderEntry[set.size()]);
            }
            return true;
        }
        return false;
    }

    public boolean removeResourceProvider(String prefix) {
        if (prefix.equals(this.path)) {
            return true;
        }
        if (prefix.startsWith(this.prefix)) {
            prefix = prefix.substring(this.prefix.length());
            if (this.entries != null) {
                for (int i = 0; i < this.entries.length; ++i) {
                    ResourceProviderEntry entry = this.entries[i];
                    if (!entry.removeResourceProvider(prefix)) continue;
                    if (this.entries.length == 1) {
                        this.entries = null;
                    } else {
                        int newEntriesLen = this.entries.length - 1;
                        ResourceProviderEntry[] newEntries = new ResourceProviderEntry[newEntriesLen];
                        if (i > 0) {
                            System.arraycopy(this.entries, 0, newEntries, 0, i);
                        }
                        if (i < newEntriesLen) {
                            System.arraycopy(this.entries, i + 1, newEntries, i, newEntriesLen - i);
                        }
                        this.entries = newEntries;
                    }
                    ResourceProviderEntry[] children = entry.entries;
                    if (children != null) {
                        String pathPrefix = this.prefix + entry.prefix;
                        for (ResourceProviderEntry child : children) {
                            String path = pathPrefix + child.path;
                            this.addResourceProvider(path, child.provider);
                        }
                    }
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public int compareTo(ResourceProviderEntry o) {
        return this.prefix.compareTo(o.prefix);
    }

    private Resource getResource(ResourceResolver resourceResolver, String path, String fullPath) {
        if (path.equals(this.path)) {
            return this.getResourceProvider().getResource(resourceResolver, fullPath);
        }
        if (path.startsWith(this.prefix)) {
            Resource resource;
            ResourceProviderEntry[] entries = this.getEntries();
            if (entries != null) {
                path = path.substring(this.prefix.length());
                for (ResourceProviderEntry entry : entries) {
                    Resource test = entry.getResource(resourceResolver, path, fullPath);
                    if (test == null) continue;
                    return test;
                }
            }
            if ((resource = this.getResourceProvider().getResource(resourceResolver, fullPath)) == null && entries != null) {
                String checkPath = path.concat("/");
                for (ResourceProviderEntry entry : entries) {
                    if (!entry.path.startsWith(checkPath)) continue;
                    resource = new SyntheticResource(resourceResolver, fullPath, "sling:syntheticResourceProviderResource");
                    break;
                }
            }
            return resource;
        }
        return null;
    }

    private void getResourceProviders(String path, Set<ResourceProvider> providers) {
        if (path.startsWith(this.prefix)) {
            ResourceProviderEntry[] entries = this.getEntries();
            if (entries != null) {
                path = path.substring(this.prefix.length());
                for (ResourceProviderEntry entry : entries) {
                    if (path.length() == 0) {
                        providers.add(entry.getResourceProvider());
                        continue;
                    }
                    entry.getResourceProviders(path, providers);
                }
            }
            providers.add(this.getResourceProvider());
        } else if (this.prefix.startsWith(path)) {
            providers.add(this.getResourceProvider());
        }
    }
}

