/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.starresource;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.jcr.resource.JcrResourceTypeProvider;
import org.apache.sling.jcr.resource.internal.helper.starresource.FakeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StarResource
extends SyntheticResource {
    static final String SLASH_STAR = "/*";
    public static final String DEFAULT_RESOURCE_TYPE = "sling:syntheticStarResource";
    private static final String UNSET_RESOURCE_SUPER_TYPE = "<unset>";
    private String resourceSuperType = "<unset>";

    public static boolean appliesTo(String path) {
        return path.contains(SLASH_STAR) || path.endsWith(SLASH_STAR);
    }

    public static boolean isStarResource(Resource res) {
        return res.getPath().endsWith(SLASH_STAR);
    }

    public StarResource(ResourceResolver resourceResolver, String path, JcrResourceTypeProvider[] jcrProviders) throws SlingException {
        super(resourceResolver, StarResource.getResourceMetadata(path), StarResource.getResourceType(jcrProviders, path));
    }

    public <Type> Type adaptTo(Class<Type> type) {
        if (type == Node.class) {
            return (Type)new FakeNode(this.getPath());
        }
        if (type == String.class) {
            return (Type)"";
        }
        return null;
    }

    public String getResourceSuperType() {
        if (this.resourceSuperType == UNSET_RESOURCE_SUPER_TYPE) {
            this.resourceSuperType = ResourceUtil.getResourceSuperType((ResourceResolver)this.getResourceResolver(), (String)this.getResourceType());
        }
        return this.resourceSuperType;
    }

    static ResourceMetadata getResourceMetadata(String path) {
        ResourceMetadata result = new ResourceMetadata();
        int index = path.indexOf(SLASH_STAR);
        if (index >= 0) {
            result.setResolutionPath(path.substring(0, index) + SLASH_STAR);
            result.setResolutionPathInfo(path.substring(index + SLASH_STAR.length()));
        } else {
            result.setResolutionPath(path);
        }
        return result;
    }

    static String getResourceType(JcrResourceTypeProvider[] jcrProviders, String path) {
        FakeNode n = new FakeNode(StarResource.getResourceMetadata(path).getResolutionPath());
        String resourceType = null;
        if (jcrProviders != null) {
            try {
                for (int index = 0; resourceType == null && index < jcrProviders.length; ++index) {
                    resourceType = jcrProviders[index].getResourceTypeForNode(n);
                }
            }
            catch (RepositoryException re) {
                throw new SyntheticStarResourceException("getResourceTypeForNode failed", re);
            }
        }
        if (resourceType == null) {
            resourceType = DEFAULT_RESOURCE_TYPE;
        }
        return resourceType;
    }

    static class SyntheticStarResourceException
    extends SlingException {
        SyntheticStarResourceException(String reason, Throwable cause) {
            super(reason, cause);
        }
    }
}

