/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Credentials;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.adapter.SlingAdaptable;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.QuerySyntaxException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.resource.JcrResourceUtil;
import org.apache.sling.jcr.resource.internal.JcrResourceResolverFactoryImpl;
import org.apache.sling.jcr.resource.internal.ResourceIteratorDecorator;
import org.apache.sling.jcr.resource.internal.WorkspaceDecoratedResource;
import org.apache.sling.jcr.resource.internal.helper.MapEntry;
import org.apache.sling.jcr.resource.internal.helper.RedirectResource;
import org.apache.sling.jcr.resource.internal.helper.ResourceIterator;
import org.apache.sling.jcr.resource.internal.helper.ResourcePathIterator;
import org.apache.sling.jcr.resource.internal.helper.URI;
import org.apache.sling.jcr.resource.internal.helper.URIException;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResourceIterator;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderEntry;
import org.apache.sling.jcr.resource.internal.helper.starresource.StarResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrResourceResolver
extends SlingAdaptable
implements ResourceResolver {
    private final Logger LOGGER = LoggerFactory.getLogger(JcrResourceResolver.class);
    private static final String MANGLE_NAMESPACE_IN_SUFFIX = "_";
    private static final String MANGLE_NAMESPACE_IN_PREFIX = "/_";
    private static final String MANGLE_NAMESPACE_IN = "/_([^_/]+)_";
    private static final String MANGLE_NAMESPACE_OUT_SUFFIX = ":";
    private static final String MANGLE_NAMESPACE_OUT_PREFIX = "/";
    private static final String MANGLE_NAMESPACE_OUT = "/([^:/]+):";
    public static final String PROP_REG_EXP = "sling:match";
    public static final String PROP_REDIRECT_INTERNAL = "sling:internalRedirect";
    public static final String PROP_ALIAS = "sling:alias";
    public static final String PROP_REDIRECT_EXTERNAL = "sling:redirect";
    public static final String PROP_REDIRECT_EXTERNAL_STATUS = "sling:status";
    private final JcrResourceProviderEntry rootProvider;
    private final JcrResourceResolverFactoryImpl factory;
    private final boolean isAdmin;
    private final Map<String, Object> originalAuthInfo;
    private Map<String, JcrResourceResolver> createdResolvers;
    private volatile boolean closed = false;
    private ResourceResolver requestBoundResolver;
    private final boolean useMultiWorkspaces;

    public JcrResourceResolver(JcrResourceProviderEntry rootProvider, JcrResourceResolverFactoryImpl factory, boolean isAdmin, Map<String, Object> originalAuthInfo, boolean useMultiWorkspaces) {
        this.rootProvider = rootProvider;
        this.factory = factory;
        this.isAdmin = isAdmin;
        this.originalAuthInfo = originalAuthInfo;
        this.useMultiWorkspaces = useMultiWorkspaces;
    }

    public ResourceResolver clone(Map<String, Object> authenticationInfo) throws LoginException {
        this.checkClosed();
        HashMap<String, Object> newAuthenticationInfo = new HashMap<String, Object>();
        if (this.originalAuthInfo != null) {
            newAuthenticationInfo.putAll(this.originalAuthInfo);
        }
        if (authenticationInfo != null) {
            newAuthenticationInfo.putAll(authenticationInfo);
        }
        if (this.isAdmin && !(newAuthenticationInfo.get("user.jcr.credentials") instanceof Credentials) && !(newAuthenticationInfo.get("user.jcr.session") instanceof Session) && !(newAuthenticationInfo.get("user.name") instanceof String)) {
            return this.factory.getAdministrativeResourceResolver(newAuthenticationInfo);
        }
        return this.factory.getResourceResolver(newAuthenticationInfo);
    }

    public boolean isLive() {
        return !this.closed && this.getSession().isLive();
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.closeCreatedResolvers();
            this.closeSession();
        }
    }

    protected void closeSession() {
        try {
            this.getSession().logout();
        }
        catch (Throwable t) {
            this.LOGGER.debug("closeSession: Unexpected problem closing the session; ignoring", t);
        }
    }

    protected void closeCreatedResolvers() {
        if (this.createdResolvers != null) {
            for (JcrResourceResolver resolver : this.createdResolvers.values()) {
                try {
                    resolver.close();
                }
                catch (Throwable t) {
                    this.LOGGER.debug("closeCreatedResolvers: Unexpected problem closing the created resovler " + (Object)((Object)resolver) + "; ignoring", t);
                }
            }
        }
    }

    protected void finalize() {
        this.close();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Resource resolver is already closed.");
        }
    }

    public Iterator<String> getAttributeNames() {
        this.checkClosed();
        final HashSet<String> names = new HashSet<String>();
        names.addAll(Arrays.asList(this.getSession().getAttributeNames()));
        names.addAll(this.originalAuthInfo.keySet());
        return new Iterator<String>(){
            final Iterator<String> keys;
            String nextKey;
            {
                this.keys = names.iterator();
                this.nextKey = this.seek();
            }

            private String seek() {
                while (this.keys.hasNext()) {
                    String key = this.keys.next();
                    if (!JcrResourceResolverFactoryImpl.isAttributeVisible(key)) continue;
                    return key;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.nextKey != null;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String toReturn = this.nextKey;
                this.nextKey = this.seek();
                return toReturn;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (JcrResourceResolverFactoryImpl.isAttributeVisible(name)) {
            Object sessionAttr = this.getSession().getAttribute(name);
            if (sessionAttr != null) {
                return sessionAttr;
            }
            return this.originalAuthInfo.get(name);
        }
        return null;
    }

    public Resource resolve(String absPath) {
        this.checkClosed();
        return this.resolve(null, absPath);
    }

    public Resource resolve(HttpServletRequest request) {
        this.checkClosed();
        return this.resolve(request, request.getPathInfo());
    }

    public Resource resolve(HttpServletRequest request, String absPath) {
        this.checkClosed();
        if (absPath == null) {
            absPath = MANGLE_NAMESPACE_OUT_PREFIX;
        } else if (!absPath.startsWith(MANGLE_NAMESPACE_OUT_PREFIX)) {
            absPath = MANGLE_NAMESPACE_OUT_PREFIX + absPath;
        }
        absPath = this.unmangleNamespaces(absPath);
        String workspaceName = null;
        if (this.useMultiWorkspaces) {
            String string = workspaceName = request == null ? null : (String)request.getAttribute(ResourceResolver.REQUEST_ATTR_WORKSPACE_INFO);
            if (workspaceName != null && !workspaceName.equals(this.getSession().getWorkspace().getName())) {
                this.LOGGER.debug("Delegating resolving to resolver for workspace {}", (Object)workspaceName);
                try {
                    JcrResourceResolver wsResolver = this.getResolverForWorkspace(workspaceName);
                    this.requestBoundResolver = wsResolver;
                    return wsResolver.resolve(request, absPath);
                }
                catch (LoginException e) {
                    this.LOGGER.debug("resolve: Path {} does not resolve, returning NonExistingResource", (Object)absPath);
                    NonExistingResource res = new NonExistingResource((ResourceResolver)this, absPath);
                    int index = absPath.indexOf(46);
                    if (index != -1) {
                        res.getResourceMetadata().setResolutionPathInfo(absPath.substring(index));
                    }
                    return this.factory.getResourceDecoratorTracker().decorate((Resource)res, workspaceName, request);
                }
            }
        }
        String[] realPathList = new String[]{absPath};
        String requestPath = request != null ? JcrResourceResolver.getMapPath(request.getScheme(), request.getServerName(), request.getServerPort(), absPath) : JcrResourceResolver.getMapPath("http", "localhost", 80, absPath);
        this.LOGGER.debug("resolve: Resolving request path {}", (Object)requestPath);
        for (int i = 0; i < 100; ++i) {
            Object[] mappedPath = null;
            for (MapEntry mapEntry : this.factory.getMapEntries().getResolveMaps()) {
                mappedPath = mapEntry.replace(requestPath);
                if (mappedPath == null) continue;
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("resolve: MapEntry {} matches, mapped path is {}", (Object)mapEntry, (Object)Arrays.toString(mappedPath));
                }
                if (mapEntry.isInternal()) {
                    this.LOGGER.debug("resolve: Redirecting internally");
                    break;
                }
                this.LOGGER.debug("resolve: Returning external redirect");
                return this.factory.getResourceDecoratorTracker().decorate((Resource)new RedirectResource(this, absPath, (String)mappedPath[0], mapEntry.getStatus()), workspaceName, request);
            }
            if (mappedPath == null) {
                this.LOGGER.debug("resolve: Request path {} does not match any MapEntry", (Object)requestPath);
                break;
            }
            if (!mappedPath[0].contains("://")) {
                this.LOGGER.debug("resolve: Mapped path is for resource tree");
                realPathList = mappedPath;
                break;
            }
            try {
                URI uri = new URI(mappedPath[0], false);
                requestPath = JcrResourceResolver.getMapPath(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath());
                realPathList = new String[]{uri.getPath()};
                this.LOGGER.debug("resolve: Mapped path is an URL, using new request path {}", (Object)requestPath);
                continue;
            }
            catch (URIException use) {
                throw new ResourceNotFoundException(absPath);
            }
        }
        Object res = null;
        for (int i = 0; res == null && i < realPathList.length; ++i) {
            String realPath = realPathList[i];
            if (StarResource.appliesTo(realPath)) {
                this.LOGGER.debug("resolve: Mapped path {} is a Star Resource", (Object)realPath);
                res = new StarResource(this, this.ensureAbsPath(realPath));
                continue;
            }
            if (realPath.startsWith(MANGLE_NAMESPACE_OUT_PREFIX)) {
                this.LOGGER.debug("resolve: Try absolute mapped path {}", (Object)realPath);
                res = this.resolveInternal(realPath);
                continue;
            }
            String[] searchPath = this.getSearchPath();
            for (int spi = 0; res == null && spi < searchPath.length; ++spi) {
                this.LOGGER.debug("resolve: Try relative mapped path with search path entry {}", (Object)searchPath[spi]);
                res = this.resolveInternal(searchPath[spi] + realPath);
            }
        }
        if (res == null) {
            String resourcePath = this.ensureAbsPath(realPathList[0]);
            this.LOGGER.debug("resolve: Path {} does not resolve, returning NonExistingResource at {}", (Object)absPath, (Object)resourcePath);
            res = new NonExistingResource((ResourceResolver)this, resourcePath);
            int index = resourcePath.indexOf(46);
            if (index != -1) {
                res.getResourceMetadata().setResolutionPathInfo(resourcePath.substring(index));
            }
        } else {
            this.LOGGER.debug("resolve: Path {} resolves to Resource {}", (Object)absPath, res);
        }
        return this.factory.getResourceDecoratorTracker().decorate((Resource)res, workspaceName, request);
    }

    public String map(String resourcePath) {
        this.checkClosed();
        return this.map(null, resourcePath);
    }

    public String map(HttpServletRequest request, String resourcePath) {
        int wsSepPos;
        String schemePrefix;
        String schemehostport;
        String mappedPath;
        String fragmentQuery;
        this.checkClosed();
        int fragmentQueryMark = resourcePath.indexOf(35);
        if (fragmentQueryMark < 0) {
            fragmentQueryMark = resourcePath.indexOf(63);
        }
        if (fragmentQueryMark >= 0) {
            fragmentQuery = resourcePath.substring(fragmentQueryMark);
            mappedPath = resourcePath.substring(0, fragmentQueryMark);
            this.LOGGER.debug("map: Splitting resource path '{}' into '{}' and '{}'", new Object[]{resourcePath, mappedPath, fragmentQuery});
        } else {
            fragmentQuery = null;
            mappedPath = resourcePath;
        }
        if (request != null) {
            schemehostport = MapEntry.getURI(request.getScheme(), request.getServerName(), request.getServerPort(), MANGLE_NAMESPACE_OUT_PREFIX);
            schemePrefix = request.getScheme().concat("://");
            this.LOGGER.debug("map: Mapping path {} for {} (at least with scheme prefix {})", new Object[]{resourcePath, schemehostport, schemePrefix});
        } else {
            schemehostport = null;
            schemePrefix = null;
            this.LOGGER.debug("map: Mapping path {} for default", (Object)resourcePath);
        }
        Resource res = null;
        String workspaceName = null;
        if (this.useMultiWorkspaces && (wsSepPos = mappedPath.indexOf(":/")) != -1) {
            workspaceName = mappedPath.substring(0, wsSepPos);
            if (workspaceName.equals(this.getSession().getWorkspace().getName())) {
                mappedPath = mappedPath.substring(wsSepPos + 1);
            } else {
                try {
                    JcrResourceResolver wsResolver = this.getResolverForWorkspace(workspaceName);
                    mappedPath = mappedPath.substring(wsSepPos + 1);
                    res = wsResolver.resolveInternal(mappedPath);
                }
                catch (LoginException e) {
                    return null;
                }
            }
        }
        if (res == null) {
            res = this.resolveInternal(mappedPath);
        }
        if (res != null) {
            String resolutionPathInfo = res.getResourceMetadata().getResolutionPathInfo();
            this.LOGGER.debug("map: Path maps to resource {} with path info {}", (Object)res, (Object)resolutionPathInfo);
            LinkedList<String> names = new LinkedList<String>();
            while (res != null) {
                String alias = this.getProperty(res, PROP_ALIAS);
                if (alias == null) {
                    alias = ResourceUtil.getName((Resource)res);
                }
                if (alias != null && alias.length() > 0 && !alias.endsWith(MANGLE_NAMESPACE_OUT_SUFFIX)) {
                    names.add(alias);
                }
                res = ResourceUtil.getParent((Resource)res);
            }
            StringBuilder buf = new StringBuilder();
            if (names.isEmpty()) {
                buf.append('/');
            } else {
                while (!names.isEmpty()) {
                    buf.append('/');
                    buf.append((String)names.removeLast());
                }
            }
            if (resolutionPathInfo != null) {
                buf.append(resolutionPathInfo);
            }
            mappedPath = buf.toString();
            this.LOGGER.debug("map: Alias mapping resolves to path {}", (Object)mappedPath);
        }
        boolean mappedPathIsUrl = false;
        for (MapEntry mapEntry : this.factory.getMapEntries().getMapMaps()) {
            String[] mappedPaths = mapEntry.replace(mappedPath);
            if (mappedPaths == null) continue;
            this.LOGGER.debug("map: Match for Entry {}", (Object)mapEntry);
            boolean bl = mappedPathIsUrl = !mapEntry.isInternal();
            if (mappedPathIsUrl && schemehostport != null) {
                mappedPath = null;
                for (String candidate : mappedPaths) {
                    if (candidate.startsWith(schemehostport)) {
                        mappedPath = candidate.substring(schemehostport.length() - 1);
                        mappedPathIsUrl = false;
                        this.LOGGER.debug("map: Found host specific mapping {} resolving to {}", (Object)candidate, (Object)mappedPath);
                        break;
                    }
                    if (!candidate.startsWith(schemePrefix) || mappedPath != null) continue;
                    mappedPath = candidate;
                }
                if (mappedPath == null) {
                    mappedPath = mappedPaths[0];
                }
            } else {
                mappedPath = mappedPaths[0];
            }
            this.LOGGER.debug("resolve: MapEntry {} matches, mapped path is {}", (Object)mapEntry, (Object)mappedPath);
            break;
        }
        if (mappedPath == null) {
            mappedPath = resourcePath;
        }
        try {
            URI uri = new URI(mappedPath, false);
            String path = this.mangleNamespaces(uri.getPath());
            if (request != null && request.getContextPath() != null && request.getContextPath().length() > 0) {
                path = request.getContextPath().concat(path);
            }
            uri.setPath(path);
            mappedPath = uri.toString();
        }
        catch (URIException e) {
            this.LOGGER.warn("map: Unable to mangle namespaces for " + mappedPath + " returning unmangled", (Throwable)((Object)e));
        }
        this.LOGGER.debug("map: Returning URL {} as mapping for path {}", (Object)mappedPath, (Object)resourcePath);
        if (fragmentQuery != null) {
            mappedPath = mappedPath.concat(fragmentQuery);
        }
        return mappedPath;
    }

    public String[] getSearchPath() {
        this.checkClosed();
        return (String[])this.factory.getSearchPath().clone();
    }

    public Resource getResource(String path) {
        int wsSepPos;
        this.checkClosed();
        if (this.useMultiWorkspaces && (wsSepPos = path.indexOf(":/")) != -1) {
            String workspaceName = path.substring(0, wsSepPos);
            if (workspaceName.equals(this.getSession().getWorkspace().getName())) {
                path = path.substring(wsSepPos + 1);
            } else {
                try {
                    JcrResourceResolver wsResolver = this.getResolverForWorkspace(workspaceName);
                    return wsResolver.getResource(path.substring(wsSepPos + 1));
                }
                catch (LoginException e) {
                    return null;
                }
            }
        }
        if (path.startsWith(MANGLE_NAMESPACE_OUT_PREFIX)) {
            Resource result;
            Resource resource = result = (path = ResourceUtil.normalize((String)path)) != null ? this.getResourceInternal(path) : null;
            if (result != null) {
                String workspacePrefix = null;
                if (!this.getSession().getWorkspace().getName().equals(this.factory.getDefaultWorkspaceName())) {
                    workspacePrefix = this.getSession().getWorkspace().getName();
                }
                result = this.factory.getResourceDecoratorTracker().decorate(result, workspacePrefix, null);
                return result;
            }
            return null;
        }
        String[] paths = this.factory.getSearchPath();
        if (paths != null) {
            for (String prefix : this.factory.getSearchPath()) {
                Resource res = this.getResource(prefix + path);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    public Resource getResource(Resource base, String path) {
        this.checkClosed();
        if (!path.startsWith(MANGLE_NAMESPACE_OUT_PREFIX) && base != null) {
            path = base.getPath() + MANGLE_NAMESPACE_OUT_PREFIX + path;
        }
        return this.getResource(path);
    }

    public Iterator<Resource> listChildren(Resource parent) {
        this.checkClosed();
        String path = parent.getPath();
        int wsSepPos = path.indexOf(":/");
        if (wsSepPos != -1) {
            String workspaceName = path.substring(0, wsSepPos);
            if (!workspaceName.equals(this.getSession().getWorkspace().getName())) {
                if (this.useMultiWorkspaces) {
                    try {
                        JcrResourceResolver wsResolver = this.getResolverForWorkspace(workspaceName);
                        return wsResolver.listChildren(parent);
                    }
                    catch (LoginException e) {
                        return Collections.EMPTY_LIST.iterator();
                    }
                }
                return Collections.EMPTY_LIST.iterator();
            }
            if (parent instanceof WorkspaceDecoratedResource) {
                parent = ((WorkspaceDecoratedResource)parent).getResource();
            } else {
                this.LOGGER.warn("looking for children of workspace path {}, but with an undecorated resource.", (Object)parent.getPath());
            }
        }
        String workspacePrefix = null;
        if (!this.getSession().getWorkspace().getName().equals(this.factory.getDefaultWorkspaceName())) {
            workspacePrefix = this.getSession().getWorkspace().getName();
        }
        return new ResourceIteratorDecorator(this.factory.getResourceDecoratorTracker(), workspacePrefix, new ResourceIterator(parent, this.rootProvider));
    }

    public Iterator<Resource> findResources(String query, String language) throws SlingException {
        this.checkClosed();
        try {
            Session session = null;
            String workspaceName = null;
            if (this.requestBoundResolver != null) {
                session = (Session)this.requestBoundResolver.adaptTo(Session.class);
                workspaceName = session.getWorkspace().getName();
            } else {
                session = this.getSession();
            }
            QueryResult res = JcrResourceUtil.query(session, query, language);
            return new ResourceIteratorDecorator(this.factory.getResourceDecoratorTracker(), workspaceName, new JcrNodeResourceIterator(this, res.getNodes(), this.factory.getDynamicClassLoader()));
        }
        catch (InvalidQueryException iqe) {
            throw new QuerySyntaxException(iqe.getMessage(), query, language, (Throwable)iqe);
        }
        catch (RepositoryException re) {
            throw new SlingException(re.getMessage(), (Throwable)re);
        }
    }

    public Iterator<Map<String, Object>> queryResources(String query, String language) throws SlingException {
        this.checkClosed();
        try {
            QueryResult result = JcrResourceUtil.query(this.adaptTo(Session.class), query, language);
            final String[] colNames = result.getColumnNames();
            final RowIterator rows = result.getRows();
            return new Iterator<Map<String, Object>>(){

                @Override
                public boolean hasNext() {
                    return rows.hasNext();
                }

                @Override
                public Map<String, Object> next() {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    try {
                        Value[] values = rows.nextRow().getValues();
                        for (int i = 0; i < values.length; ++i) {
                            Value v = values[i];
                            if (v == null) continue;
                            row.put(colNames[i], JcrResourceUtil.toJavaObject(values[i]));
                        }
                    }
                    catch (RepositoryException re) {
                        JcrResourceResolver.this.LOGGER.error("queryResources$next: Problem accessing row values", (Throwable)re);
                    }
                    return row;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }
        catch (InvalidQueryException iqe) {
            throw new QuerySyntaxException(iqe.getMessage(), query, language, (Throwable)iqe);
        }
        catch (RepositoryException re) {
            throw new SlingException(re.getMessage(), (Throwable)re);
        }
    }

    public String getUserID() {
        this.checkClosed();
        return this.getSession().getUserID();
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        this.checkClosed();
        if (type == Session.class) {
            if (this.requestBoundResolver != null) {
                return (AdapterType)this.requestBoundResolver.adaptTo(Session.class);
            }
            return (AdapterType)this.getSession();
        }
        return (AdapterType)super.adaptTo(type);
    }

    private Session getSession() {
        return this.rootProvider.getSession();
    }

    private synchronized JcrResourceResolver getResolverForWorkspace(String workspaceName) throws LoginException {
        JcrResourceResolver wsResolver;
        if (this.createdResolvers == null) {
            this.createdResolvers = new HashMap<String, JcrResourceResolver>();
        }
        if ((wsResolver = this.createdResolvers.get(workspaceName)) == null) {
            HashMap<String, Object> newAuthInfo = new HashMap<String, Object>();
            newAuthInfo.put("user.jcr.workspace", workspaceName);
            wsResolver = (JcrResourceResolver)this.clone(newAuthInfo);
            this.createdResolvers.put(workspaceName, wsResolver);
        }
        return wsResolver;
    }

    public static String getMapPath(String scheme, String host, int port, String path) {
        if (port < 0) {
            port = "https".equals(scheme) ? 443 : 80;
        }
        return scheme + MANGLE_NAMESPACE_OUT_PREFIX + host + "." + port + path;
    }

    private Resource resolveInternal(String absPath) {
        Resource resource = null;
        String curPath = absPath;
        try {
            ResourcePathIterator it = new ResourcePathIterator(absPath);
            while (it.hasNext() && resource == null) {
                curPath = it.next();
                resource = this.getResourceInternal(curPath);
            }
        }
        catch (Exception ex) {
            throw new SlingException("Problem trying " + curPath + " for request path " + absPath, (Throwable)ex);
        }
        if (resource != null) {
            String rpi = absPath.substring(curPath.length());
            resource.getResourceMetadata().setResolutionPathInfo(rpi);
            this.LOGGER.debug("resolveInternal: Found resource {} with path info {} for {}", new Object[]{resource, rpi, absPath});
        } else {
            resource = this.getResourceInternal(MANGLE_NAMESPACE_OUT_PREFIX);
            StringBuilder resolutionPath = new StringBuilder();
            StringTokenizer tokener = new StringTokenizer(absPath, MANGLE_NAMESPACE_OUT_PREFIX);
            while (resource != null && tokener.hasMoreTokens()) {
                String childNameRaw = tokener.nextToken();
                Resource nextResource = this.getChildInternal(resource, childNameRaw);
                if (nextResource != null) {
                    resource = nextResource;
                    resolutionPath.append(MANGLE_NAMESPACE_OUT_PREFIX).append(childNameRaw);
                    continue;
                }
                String childName = null;
                ResourcePathIterator rpi = new ResourcePathIterator(childNameRaw);
                while (rpi.hasNext() && nextResource == null) {
                    childName = rpi.next();
                    nextResource = this.getChildInternal(resource, childName);
                }
                resource = nextResource;
                resolutionPath.append(MANGLE_NAMESPACE_OUT_PREFIX).append(childName);
                if (nextResource == null) continue;
                break;
            }
            if (resource != null) {
                String path = resolutionPath.toString();
                String pathInfo = absPath.substring(path.length());
                resource.getResourceMetadata().setResolutionPath(path);
                resource.getResourceMetadata().setResolutionPathInfo(pathInfo);
                this.LOGGER.debug("resolveInternal: Found resource {} with path info {} for {}", new Object[]{resource, pathInfo, absPath});
            }
        }
        return resource;
    }

    private Resource getChildInternal(Resource parent, String childName) {
        Resource child = this.getResource(parent, childName);
        if (child != null) {
            String alias = this.getProperty(child, PROP_REDIRECT_INTERNAL);
            if (alias != null) {
                this.LOGGER.warn("getChildInternal: Internal redirect to {} for Resource {} is not supported yet, ignoring", (Object)alias, (Object)child);
            }
            return child;
        }
        Iterator<Resource> children = this.listChildren(parent);
        while (children.hasNext()) {
            child = children.next();
            String[] aliases = this.getProperty(child, PROP_ALIAS, String[].class);
            if (aliases == null) continue;
            for (String alias : aliases) {
                if (!childName.equals(alias)) continue;
                this.LOGGER.debug("getChildInternal: Found Resource {} with alias {} to use", (Object)child, (Object)childName);
                return child;
            }
        }
        this.LOGGER.debug("getChildInternal: Resource {} has no child {}", (Object)parent, (Object)childName);
        return null;
    }

    protected Resource getResourceInternal(String path) {
        Resource resource = this.rootProvider.getResource(this, path);
        if (resource != null) {
            resource.getResourceMetadata().setResolutionPath(path);
            return resource;
        }
        this.LOGGER.debug("getResourceInternal: Cannot resolve path '{}' to a resource", (Object)path);
        return null;
    }

    public String getProperty(Resource res, String propName) {
        return this.getProperty(res, propName, String.class);
    }

    public <Type> Type getProperty(Resource res, String propName, Class<Type> type) {
        ValueMap props = (ValueMap)res.adaptTo(ValueMap.class);
        if (props != null) {
            Object prop = props.get(propName, type);
            if (prop != null) {
                this.LOGGER.debug("getProperty: Resource {} has property {}={}", new Object[]{res, propName, prop});
                return (Type)prop;
            }
            prop = props.get("jcr:content/" + propName, type);
            return (Type)prop;
        }
        return null;
    }

    private String ensureAbsPath(String path) {
        if (!path.startsWith(MANGLE_NAMESPACE_OUT_PREFIX)) {
            path = this.getSearchPath()[0] + path;
        }
        return path;
    }

    private String mangleNamespaces(String absPath) {
        if (this.factory.isMangleNamespacePrefixes() && absPath.contains(MANGLE_NAMESPACE_OUT_SUFFIX)) {
            Pattern p = Pattern.compile(MANGLE_NAMESPACE_OUT);
            Matcher m = p.matcher(absPath);
            StringBuffer buf = new StringBuffer();
            while (m.find()) {
                String replacement = MANGLE_NAMESPACE_IN_PREFIX + m.group(1) + MANGLE_NAMESPACE_IN_SUFFIX;
                m.appendReplacement(buf, replacement);
            }
            m.appendTail(buf);
            absPath = buf.toString();
        }
        return absPath;
    }

    private String unmangleNamespaces(String absPath) {
        if (this.factory.isMangleNamespacePrefixes() && absPath.contains(MANGLE_NAMESPACE_IN_PREFIX)) {
            Pattern p = Pattern.compile(MANGLE_NAMESPACE_IN);
            Matcher m = p.matcher(absPath);
            StringBuffer buf = new StringBuffer();
            while (m.find()) {
                String namespace = m.group(1);
                try {
                    this.getSession().getNamespaceURI(namespace);
                    String replacement = MANGLE_NAMESPACE_OUT_PREFIX + namespace + MANGLE_NAMESPACE_OUT_SUFFIX;
                    m.appendReplacement(buf, replacement);
                }
                catch (NamespaceException ne) {
                    this.LOGGER.debug("unmangleNamespaces: '{}' is not a prefix, not unmangling", (Object)namespace);
                }
                catch (RepositoryException re) {
                    this.LOGGER.warn("unmangleNamespaces: Problem checking namespace '{}'", (Object)namespace, (Object)re);
                }
            }
            m.appendTail(buf);
            absPath = buf.toString();
        }
        return absPath;
    }
}

