/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.FastTreeMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.jcr.resource.internal.helper.WrappedResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceProviderEntry
implements Comparable<ResourceProviderEntry> {
    private static final long serialVersionUID = 7420631325909144862L;
    private static Logger LOGGER = LoggerFactory.getLogger(ResourceProviderEntry.class);
    private final String path;
    private final String prefix;
    private WrappedResourceProvider[] providers = new WrappedResourceProvider[0];
    private long ttime = 0L;
    private long nmiss = 0L;
    private long nsynthetic = 0L;
    private long nreal = 0L;
    private FastTreeMap storageMap = new FastTreeMap();
    private Collection<ResourceProviderEntry> storageMapValues = new ArrayList<ResourceProviderEntry>();

    public ResourceProviderEntry(String path, ResourceProvider[] providerList) {
        if (path.endsWith("/")) {
            this.path = path.substring(0, path.length() - 1);
            this.prefix = path;
        } else {
            this.path = path;
            this.prefix = path + "/";
        }
        if (providerList != null) {
            this.providers = new WrappedResourceProvider[providerList.length];
            for (int i = 0; i < providerList.length; ++i) {
                this.providers[i] = providerList[i] instanceof WrappedResourceProvider ? (WrappedResourceProvider)providerList[i] : new WrappedResourceProvider(providerList[i], null);
            }
        }
        this.storageMap.setFast(true);
    }

    String getPath() {
        return this.path;
    }

    public ResourceProvider[] getResourceProviders() {
        return this.providers;
    }

    public Resource getResource(ResourceResolver resourceResolver, String path) {
        return this.getInternalResource(resourceResolver, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addResourceProvider(String prefix, ResourceProvider provider, Comparable<?> comparable) {
        ResourceProviderEntry resourceProviderEntry = this;
        synchronized (resourceProviderEntry) {
            String[] elements = ResourceProviderEntry.split(prefix, '/');
            ArrayList<ResourceProviderEntry> entryPath = new ArrayList<ResourceProviderEntry>();
            entryPath.add(this);
            this.populateProviderPath(entryPath, elements);
            for (int i = entryPath.size() - 1; i < elements.length; ++i) {
                String stubPrefix = elements[i];
                ResourceProviderEntry rpe2 = new ResourceProviderEntry(stubPrefix, new ResourceProvider[0]);
                ((ResourceProviderEntry)entryPath.get(i)).put(elements[i], rpe2);
                entryPath.add(rpe2);
            }
            return ((ResourceProviderEntry)entryPath.get(elements.length)).addInternalProvider(new WrappedResourceProvider(provider, comparable));
        }
    }

    public void put(String key, ResourceProviderEntry value) {
        this.storageMap.put((Object)key, (Object)value);
        this.storageMapValues = new ArrayList<ResourceProviderEntry>(this.storageMap.values());
    }

    public boolean containsKey(String key) {
        return this.storageMap.containsKey((Object)key);
    }

    public ResourceProviderEntry get(String key) {
        return (ResourceProviderEntry)this.storageMap.get((Object)key);
    }

    public Collection<ResourceProviderEntry> values() {
        return this.storageMapValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeResourceProvider(String prefix, ResourceProvider resourceProvider, Comparable<?> comparable) {
        ResourceProviderEntry resourceProviderEntry = this;
        synchronized (resourceProviderEntry) {
            String[] elements = ResourceProviderEntry.split(prefix, '/');
            ArrayList<ResourceProviderEntry> entryPath = new ArrayList<ResourceProviderEntry>();
            this.populateProviderPath(entryPath, elements);
            if (entryPath.size() > 0 && entryPath.size() == elements.length) {
                return ((ResourceProviderEntry)entryPath.get(entryPath.size() - 1)).removeInternalProvider(new WrappedResourceProvider(resourceProvider, comparable));
            }
            return false;
        }
    }

    @Override
    public int compareTo(ResourceProviderEntry o) {
        return this.prefix.compareTo(o.prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addInternalProvider(WrappedResourceProvider provider) {
        WrappedResourceProvider[] wrappedResourceProviderArray = this.providers;
        synchronized (this.providers) {
            int before = this.providers.length;
            HashSet<WrappedResourceProvider> set = new HashSet<WrappedResourceProvider>();
            if (this.providers != null) {
                set.addAll(Arrays.asList(this.providers));
            }
            LOGGER.debug("Adding provider {} at {} ", (Object)provider, (Object)this.path);
            set.add(provider);
            this.providers = this.conditionalSort(set);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.providers.length > before;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeInternalProvider(WrappedResourceProvider provider) {
        WrappedResourceProvider[] wrappedResourceProviderArray = this.providers;
        synchronized (this.providers) {
            int before = this.providers.length;
            HashSet<WrappedResourceProvider> set = new HashSet<WrappedResourceProvider>();
            if (this.providers != null) {
                set.addAll(Arrays.asList(this.providers));
            }
            set.remove(provider);
            this.providers = this.conditionalSort(set);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.providers.length < before;
        }
    }

    private WrappedResourceProvider[] conditionalSort(Set<WrappedResourceProvider> set) {
        ArrayList<WrappedResourceProvider> providerList = new ArrayList<WrappedResourceProvider>(set);
        Collections.sort(providerList, new Comparator<WrappedResourceProvider>(){

            @Override
            public int compare(WrappedResourceProvider o1, WrappedResourceProvider o2) {
                Comparable<?> c1 = o1.getComparable();
                Comparable<?> c2 = o2.getComparable();
                if (c1 == null && c2 == null) {
                    return 0;
                }
                if (c1 == null) {
                    return -1;
                }
                if (c2 == null) {
                    return 1;
                }
                return c1.compareTo(c2);
            }
        });
        return set.toArray(new WrappedResourceProvider[set.size()]);
    }

    private void populateProviderPath(List<ResourceProviderEntry> providerEntryPath, String[] elements) {
        ResourceProviderEntry base = this;
        if (elements != null) {
            for (String element : elements) {
                if (element == null) continue;
                if (!base.containsKey(element)) break;
                base = base.get(element);
                providerEntryPath.add(base);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource getInternalResource(ResourceResolver resourceResolver, String fullPath) {
        long start = System.currentTimeMillis();
        try {
            Resource resource;
            if (fullPath == null || fullPath.length() == 0 || fullPath.charAt(0) != '/') {
                ++this.nmiss;
                LOGGER.debug("Not absolute {} :{}", (Object)fullPath, (Object)(System.currentTimeMillis() - start));
                Resource resource2 = null;
                return resource2;
            }
            String[] elements = ResourceProviderEntry.split(fullPath, '/');
            ArrayList<ResourceProviderEntry> list = new ArrayList<ResourceProviderEntry>();
            this.populateProviderPath(list, elements);
            for (int i = list.size() - 1; i >= 0; --i) {
                Object[] rps;
                for (ResourceProvider resourceProvider : rps = ((ResourceProviderEntry)list.get(i)).getResourceProviders()) {
                    Resource resource3 = resourceProvider.getResource(resourceResolver, fullPath);
                    if (resource3 == null) continue;
                    ++this.nreal;
                    LOGGER.debug("Resolved Full {} using {} from {} ", new Object[]{fullPath, resourceProvider, Arrays.toString(rps)});
                    Resource resource4 = resource3;
                    return resource4;
                }
            }
            Resource resource5 = this.getResourceFromProviders(resourceResolver, fullPath);
            if (resource5 != null) {
                resource = resource5;
                return resource;
            }
            if (list.size() > 0 && list.size() == elements.length && ((ResourceProviderEntry)list.get(list.size() - 1)).getResourceProviders().length == 0) {
                ++this.nsynthetic;
                LOGGER.debug("Resolved Synthetic {}", (Object)fullPath);
                resource = new SyntheticResource(resourceResolver, fullPath, "sling:syntheticResourceProviderResource");
                return resource;
            }
            LOGGER.debug("Resource null {} ", (Object)fullPath);
            ++this.nmiss;
            resource = null;
            return resource;
        }
        catch (Exception ex) {
            LOGGER.debug("Failed! ", (Throwable)ex);
            Resource resource = null;
            return resource;
        }
        finally {
            this.ttime += System.currentTimeMillis() - start;
        }
    }

    Resource getResourceFromProviders(ResourceResolver resourceResolver, String fullPath) {
        ResourceProvider[] rps;
        for (ResourceProvider rp : rps = this.getResourceProviders()) {
            Resource resource = rp.getResource(resourceResolver, fullPath);
            if (resource == null) continue;
            ++this.nreal;
            LOGGER.debug("Resolved Base {} using {} ", (Object)fullPath, (Object)rp);
            return resource;
        }
        return null;
    }

    static String[] split(String st, char sep) {
        int start;
        if (st == null) {
            return new String[0];
        }
        char[] pn = st.toCharArray();
        if (pn.length == 0) {
            return new String[0];
        }
        if (pn.length == 1 && pn[0] == sep) {
            return new String[0];
        }
        int n = 1;
        int end = pn.length;
        for (start = 0; start < end && sep == pn[start]; ++start) {
        }
        while (start < end && sep == pn[end - 1]) {
            --end;
        }
        for (int i = start; i < end; ++i) {
            if (sep != pn[i]) continue;
            ++n;
        }
        String[] e = new String[n];
        int s = start;
        int j = 0;
        for (int i = start; i < end; ++i) {
            if (pn[i] != sep) continue;
            e[j++] = new String(pn, s, i - s);
            s = i + 1;
        }
        if (s < end) {
            e[j++] = new String(pn, s, end - s);
        }
        return e;
    }

    public String getResolutionStats() {
        long tot = this.nreal + this.nsynthetic + this.nmiss;
        if (tot == 0L) {
            return null;
        }
        float n = tot;
        float t = this.ttime;
        float persec = 1000.0f * n / t;
        float avgtime = t / n;
        String stat = "Resolved: Real(" + this.nreal + ") Synthetic(" + this.nsynthetic + ") Missing(" + this.nmiss + ") Total(" + tot + ") at " + persec + " ops/sec avg " + avgtime + " ms";
        this.nreal = 0L;
        this.nsynthetic = 0L;
        this.nmiss = 0L;
        this.ttime = 0L;
        return stat;
    }

    public String toString() {
        return this.path;
    }
}

