/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.util.Iterator;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrItemResource;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResource;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrPropertyResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrResourceProvider
implements ResourceProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Session session;
    private final ClassLoader dynamicClassLoader;
    private final boolean useMultiWorkspaces;

    public JcrResourceProvider(Session session, ClassLoader dynamicClassLoader, boolean useMultiWorkspaces) {
        this.session = session;
        this.dynamicClassLoader = dynamicClassLoader;
        this.useMultiWorkspaces = useMultiWorkspaces;
    }

    public String[] getRoots() {
        return new String[]{"/"};
    }

    public Resource getResource(ResourceResolver resourceResolver, HttpServletRequest request, String path) throws SlingException {
        return this.getResource(resourceResolver, path);
    }

    public Resource getResource(ResourceResolver resourceResolver, String path) throws SlingException {
        try {
            return this.createResource(resourceResolver, path);
        }
        catch (RepositoryException re) {
            throw new SlingException("Problem retrieving node based resource " + path, (Throwable)re);
        }
    }

    public Iterator<Resource> listChildren(Resource parent) {
        JcrItemResource parentItemResource;
        if (parent instanceof JcrItemResource) {
            parentItemResource = (JcrItemResource)parent;
        } else {
            if (parent instanceof ResourceWrapper) {
                return this.listChildren(((ResourceWrapper)parent).getResource());
            }
            try {
                parentItemResource = this.createResource(parent.getResourceResolver(), parent.getPath());
            }
            catch (RepositoryException re) {
                parentItemResource = null;
            }
        }
        return parentItemResource != null ? parentItemResource.listJcrChildren() : null;
    }

    public Session getSession() {
        return this.session;
    }

    private JcrItemResource createResource(ResourceResolver resourceResolver, String path) throws RepositoryException {
        int wsSepPos;
        if (this.useMultiWorkspaces && (wsSepPos = path.indexOf(":/")) != -1) {
            String expectedWorkspaceName;
            String workspaceName = path.substring(0, wsSepPos);
            if (workspaceName.equals(expectedWorkspaceName = this.getSession().getWorkspace().getName())) {
                path = path.substring(wsSepPos + 1);
            } else {
                throw new RepositoryException("Unexpected workspace name. Expected " + expectedWorkspaceName + ". Actual " + workspaceName);
            }
        }
        if (this.itemExists(path)) {
            Item item = this.getSession().getItem(path);
            if (item.isNode()) {
                this.log.debug("createResource: Found JCR Node Resource at path '{}'", (Object)path);
                return new JcrNodeResource(resourceResolver, (Node)item, this.dynamicClassLoader);
            }
            this.log.debug("createResource: Found JCR Property Resource at path '{}'", (Object)path);
            return new JcrPropertyResource(resourceResolver, path, (Property)item);
        }
        this.log.debug("createResource: No JCR Item exists at path '{}'", (Object)path);
        return null;
    }

    public boolean itemExists(String path) {
        try {
            return this.getSession().itemExists(path);
        }
        catch (RepositoryException re) {
            this.log.debug("itemExists: Error checking for existence of {}: {}", (Object)path, (Object)re.toString());
            return false;
        }
    }
}

