/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.net;

import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import javax.jcr.Session;
import org.apache.jackrabbit.net.FileParts;
import org.apache.jackrabbit.net.JCRURLConnection;

class JCRURLHandler
extends URLStreamHandler {
    private final Session session;

    JCRURLHandler(Session session) {
        if (session == null) {
            throw new NullPointerException("session");
        }
        this.session = session;
    }

    Session getSession() {
        return this.session;
    }

    protected URLConnection openConnection(URL url) {
        return new JCRURLConnection(url, this);
    }

    protected void setURL(URL u, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        if (u.getAuthority() != authority && (u.getAuthority() == null ? authority != null : !u.getAuthority().equals(authority))) {
            throw new IllegalArgumentException("Authority " + authority + " not supported by this handler");
        }
        FileParts newParts = new FileParts(path);
        if (!"_".equals(newParts.getRepository())) {
            throw new IllegalArgumentException("Repository " + newParts.getRepository() + " not supported by this handler");
        }
        if (!this.session.getWorkspace().getName().equals(newParts.getWorkspace())) {
            throw new IllegalArgumentException("Workspace " + newParts.getWorkspace() + " not supported by this handler");
        }
        super.setURL(u, protocol, host, port, authority, userInfo, path, query, ref);
    }
}

