/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.jackrabbit.api.observation.JackrabbitEvent;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrResourceListener
implements EventListener {
    private final Logger logger = LoggerFactory.getLogger(JcrResourceListener.class);
    private final String workspaceName;
    private final Session session;
    private final String startPath;
    private final String mountPrefix;
    private final ResourceResolver resolver;
    private final ServiceTracker eventAdminTracker;
    private final boolean hasJackrabbitEventClass;
    private final LinkedBlockingQueue<Dictionary<String, Object>> osgiEventQueue;
    private final Dictionary<String, Object> TERMINATE_PROCESSING = new Hashtable<String, Object>(1);

    public JcrResourceListener(String workspaceName, ResourceResolverFactory factory, String startPath, String mountPrefix, ServiceTracker eventAdminTracker) throws LoginException, RepositoryException {
        this.workspaceName = workspaceName;
        HashMap<String, String> authInfo = new HashMap<String, String>();
        if (workspaceName != null) {
            authInfo.put("user.jcr.workspace", workspaceName);
        }
        this.resolver = factory.getAdministrativeResourceResolver(authInfo);
        this.session = (Session)this.resolver.adaptTo(Session.class);
        this.startPath = startPath;
        this.eventAdminTracker = eventAdminTracker;
        this.mountPrefix = mountPrefix.equals("/") ? null : mountPrefix;
        this.osgiEventQueue = new LinkedBlockingQueue();
        Thread oeqt = new Thread(new Runnable(){

            public void run() {
                JcrResourceListener.this.processOsgiEventQueue();
            }
        }, "JCR Resource Event Queue Processor");
        oeqt.start();
        this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 31, this.startPath, true, null, null, false);
        boolean foundClass = false;
        try {
            this.getClass().getClassLoader().loadClass(JackrabbitEvent.class.getName());
            foundClass = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.hasJackrabbitEventClass = foundClass;
    }

    public void dispose() {
        try {
            this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        }
        catch (RepositoryException e) {
            this.logger.warn("Unable to remove session listener: " + this, (Throwable)e);
        }
        this.resolver.close();
        this.osgiEventQueue.clear();
        this.osgiEventQueue.offer(this.TERMINATE_PROCESSING);
    }

    public void onEvent(EventIterator events) {
        EventAdmin localEA = (EventAdmin)this.eventAdminTracker.getService();
        if (localEA == null) {
            return;
        }
        HashMap<String, Event> addedEvents = new HashMap<String, Event>();
        HashMap<String, ChangedAttributes> changedEvents = new HashMap<String, ChangedAttributes>();
        HashMap<String, Event> removedEvents = new HashMap<String, Event>();
        while (events.hasNext()) {
            Event event = events.nextEvent();
            try {
                String eventPath = this.mountPrefix != null ? this.mountPrefix + event.getPath() : event.getPath();
                if (event.getType() == 4 || event.getType() == 8 || event.getType() == 16) {
                    int lastSlash = eventPath.lastIndexOf(47);
                    String nodePath = eventPath.substring(0, lastSlash);
                    String propName = eventPath.substring(lastSlash + 1);
                    this.updateChangedEvent(changedEvents, nodePath, event, propName);
                    continue;
                }
                if (event.getType() == 1) {
                    if (removedEvents.remove(eventPath) != null) {
                        this.updateChangedEvent(changedEvents, eventPath, event, null);
                        continue;
                    }
                    addedEvents.put(eventPath, event);
                    continue;
                }
                if (event.getType() != 2) continue;
                addedEvents.remove(eventPath);
                removedEvents.put(eventPath, event);
            }
            catch (RepositoryException e) {
                this.logger.error("Error during modification: {}", (Object)e.getMessage());
            }
        }
        for (Map.Entry e : removedEvents.entrySet()) {
            this.sendOsgiEvent((String)e.getKey(), (Event)e.getValue(), "org/apache/sling/api/resource/Resource/REMOVED", (ChangedAttributes)changedEvents.remove(e.getKey()));
        }
        for (Map.Entry e : addedEvents.entrySet()) {
            this.sendOsgiEvent((String)e.getKey(), (Event)e.getValue(), "org/apache/sling/api/resource/Resource/ADDED", (ChangedAttributes)changedEvents.remove(e.getKey()));
        }
        for (Map.Entry e : changedEvents.entrySet()) {
            this.sendOsgiEvent((String)e.getKey(), ((ChangedAttributes)e.getValue()).firstEvent, "org/apache/sling/api/resource/Resource/CHANGED", (ChangedAttributes)e.getValue());
        }
    }

    private void updateChangedEvent(Map<String, ChangedAttributes> changedEvents, String path, Event event, String propName) {
        ChangedAttributes storedEvent = changedEvents.get(path);
        if (storedEvent == null) {
            storedEvent = new ChangedAttributes(event);
            changedEvents.put(path, storedEvent);
        }
        storedEvent.addEvent(event, propName);
    }

    private void sendOsgiEvent(String path, Event event, String topic, ChangedAttributes changedAttributes) {
        path = this.createWorkspacePath(path);
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("userid", event.getUserID());
        if (this.isExternal(event)) {
            ((Dictionary)properties).put("event.application", "unknown");
        }
        if (changedAttributes != null) {
            changedAttributes.addProperties(properties);
        }
        ((Dictionary)properties).put("path", path);
        ((Dictionary)properties).put("event.topics", topic);
        this.osgiEventQueue.offer(properties);
    }

    void processOsgiEventQueue() {
        while (true) {
            Dictionary<String, Object> event;
            try {
                event = this.osgiEventQueue.take();
            }
            catch (InterruptedException e) {
                continue;
            }
            if (event == null || event == this.TERMINATE_PROCESSING) break;
            try {
                EventAdmin localEa = (EventAdmin)this.eventAdminTracker.getService();
                if (localEa == null) continue;
                String topic = (String)event.remove("event.topics");
                if (!"org/apache/sling/api/resource/Resource/REMOVED".equals(topic)) {
                    String path = (String)event.get("path");
                    Resource resource = this.resolver.getResource(path);
                    if (resource != null) {
                        String resourceSuperType;
                        String resourceType;
                        Node node;
                        if (path.endsWith("/jcr:content") && (node = (Node)resource.adaptTo(Node.class)) != null) {
                            try {
                                Resource parentResource;
                                if (node.getParent().isNodeType("nt:file") && (parentResource = ResourceUtil.getParent((Resource)resource)) != null) {
                                    resource = parentResource;
                                    event.put("path", resource.getPath());
                                }
                            }
                            catch (RepositoryException re) {
                                // empty catch block
                            }
                        }
                        if ((resourceType = resource.getResourceType()) != null) {
                            event.put("resourceType", resource.getResourceType());
                        }
                        if ((resourceSuperType = resource.getResourceSuperType()) != null) {
                            event.put("resourceSuperType", resource.getResourceSuperType());
                        }
                    } else {
                        this.logger.debug("processOsgiEventQueue: Resource at {} not found, which is not expected for an added or modified node", (Object)path);
                    }
                }
                localEa.sendEvent(new org.osgi.service.event.Event(topic, event));
            }
            catch (Exception e) {
                this.logger.warn("processOsgiEventQueue: Unexpected problem processing event " + event, (Throwable)e);
            }
        }
        this.osgiEventQueue.clear();
    }

    private boolean isExternal(Event event) {
        if (this.hasJackrabbitEventClass && event instanceof JackrabbitEvent) {
            JackrabbitEvent jEvent = (JackrabbitEvent)event;
            return jEvent.isExternal();
        }
        return false;
    }

    private String createWorkspacePath(String path) {
        if (this.workspaceName == null) {
            return path;
        }
        return this.workspaceName + ":" + path;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChangedAttributes {
        private final Event firstEvent;
        public Set<String> addedAttributes;
        public Set<String> changedAttributes;
        public Set<String> removedAttributes;

        public ChangedAttributes(Event event) {
            this.firstEvent = event;
        }

        public void addEvent(Event event, String propName) {
            if (event.getType() == 4) {
                if (this.removedAttributes != null) {
                    this.removedAttributes.remove(propName);
                }
                if (this.addedAttributes == null) {
                    this.addedAttributes = new HashSet<String>();
                }
                this.addedAttributes.add(propName);
            } else if (event.getType() == 8) {
                if (this.addedAttributes != null) {
                    this.addedAttributes.remove(propName);
                }
                if (this.removedAttributes == null) {
                    this.removedAttributes = new HashSet<String>();
                }
                this.removedAttributes.add(propName);
            } else if (event.getType() == 16) {
                if (this.changedAttributes == null) {
                    this.changedAttributes = new HashSet<String>();
                }
                this.changedAttributes.add(propName);
            }
        }

        public void addProperties(Dictionary<String, Object> properties) {
            if (this.addedAttributes != null) {
                properties.put("resourceAddedAttributes", this.addedAttributes.toArray(new String[this.addedAttributes.size()]));
            }
            if (this.changedAttributes != null) {
                properties.put("resourceChangedAttributes", this.changedAttributes.toArray(new String[this.changedAttributes.size()]));
            }
            if (this.removedAttributes != null) {
                properties.put("resourceRemovedAttributes", this.removedAttributes.toArray(new String[this.removedAttributes.size()]));
            }
        }
    }
}

