/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.internal.JcrResourceResolverFactoryImpl;
import org.apache.sling.jcr.resource.internal.helper.MapEntries;
import org.apache.sling.jcr.resource.internal.helper.MapEntry;
import org.apache.sling.jcr.resource.internal.helper.URI;
import org.apache.sling.jcr.resource.internal.helper.URIException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrResourceResolverWebConsolePlugin
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    private static final String ATTR_TEST = "plugin.test";
    private static final String ATTR_SUBMIT = "plugin.submit";
    private static final String PAR_MSG = "msg";
    private static final String PAR_TEST = "test";
    private final transient JcrResourceResolverFactoryImpl resolverFactory;
    private transient ServiceRegistration service;

    JcrResourceResolverWebConsolePlugin(BundleContext context, JcrResourceResolverFactoryImpl resolverFactory) {
        this.resolverFactory = resolverFactory;
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "JCRResourceResolver Web Console Plugin");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("service.pid", ((Object)((Object)this)).getClass().getName());
        ((Dictionary)props).put("felix.webconsole.label", "jcrresolver");
        ((Dictionary)props).put("felix.webconsole.title", "Sling Resource Resolver");
        ((Dictionary)props).put("felix.webconsole.configprinter.modes", "always");
        this.service = context.registerService(new String[]{"javax.servlet.Servlet"}, (Object)this, props);
    }

    void dispose() {
        if (this.service != null) {
            this.service.unregister();
            this.service = null;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String msg = request.getParameter(PAR_MSG);
        String test = msg != null ? request.getParameter(PAR_TEST) : null;
        PrintWriter pw = response.getWriter();
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        MapEntries mapEntries = this.resolverFactory.getMapEntries();
        this.titleHtml(pw, "Configuration", null);
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>Resource Search Path</td>");
        pw.print("<td class='content' colspan='2'>");
        pw.print(Arrays.asList(this.resolverFactory.getSearchPath()).toString());
        pw.print("</td>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>Namespace Mangling</td>");
        pw.print("<td class='content' colspan='2'>");
        pw.print(this.resolverFactory.isMangleNamespacePrefixes() ? "Enabled" : "Disabled");
        pw.print("</td>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>Mapping Location</td>");
        pw.print("<td class='content' colspan='2'>");
        pw.print(this.resolverFactory.getMapRoot());
        pw.print("</td>");
        pw.println("</tr>");
        this.separatorHtml(pw);
        this.titleHtml(pw, "Configuration Test", "To test the configuration, enter an URL or a resource path into the field and click 'Resolve' to resolve the URL or click 'Map' to map the resource path. To simulate a map call that takes the current request into account, provide a full URL whose scheme/host/port prefix will then be used as the request information. The path passed to map will always be the path part of the URL.");
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>Test</td>");
        pw.print("<td class='content' colspan='2'>");
        pw.print("<form method='post'>");
        pw.print("<input type='text' name='plugin.test' value='");
        if (test != null) {
            pw.print(ResponseUtil.escapeXml((String)test));
        }
        pw.println("' class='input' size='50'>");
        pw.println("&nbsp;&nbsp;<input type='submit' name='plugin.submit' value='Resolve' class='submit'>");
        pw.println("&nbsp;&nbsp;<input type='submit' name='plugin.submit' value='Map' class='submit'>");
        pw.print("</form>");
        pw.print("</td>");
        pw.println("</tr>");
        if (msg != null) {
            pw.println("<tr class='content'>");
            pw.println("<td class='content'>&nbsp;</td>");
            pw.print("<td class='content' colspan='2'>");
            pw.print(ResponseUtil.escapeXml((String)msg));
            pw.println("</td>");
            pw.println("</tr>");
        }
        this.separatorHtml(pw);
        this.dumpMapHtml(pw, "Resolver Map Entries", "Lists the entries used by the ResourceResolver.resolve methods to map URLs to Resources", mapEntries.getResolveMaps());
        this.separatorHtml(pw);
        this.dumpMapHtml(pw, "Mapping Map Entries", "Lists the entries used by the ResourceResolver.map methods to map Resource Paths to URLs", mapEntries.getMapMaps());
        pw.println("</table>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String test = request.getParameter(ATTR_TEST);
        String msg = null;
        if (test != null && test.length() > 0) {
            Session session = null;
            try {
                ResolverRequest helper = new ResolverRequest(request, test);
                session = this.resolverFactory.getRepository().loginAdministrative(null);
                ResourceResolver resolver = this.resolverFactory.getResourceResolver(session);
                Object result = "Map".equals(request.getParameter(ATTR_SUBMIT)) ? (helper.getServerName() == null ? resolver.map(helper.getPathInfo()) : resolver.map((HttpServletRequest)helper, helper.getPathInfo())) : resolver.resolve((HttpServletRequest)helper, helper.getPathInfo());
                msg = result.toString();
            }
            catch (Throwable t) {
                msg = "Test Failure: " + t;
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
        String path = request.getContextPath() + request.getServletPath() + request.getPathInfo();
        String redirectTo = msg == null ? path : path + '?' + PAR_MSG + '=' + this.encodeParam(msg) + '&' + PAR_TEST + '=' + this.encodeParam(test);
        response.sendRedirect(redirectTo);
    }

    private String encodeParam(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    public void printConfiguration(PrintWriter pw) {
        MapEntries mapEntries = this.resolverFactory.getMapEntries();
        this.dumpMapText(pw, "Resolver Map Entries", mapEntries.getResolveMaps());
        this.separatorText(pw);
        this.dumpMapText(pw, "Mapping Map Entries", mapEntries.getMapMaps());
    }

    private void dumpMapHtml(PrintWriter pw, String title, String description, Collection<MapEntry> list) {
        this.titleHtml(pw, title, description);
        pw.println("<tr class='content'>");
        pw.println("<th class='content'>Pattern</th>");
        pw.println("<th class='content'>Replacement</th>");
        pw.println("<th class='content'>Redirect</th>");
        pw.println("</tr>");
        for (MapEntry entry : list) {
            String[] repls;
            pw.println("<tr class='content'>");
            pw.println("<td class='content' style='vertical-align: top'>" + entry.getPattern() + "</td>");
            pw.print("<td class='content' style='vertical-align: top'>");
            for (String repl : repls = entry.getRedirect()) {
                pw.print(repl + "<br/>");
            }
            pw.println("</td>");
            pw.print("<td class='content' style='vertical-align: top'>");
            if (entry.isInternal()) {
                pw.print("internal");
            } else {
                pw.print("external: " + entry.getStatus());
            }
            pw.println("</td>");
        }
    }

    private void titleHtml(PrintWriter pw, String title, String description) {
        pw.println("<tr class='content'>");
        pw.println("<th colspan='3'class='content container'>" + title + "</th>");
        pw.println("</tr>");
        if (description != null) {
            pw.println("<tr class='content'>");
            pw.println("<td colspan='3'class='content'>" + description + "</th>");
            pw.println("</tr>");
        }
    }

    private void separatorHtml(PrintWriter pw) {
        pw.println("<tr class='content'>");
        pw.println("<td class='content' colspan='3'>&nbsp;</td>");
        pw.println("</tr>");
    }

    private void dumpMapText(PrintWriter pw, String title, Collection<MapEntry> list) {
        pw.println(title);
        String format = "%25s%25s%15s\r\n";
        pw.printf("%25s%25s%15s\r\n", "Pattern", "Replacement", "Redirect");
        for (MapEntry entry : list) {
            List<String> redir = Arrays.asList(entry.getRedirect());
            String status = entry.isInternal() ? "internal" : "external: " + entry.getStatus();
            pw.printf("%25s%25s%15s\r\n", entry.getPattern(), redir, status);
        }
    }

    private void separatorText(PrintWriter pw) {
        pw.println();
    }

    private static class ResolverRequest
    extends HttpServletRequestWrapper {
        private final URI uri;

        public ResolverRequest(HttpServletRequest request, String uriString) throws URIException {
            super(request);
            this.uri = new URI(uriString, false);
        }

        public String getScheme() {
            return this.uri.getScheme();
        }

        public String getServerName() {
            try {
                return this.uri.getHost();
            }
            catch (URIException ue) {
                return null;
            }
        }

        public int getServerPort() {
            return this.uri.getPort();
        }

        public String getPathInfo() {
            try {
                return this.uri.getPath();
            }
            catch (URIException ue) {
                return "";
            }
        }
    }
}

