/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.BidiMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.resource.internal.JcrResourceResolverFactoryImpl;
import org.apache.sling.jcr.resource.internal.helper.MapEntry;
import org.apache.sling.jcr.resource.internal.helper.Mapping;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapEntries
implements EventHandler {
    public static final MapEntries EMPTY = new MapEntries();
    private static final String GLOBAL_LIST_KEY = "*";
    public static final String DEFAULT_MAP_ROOT = "/etc/map";
    private static final String JCR_SYSTEM_PREFIX = "/jcr:system/";
    static final String ANY_SCHEME_HOST = "[^/]+/[^/]+";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JcrResourceResolverFactoryImpl factory;
    private volatile ResourceResolver resolver;
    private final String mapRoot;
    private Map<String, List<MapEntry>> resolveMapsMap;
    private Collection<MapEntry> mapMaps;
    private Collection<String> vanityTargets;
    private ServiceRegistration registration;
    private ServiceTracker eventAdminTracker;
    private final Semaphore initTrigger = new Semaphore(0);
    private final ReentrantLock initializing = new ReentrantLock();

    private MapEntries() {
        this.factory = null;
        this.resolver = null;
        this.mapRoot = DEFAULT_MAP_ROOT;
        this.resolveMapsMap = Collections.emptyMap();
        this.mapMaps = Collections.emptyList();
        this.vanityTargets = Collections.emptySet();
        this.registration = null;
        this.eventAdminTracker = null;
    }

    public MapEntries(JcrResourceResolverFactoryImpl factory, BundleContext bundleContext, ServiceTracker eventAdminTracker) throws LoginException {
        this.resolver = factory.getAdministrativeResourceResolver(null);
        this.factory = factory;
        this.mapRoot = factory.getMapRoot();
        this.eventAdminTracker = eventAdminTracker;
        this.resolveMapsMap = Collections.emptyMap();
        this.mapMaps = Collections.emptyList();
        this.vanityTargets = Collections.emptySet();
        this.doInit();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("event.topics", "org/apache/sling/api/resource/*");
        ((Dictionary)props).put("event.filter", MapEntries.createFilter());
        ((Dictionary)props).put("service.description", "Map Entries Observation");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.registration = bundleContext.registerService(EventHandler.class.getName(), (Object)this, props);
        Thread updateThread = new Thread(new Runnable(){

            public void run() {
                MapEntries.this.init();
            }
        }, "MapEntries Update");
        updateThread.setDaemon(true);
        updateThread.start();
    }

    private void triggerInit() {
        if (this.initTrigger.availablePermits() < 1) {
            this.initTrigger.release();
        }
    }

    void init() {
        while (this.resolver != null) {
            try {
                this.initTrigger.acquire();
                this.doInit();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInit() {
        this.initializing.lock();
        try {
            ResourceResolver resolver = this.resolver;
            JcrResourceResolverFactoryImpl factory = this.factory;
            if (resolver == null || factory == null) {
                return;
            }
            HashMap<String, List<MapEntry>> newResolveMapsMap = new HashMap<String, List<MapEntry>>();
            ArrayList<MapEntry> globalResolveMap = new ArrayList<MapEntry>();
            TreeMap<String, MapEntry> newMapMaps = new TreeMap<String, MapEntry>();
            this.loadResolverMap(resolver, globalResolveMap, newMapMaps);
            Collection<String> vanityTargets = this.loadVanityPaths(resolver, newResolveMapsMap);
            this.loadConfiguration(factory, globalResolveMap);
            this.loadMapConfiguration(factory, newMapMaps);
            Collections.sort(globalResolveMap);
            newResolveMapsMap.put(GLOBAL_LIST_KEY, globalResolveMap);
            this.vanityTargets = Collections.unmodifiableCollection(vanityTargets);
            this.resolveMapsMap = Collections.unmodifiableMap(newResolveMapsMap);
            this.mapMaps = Collections.unmodifiableSet(new TreeSet(newMapMaps.values()));
            this.sendChangeEvent();
        }
        catch (Exception e) {
            this.log.warn("doInit: Unexpected problem during initialization", (Throwable)e);
        }
        finally {
            this.initializing.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        boolean initLocked;
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        try {
            initLocked = this.initializing.tryLock(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            initLocked = false;
        }
        try {
            if (!initLocked) {
                this.log.warn("dispose: Could not acquire initialization lock within 10 seconds; ongoing intialization may fail");
            }
            ResourceResolver oldResolver = this.resolver;
            this.resolver = null;
            this.triggerInit();
            if (oldResolver != null) {
                oldResolver.close();
            } else {
                this.log.warn("dispose: ResourceResolver has already been cleared before; duplicate call to dispose ?");
            }
        }
        finally {
            if (initLocked) {
                this.initializing.unlock();
            }
        }
        this.factory = null;
        this.eventAdminTracker = null;
    }

    public List<MapEntry> getResolveMaps() {
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>();
        for (List<MapEntry> list : this.resolveMapsMap.values()) {
            entries.addAll(list);
        }
        Collections.sort(entries);
        return entries;
    }

    public Iterator<MapEntry> getResolveMapsIterator(String requestPath) {
        String key = null;
        int firstIndex = requestPath.indexOf(47);
        int secondIndex = requestPath.indexOf(47, firstIndex + 1);
        if (secondIndex != -1) {
            key = requestPath.substring(secondIndex);
        }
        return new MapEntryIterator(key, this.resolveMapsMap);
    }

    public Collection<MapEntry> getMapMaps() {
        return this.mapMaps;
    }

    public void handleEvent(Event event) {
        Object p = event.getProperty("path");
        if (!(p instanceof String)) {
            return;
        }
        String path = (String)p;
        if (path.startsWith(JCR_SYSTEM_PREFIX)) {
            return;
        }
        boolean doInit = true;
        if ("org/apache/sling/api/resource/Resource/REMOVED".equals(event.getTopic()) && !path.startsWith(this.mapRoot)) {
            doInit = false;
            for (String target : this.vanityTargets) {
                if (!target.startsWith(path)) continue;
                doInit = true;
                break;
            }
        }
        if (doInit) {
            this.triggerInit();
        }
    }

    private void sendChangeEvent() {
        EventAdmin ea = (EventAdmin)this.eventAdminTracker.getService();
        if (ea != null) {
            Event event = new Event("org/apache/sling/api/resource/ResourceResolverMapping/CHANGED", (Dictionary)null);
            ea.postEvent(event);
        }
    }

    private void loadResolverMap(ResourceResolver resolver, List<MapEntry> entries, Map<String, MapEntry> mapEntries) {
        Resource res = resolver.getResource(this.mapRoot);
        if (res != null) {
            this.gather(resolver, entries, mapEntries, res, "");
        }
    }

    private void gather(ResourceResolver resolver, List<MapEntry> entries, Map<String, MapEntry> mapEntries, Resource parent, String parentPath) {
        Iterator children = ResourceUtil.listChildren((Resource)parent);
        while (children.hasNext()) {
            List<MapEntry> childMapEntries;
            MapEntry childResolveEntry;
            String childPath;
            Resource child = (Resource)children.next();
            ValueMap vm = ResourceUtil.getValueMap((Resource)child);
            String name = (String)vm.get("sling:match", String.class);
            boolean trailingSlash = false;
            if (name == null) {
                name = ResourceUtil.getName((Resource)child).concat("/");
                trailingSlash = true;
            }
            if (!(childPath = parentPath.concat(name)).endsWith("$")) {
                String childParent = childPath;
                if (!trailingSlash) {
                    childParent = childParent.concat("/");
                }
                this.gather(resolver, entries, mapEntries, child, childParent);
            }
            if ((childResolveEntry = MapEntry.createResolveEntry(childPath, child, trailingSlash)) != null) {
                entries.add(childResolveEntry);
            }
            if ((childMapEntries = MapEntry.createMapEntry(childPath, child, trailingSlash)) == null) continue;
            for (MapEntry mapEntry : childMapEntries) {
                this.addMapEntry(mapEntries, mapEntry.getPattern(), mapEntry.getRedirect()[0], mapEntry.getStatus());
            }
        }
    }

    private void addEntry(Map<String, List<MapEntry>> entryMap, String key, MapEntry entry) {
        List<MapEntry> entries = entryMap.get(key);
        if (entries == null) {
            entries = new ArrayList<MapEntry>();
            entryMap.put(key, entries);
        }
        entries.add(entry);
        Collections.sort(entries);
    }

    private Collection<String> loadVanityPaths(ResourceResolver resolver, Map<String, List<MapEntry>> entryMap) {
        HashSet<String> targetPaths = new HashSet<String>();
        String queryString = "SELECT sling:vanityPath, sling:redirect, sling:redirectStatus FROM sling:VanityPath WHERE sling:vanityPath IS NOT NULL ORDER BY sling:vanityOrder DESC";
        Iterator i = resolver.findResources("SELECT sling:vanityPath, sling:redirect, sling:redirectStatus FROM sling:VanityPath WHERE sling:vanityPath IS NOT NULL ORDER BY sling:vanityOrder DESC", "sql");
        while (i.hasNext()) {
            String[] pVanityPaths;
            Resource resource = (Resource)i.next();
            if (resource.getPath().startsWith(JCR_SYSTEM_PREFIX)) {
                this.log.debug("loadVanityPaths: Ignoring {}", (Object)resource);
                continue;
            }
            ValueMap props = (ValueMap)resource.adaptTo(ValueMap.class);
            if (props == null) {
                this.log.debug("loadVanityPaths: Ignoring {} without properties", (Object)resource);
                continue;
            }
            for (String pVanityPath : pVanityPaths = (String[])props.get("sling:vanityPath", (Object)new String[0])) {
                String[] result = this.getVanityPathDefinition(pVanityPath);
                if (result == null) continue;
                String url = result[0] + result[1];
                String redirect = resource.getName().equals("jcr:content") ? resource.getParent().getPath() : resource.getPath();
                int status = (Boolean)props.get("sling:redirect", (Object)false) != false ? (Integer)props.get("sling:redirectStatus", (Object)302) : -1;
                String checkPath = result[1];
                this.addEntry(entryMap, checkPath, new MapEntry(url + "$", status, false, redirect + ".html"));
                this.addEntry(entryMap, checkPath, new MapEntry(url + "(\\..*)", status, false, redirect + "$1"));
                targetPaths.add(redirect);
            }
        }
        return targetPaths;
    }

    private String[] getVanityPathDefinition(String pVanityPath) {
        String info;
        String[] result = null;
        if (pVanityPath != null && (info = pVanityPath.trim()).length() > 0) {
            String prefix = null;
            String path = null;
            if (info.indexOf(":/") > -1) {
                try {
                    URL u = new URL(info);
                    prefix = u.getProtocol() + '/' + u.getHost() + '.' + u.getPort();
                    path = u.getPath();
                }
                catch (MalformedURLException e) {
                    this.log.warn("Ignoring malformed vanity path {}", (Object)pVanityPath);
                }
            } else {
                prefix = "^[^/]+/[^/]+";
                path = !info.startsWith("/") ? "/" + info : info;
            }
            if (prefix != null) {
                int lastSlash = path.lastIndexOf(47);
                int firstDot = path.indexOf(46, lastSlash + 1);
                if (firstDot != -1) {
                    path = path.substring(0, firstDot);
                    this.log.warn("Removing extension from vanity path {}", (Object)pVanityPath);
                }
                result = new String[]{prefix, path};
            }
        }
        return result;
    }

    private void loadConfiguration(JcrResourceResolverFactoryImpl factory, List<MapEntry> entries) {
        Mapping[] mappings;
        BidiMap virtuals = factory.getVirtualURLMap();
        if (virtuals != null) {
            for (Map.Entry virtualEntry : virtuals.entrySet()) {
                String intPath;
                String extPath = (String)virtualEntry.getKey();
                if (extPath.equals(intPath = (String)virtualEntry.getValue())) continue;
                String url = "^[^/]+/[^/]+" + extPath + "$";
                String redirect = intPath;
                entries.add(new MapEntry(url, -1, false, redirect));
            }
        }
        if ((mappings = factory.getMappings()) != null) {
            HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
            for (Mapping mapping : mappings) {
                if (!mapping.mapsInbound()) continue;
                String url = mapping.getTo();
                String alias = mapping.getFrom();
                if (url.length() <= 0) continue;
                ArrayList<String> aliasList = (ArrayList<String>)map.get(url);
                if (aliasList == null) {
                    aliasList = new ArrayList<String>();
                    map.put(url, aliasList);
                }
                aliasList.add(alias);
            }
            for (Map.Entry entry : map.entrySet()) {
                entries.add(new MapEntry(ANY_SCHEME_HOST + (String)entry.getKey(), -1, false, ((List)entry.getValue()).toArray(new String[0])));
            }
        }
    }

    private void loadMapConfiguration(JcrResourceResolverFactoryImpl factory, Map<String, MapEntry> entries) {
        BidiMap virtuals;
        Mapping[] mappings = factory.getMappings();
        if (mappings != null) {
            for (int i = mappings.length - 1; i >= 0; --i) {
                String alias;
                String url;
                Mapping mapping = mappings[i];
                if (!mapping.mapsOutbound() || (url = mapping.getTo()).equals(alias = mapping.getFrom())) continue;
                this.addMapEntry(entries, alias, url, -1);
            }
        }
        if ((virtuals = factory.getVirtualURLMap()) != null) {
            for (Map.Entry virtualEntry : virtuals.entrySet()) {
                String intPath;
                String extPath = (String)virtualEntry.getKey();
                if (extPath.equals(intPath = (String)virtualEntry.getValue())) continue;
                String path = "^" + intPath + "$";
                String url = extPath;
                this.addMapEntry(entries, path, url, -1);
            }
        }
    }

    private void addMapEntry(Map<String, MapEntry> entries, String path, String url, int status) {
        MapEntry entry = entries.get(path);
        if (entry == null) {
            entry = new MapEntry(path, status, false, url);
        } else {
            String[] redir = entry.getRedirect();
            String[] newRedir = new String[redir.length + 1];
            System.arraycopy(redir, 0, newRedir, 0, redir.length);
            newRedir[redir.length] = url;
            entry = new MapEntry(entry.getPattern(), entry.getStatus(), false, newRedir);
        }
        entries.put(path, entry);
    }

    private static String createFilter() {
        String[] nodeProps = new String[]{"sling:vanityPath", "sling:vanityOrder", "sling:redirectStatus", "sling:redirect", "sling:internalRedirect", "sling:status", "sling:match"};
        String[] eventProps = new String[]{"resourceAddedAttributes", "resourceChangedAttributes", "resourceRemovedAttributes"};
        StringBuilder filter = new StringBuilder();
        filter.append("(|");
        for (String eventProp : eventProps) {
            filter.append("(|");
            for (String nodeProp : nodeProps) {
                filter.append('(').append(eventProp).append('=').append(nodeProp).append(')');
            }
            filter.append(")");
        }
        filter.append("(event.topics=org/apache/sling/api/resource/Resource/REMOVED)");
        filter.append(")");
        return filter.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MapEntryIterator
    implements Iterator<MapEntry> {
        private final Map<String, List<MapEntry>> resolveMapsMap;
        private String key;
        private MapEntry next;
        private Iterator<MapEntry> globalListIterator;
        private MapEntry nextGlobal;
        private Iterator<MapEntry> specialIterator;
        private MapEntry nextSpecial;

        public MapEntryIterator(String startKey, Map<String, List<MapEntry>> resolveMapsMap) {
            this.key = startKey;
            this.resolveMapsMap = resolveMapsMap;
            this.globalListIterator = this.resolveMapsMap.get(MapEntries.GLOBAL_LIST_KEY).iterator();
            this.seek();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public MapEntry next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            MapEntry result = this.next;
            this.seek();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void seek() {
            if (this.nextGlobal == null && this.globalListIterator.hasNext()) {
                this.nextGlobal = this.globalListIterator.next();
            }
            if (this.nextSpecial == null) {
                if (this.specialIterator != null && !this.specialIterator.hasNext()) {
                    this.specialIterator = null;
                }
                while (this.specialIterator == null && this.key != null) {
                    List<MapEntry> special;
                    int lastSlashPos = this.key.lastIndexOf(47);
                    int lastDotPos = this.key.indexOf(46, lastSlashPos);
                    if (lastDotPos != -1) {
                        this.key = this.key.substring(0, lastDotPos);
                    }
                    if ((special = this.resolveMapsMap.get(this.key)) != null) {
                        this.specialIterator = special.iterator();
                    }
                    if (this.key.length() > 1) {
                        int lastSlash = this.key.lastIndexOf("/");
                        if (lastSlash == 0) {
                            this.key = null;
                            continue;
                        }
                        this.key = this.key.substring(0, lastSlash);
                        continue;
                    }
                    this.key = null;
                }
                if (this.specialIterator != null && this.specialIterator.hasNext()) {
                    this.nextSpecial = this.specialIterator.next();
                }
            }
            if (this.nextSpecial == null) {
                this.next = this.nextGlobal;
                this.nextGlobal = null;
            } else if (this.nextGlobal == null) {
                this.next = this.nextSpecial;
                this.nextSpecial = null;
            } else if (this.nextGlobal.getPattern().length() >= this.nextSpecial.getPattern().length()) {
                this.next = this.nextGlobal;
                this.nextGlobal = null;
            } else {
                this.next = this.nextSpecial;
                this.nextSpecial = null;
            }
        }
    }
}

