/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.resource.internal.helper.ResourceProviderEntry;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootResourceProviderEntry
extends ResourceProviderEntry {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public RootResourceProviderEntry() {
        super("/", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindResourceProvider(ResourceProvider provider, Map<String, Object> props, ServiceTracker eventAdminTracker) {
        String serviceName = this.getServiceName(provider, props);
        this.logger.debug("bindResourceProvider: Binding {}", (Object)serviceName);
        String[] roots = OsgiUtil.toStringArray((Object)props.get("provider.roots"));
        if (roots != null && roots.length > 0) {
            EventAdmin localEA = (EventAdmin)(eventAdminTracker != null ? eventAdminTracker.getService() : null);
            for (String root : roots) {
                if (root.endsWith("/") && root.length() > 1) {
                    root = root.substring(0, root.length() - 1);
                }
                RootResourceProviderEntry rootResourceProviderEntry = this;
                synchronized (rootResourceProviderEntry) {
                    this.addResourceProvider(root, provider, OsgiUtil.getComparableForServiceRanking(props));
                }
                this.logger.debug("bindResourceProvider: {}={} ({})", new Object[]{root, provider, serviceName});
                if (localEA == null) continue;
                Hashtable<String, String> eventProps = new Hashtable<String, String>();
                ((Dictionary)eventProps).put("path", root);
                localEA.postEvent(new Event("org/apache/sling/api/resource/ResourceProvider/ADDED", eventProps));
            }
        }
        this.logger.debug("bindResourceProvider: Bound {}", (Object)serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindResourceProvider(ResourceProvider provider, Map<String, Object> props, ServiceTracker eventAdminTracker) {
        String serviceName = this.getServiceName(provider, props);
        this.logger.debug("unbindResourceProvider: Unbinding {}", (Object)serviceName);
        String[] roots = OsgiUtil.toStringArray((Object)props.get("provider.roots"));
        if (roots != null && roots.length > 0) {
            EventAdmin localEA = (EventAdmin)(eventAdminTracker != null ? eventAdminTracker.getService() : null);
            for (String root : roots) {
                if (root.endsWith("/") && root.length() > 1) {
                    root = root.substring(0, root.length() - 1);
                }
                RootResourceProviderEntry rootResourceProviderEntry = this;
                synchronized (rootResourceProviderEntry) {
                    this.removeResourceProvider(root, provider, OsgiUtil.getComparableForServiceRanking(props));
                }
                this.logger.debug("unbindResourceProvider: root={} ({})", (Object)root, (Object)serviceName);
                if (localEA == null) continue;
                Hashtable<String, String> eventProps = new Hashtable<String, String>();
                ((Dictionary)eventProps).put("path", root);
                localEA.postEvent(new Event("org/apache/sling/api/resource/ResourceProvider/REMOVED", eventProps));
            }
        }
        this.logger.debug("unbindResourceProvider: Unbound {}", (Object)serviceName);
    }

    private String getServiceName(ResourceProvider provider, Map<String, Object> props) {
        if (this.logger.isDebugEnabled()) {
            StringBuilder snBuilder = new StringBuilder(64);
            snBuilder.append('{');
            snBuilder.append(provider.toString());
            snBuilder.append('/');
            snBuilder.append(props.get("service.id"));
            snBuilder.append('}');
            return snBuilder.toString();
        }
        return null;
    }
}

