/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Session;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.apache.sling.jcr.resource.internal.JcrItemAdapterFactory;
import org.osgi.service.component.ComponentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrResourceResolverFactoryImpl
implements JcrResourceResolverFactory {
    private ResourceResolverFactory delegatee;
    private DynamicClassLoaderManager dynamicClassLoaderManager;
    private JcrItemAdapterFactory jcrItemAdapterFactory;

    protected void activate(ComponentContext componentContext) {
        this.jcrItemAdapterFactory = new JcrItemAdapterFactory(componentContext.getBundleContext(), this);
    }

    protected void deactivate(ComponentContext componentContext) {
        if (this.jcrItemAdapterFactory != null) {
            this.jcrItemAdapterFactory.dispose();
            this.jcrItemAdapterFactory = null;
        }
    }

    ClassLoader getDynamicClassLoader() {
        DynamicClassLoaderManager dclm = this.dynamicClassLoaderManager;
        if (dclm != null) {
            return dclm.getDynamicClassLoader();
        }
        return null;
    }

    @Override
    public ResourceResolver getResourceResolver(Session session) {
        HashMap<String, Object> authInfo = new HashMap<String, Object>(1);
        authInfo.put("user.jcr.session", session);
        try {
            return this.getResourceResolver(authInfo);
        }
        catch (LoginException le) {
            throw new InternalError("Unexpected LoginException");
        }
    }

    public ResourceResolver getAdministrativeResourceResolver(Map<String, Object> arg0) throws LoginException {
        return this.delegatee.getAdministrativeResourceResolver(arg0);
    }

    public ResourceResolver getResourceResolver(Map<String, Object> arg0) throws LoginException {
        return this.delegatee.getResourceResolver(arg0);
    }

    protected void bindDelegatee(ResourceResolverFactory resourceResolverFactory) {
        this.delegatee = resourceResolverFactory;
    }

    protected void unbindDelegatee(ResourceResolverFactory resourceResolverFactory) {
        if (this.delegatee == resourceResolverFactory) {
            this.delegatee = null;
        }
    }

    protected void bindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.dynamicClassLoaderManager = dynamicClassLoaderManager;
    }

    protected void unbindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        if (this.dynamicClassLoaderManager == dynamicClassLoaderManager) {
            this.dynamicClassLoaderManager = null;
        }
    }
}

