/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceProviderFactory;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.JcrResourceListener;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProvider;
import org.osgi.service.component.ComponentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrResourceProviderFactory
implements ResourceProviderFactory {
    private DynamicClassLoaderManager dynamicClassLoaderManager;
    private SlingRepository repository;
    private JcrResourceListener listener;

    protected void activate(ComponentContext context) throws RepositoryException {
        String root = PropertiesUtil.toString(context.getProperties().get("provider.roots"), (String)"/");
        this.listener = new JcrResourceListener(root, null, this.repository, context.getBundleContext());
    }

    protected void deactivate() {
        if (this.listener != null) {
            this.listener.deactivate();
            this.listener = null;
        }
    }

    ClassLoader getDynamicClassLoader() {
        DynamicClassLoaderManager dclm = this.dynamicClassLoaderManager;
        if (dclm != null) {
            return dclm.getDynamicClassLoader();
        }
        return null;
    }

    public ResourceProvider getResourceProvider(Map<String, Object> authenticationInfo) throws org.apache.sling.api.resource.LoginException {
        return this.getResourceProviderInternal(authenticationInfo, false);
    }

    public ResourceProvider getAdministrativeResourceProvider(Map<String, Object> authenticationInfo) throws org.apache.sling.api.resource.LoginException {
        return this.getResourceProviderInternal(authenticationInfo, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceProvider getResourceProviderInternal(Map<String, Object> authenticationInfo, boolean isAdmin) throws org.apache.sling.api.resource.LoginException {
        Session session;
        boolean logoutSession;
        block11: {
            logoutSession = true;
            try {
                String workspace = this.getWorkspace(authenticationInfo);
                if (isAdmin) {
                    session = this.repository.loginAdministrative(workspace);
                    break block11;
                }
                session = this.getSession(authenticationInfo);
                if (session == null) {
                    Credentials credentials = this.getCredentials(authenticationInfo);
                    session = this.repository.login(credentials, workspace);
                    break block11;
                }
                if (workspace != null) {
                    Session tmpSession = null;
                    try {
                        tmpSession = this.repository.loginAdministrative(workspace);
                        if (tmpSession.getUserID().equals(session.getUserID())) {
                            session = tmpSession;
                            tmpSession = null;
                        } else {
                            session = tmpSession.impersonate((Credentials)new SimpleCredentials(session.getUserID(), new char[0]));
                        }
                        break block11;
                    }
                    finally {
                        if (tmpSession != null) {
                            tmpSession.logout();
                        }
                    }
                }
                logoutSession = false;
            }
            catch (RepositoryException re) {
                throw this.getLoginException(re);
            }
        }
        session = this.handleImpersonation(session, authenticationInfo, logoutSession);
        return new JcrResourceProvider(session, this.getDynamicClassLoader(), logoutSession);
    }

    private String getSudoUser(Map<String, Object> authenticationInfo) {
        Object sudoObject;
        if (authenticationInfo != null && (sudoObject = authenticationInfo.get("user.impersonation")) instanceof String) {
            return (String)sudoObject;
        }
        return null;
    }

    private String getWorkspace(Map<String, Object> authenticationInfo) {
        Object workspaceObject;
        if (authenticationInfo != null && (workspaceObject = authenticationInfo.get("user.jcr.workspace")) instanceof String) {
            return (String)workspaceObject;
        }
        return null;
    }

    private Session handleImpersonation(Session session, Map<String, Object> authenticationInfo, boolean logoutSession) throws org.apache.sling.api.resource.LoginException {
        String sudoUser = this.getSudoUser(authenticationInfo);
        if (sudoUser != null && !session.getUserID().equals(sudoUser)) {
            try {
                SimpleCredentials creds = new SimpleCredentials(sudoUser, new char[0]);
                this.copyAttributes(creds, authenticationInfo);
                creds.setAttribute("user.impersonator", (Object)session.getUserID());
                Session session2 = session.impersonate((Credentials)creds);
                return session2;
            }
            catch (RepositoryException re) {
                throw this.getLoginException(re);
            }
            finally {
                if (logoutSession) {
                    session.logout();
                }
            }
        }
        return session;
    }

    private org.apache.sling.api.resource.LoginException getLoginException(RepositoryException re) {
        if (re instanceof LoginException) {
            return new org.apache.sling.api.resource.LoginException(re.getMessage(), re.getCause());
        }
        return new org.apache.sling.api.resource.LoginException("Unable to login " + re.getMessage(), (Throwable)re);
    }

    private Credentials getCredentials(Map<String, Object> authenticationInfo) {
        if (authenticationInfo == null) {
            return null;
        }
        Object credentialsObject = authenticationInfo.get("user.jcr.credentials");
        if (credentialsObject instanceof Credentials) {
            return (Credentials)credentialsObject;
        }
        Object userId = authenticationInfo.get("user.name");
        if (userId instanceof String) {
            Object password = authenticationInfo.get("user.password");
            SimpleCredentials credentials = new SimpleCredentials((String)userId, password instanceof char[] ? (char[])password : new char[]{});
            this.copyAttributes(credentials, authenticationInfo);
            return credentials;
        }
        return null;
    }

    private void copyAttributes(SimpleCredentials target, Map<String, Object> source) {
        for (Map.Entry<String, Object> current : source.entrySet()) {
            if (!JcrResourceProviderFactory.isAttributeVisible(current.getKey())) continue;
            target.setAttribute(current.getKey(), current.getValue());
        }
    }

    public static boolean isAttributeVisible(String name) {
        return !name.equals("user.jcr.credentials") && !name.contains("password");
    }

    private Session getSession(Map<String, Object> authenticationInfo) {
        Object sessionObject;
        if (authenticationInfo != null && (sessionObject = authenticationInfo.get("user.jcr.session")) instanceof Session) {
            return (Session)sessionObject;
        }
        return null;
    }

    protected void bindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.dynamicClassLoaderManager = dynamicClassLoaderManager;
    }

    protected void unbindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        if (this.dynamicClassLoaderManager == dynamicClassLoaderManager) {
            this.dynamicClassLoaderManager = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

