/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.sling.jcr.resource.JcrResourceUtil;

public class JcrPropertyMapCacheEntry {
    public final Property property;
    public final boolean isMulti;
    public final Value[] values;
    private final Object defaultValue;

    private Value createValue(Object obj, Session session) throws RepositoryException {
        Value value = JcrResourceUtil.createValue(obj, session);
        if (value == null && obj instanceof Serializable) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                oos.close();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                value = session.getValueFactory().createValue(session.getValueFactory().createBinary((InputStream)bais));
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return value;
    }

    public JcrPropertyMapCacheEntry(Property prop) throws RepositoryException {
        this.property = prop;
        if (prop.isMultiple()) {
            this.isMulti = true;
            this.values = prop.getValues();
        } else {
            this.isMulti = false;
            this.values = new Value[]{prop.getValue()};
        }
        Object tmp = JcrResourceUtil.toJavaObject(prop);
        this.defaultValue = this.isDefaultValueCacheable() ? tmp : null;
    }

    public JcrPropertyMapCacheEntry(Object value, Session session) throws RepositoryException {
        this.property = null;
        this.defaultValue = value;
        if (value.getClass().isArray()) {
            this.isMulti = true;
            Object[] values = (Object[])value;
            this.values = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                this.values[i] = this.createValue(values[i], session);
                if (this.values[i] != null) continue;
                throw new IllegalArgumentException("Value can't be stored in the repository: " + values[i]);
            }
        } else {
            this.isMulti = false;
            this.values = new Value[]{this.createValue(value, session)};
            if (this.values[0] == null) {
                throw new IllegalArgumentException("Value can't be stored in the repository: " + value);
            }
        }
    }

    public Object getDefaultValue() throws RepositoryException {
        return this.defaultValue != null ? this.defaultValue : JcrResourceUtil.toJavaObject(this.property);
    }

    public Object getDefaultValueOrNull() {
        try {
            return this.getDefaultValue();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    private boolean isDefaultValueCacheable() throws RepositoryException {
        return this.property.getType() != 2;
    }
}

