/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.resource.internal.helper.JcrPropertyMapCacheEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrPropertyMap
implements ValueMap {
    private static Logger LOGGER = LoggerFactory.getLogger(JcrPropertyMap.class);
    private final Node node;
    final Map<String, JcrPropertyMapCacheEntry> cache;
    final Map<String, Object> valueCache;
    boolean fullyRead;
    private final ClassLoader dynamicClassLoader;

    public JcrPropertyMap(Node node) {
        this(node, null);
    }

    public JcrPropertyMap(Node node, ClassLoader dynamicCL) {
        this.node = node;
        this.cache = new LinkedHashMap<String, JcrPropertyMapCacheEntry>();
        this.valueCache = new LinkedHashMap<String, Object>();
        this.fullyRead = false;
        this.dynamicClassLoader = dynamicCL;
    }

    Node getNode() {
        return this.node;
    }

    String checkKey(String key) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        if (key.startsWith("./")) {
            return key.substring(2);
        }
        return key;
    }

    public <T> T get(String aKey, Class<T> type) {
        String key = this.checkKey(aKey);
        if (type == null) {
            return (T)this.get(key);
        }
        JcrPropertyMapCacheEntry entry = this.read(key);
        if (entry == null) {
            return null;
        }
        return this.convertToType(entry, type);
    }

    public <T> T get(String aKey, T defaultValue) {
        String key = this.checkKey(aKey);
        if (defaultValue == null) {
            return (T)this.get(key);
        }
        Class<?> type = this.normalizeClass(defaultValue.getClass());
        Class<Object> value = this.get(key, (T)type);
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    public Object get(Object aKey) {
        String key = this.checkKey(aKey.toString());
        JcrPropertyMapCacheEntry entry = this.read(key);
        Object value = entry == null ? null : entry.getDefaultValueOrNull();
        return value;
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        this.readFully();
        return this.valueCache.containsValue(value);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        this.readFully();
        return this.cache.size();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        this.readFully();
        Map<String, Object> sourceMap = this.cache.size() == this.valueCache.size() ? this.valueCache : this.transformEntries(this.cache);
        return Collections.unmodifiableSet(sourceMap.entrySet());
    }

    public Set<String> keySet() {
        this.readFully();
        return this.cache.keySet();
    }

    public Collection<Object> values() {
        this.readFully();
        Map<String, Object> sourceMap = this.cache.size() == this.valueCache.size() ? this.valueCache : this.transformEntries(this.cache);
        return Collections.unmodifiableCollection(sourceMap.values());
    }

    @Deprecated
    public String getPath() {
        try {
            return this.node.getPath();
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    private JcrPropertyMapCacheEntry cacheProperty(Property prop) {
        try {
            JcrPropertyMapCacheEntry entry;
            String name = prop.getName();
            String key = null;
            if (name.indexOf("_x") != -1 && (key = ISO9075.decode(name)).equals(name)) {
                key = null;
            }
            if (key == null) {
                key = Text.unescapeIllegalJcrChars(name);
            }
            if ((entry = this.cache.get(key)) == null) {
                entry = new JcrPropertyMapCacheEntry(prop);
                this.cache.put(key, entry);
                Object defaultValue = entry.getDefaultValue();
                if (defaultValue != null) {
                    this.valueCache.put(key, entry.getDefaultValue());
                }
            }
            return entry;
        }
        catch (RepositoryException re) {
            throw new IllegalArgumentException(re);
        }
    }

    JcrPropertyMapCacheEntry read(String name) {
        if (name.length() == 0) {
            return null;
        }
        if (name.indexOf(47) != -1) {
            int pos;
            String path = ISO9075.encodePath(name);
            try {
                if (this.node.hasProperty(path)) {
                    return new JcrPropertyMapCacheEntry(this.node.getProperty(path));
                }
            }
            catch (RepositoryException re) {
                throw new IllegalArgumentException(re);
            }
            StringBuilder sb = new StringBuilder();
            int lastPos = -1;
            for (pos = 0; pos < name.length(); ++pos) {
                if (name.charAt(pos) != '/') continue;
                if (lastPos + 1 < pos) {
                    sb.append(Text.escapeIllegalJcrChars(name.substring(lastPos + 1, pos)));
                }
                sb.append('/');
                lastPos = pos;
            }
            if (lastPos + 1 < pos) {
                sb.append(Text.escapeIllegalJcrChars(name.substring(lastPos + 1)));
            }
            String newPath = sb.toString();
            try {
                if (this.node.hasProperty(newPath)) {
                    return new JcrPropertyMapCacheEntry(this.node.getProperty(newPath));
                }
            }
            catch (RepositoryException re) {
                throw new IllegalArgumentException(re);
            }
            return null;
        }
        if (this.fullyRead) {
            return this.cache.get(name);
        }
        try {
            String key = this.escapeKeyName(name);
            if (this.node.hasProperty(key)) {
                Property prop = this.node.getProperty(key);
                return this.cacheProperty(prop);
            }
        }
        catch (RepositoryException re) {
            throw new IllegalArgumentException(re);
        }
        try {
            String oldKey = ISO9075.encodePath(name);
            if (this.node.hasProperty(oldKey)) {
                Property prop = this.node.getProperty(oldKey);
                return this.cacheProperty(prop);
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }

    protected String escapeKeyName(String key) throws RepositoryException {
        int indexOfPrefix = key.indexOf(58);
        if (indexOfPrefix > 0 && key.length() > indexOfPrefix + 1) {
            String prefix = key.substring(0, indexOfPrefix);
            for (String existingPrefix : this.getNode().getSession().getNamespacePrefixes()) {
                if (!existingPrefix.equals(prefix)) continue;
                return prefix + ":" + Text.escapeIllegalJcrChars(key.substring(indexOfPrefix + 1));
            }
        }
        return Text.escapeIllegalJcrChars(key);
    }

    void readFully() {
        if (!this.fullyRead) {
            try {
                PropertyIterator pi = this.node.getProperties();
                while (pi.hasNext()) {
                    Property prop = pi.nextProperty();
                    this.cacheProperty(prop);
                }
                this.fullyRead = true;
            }
            catch (RepositoryException re) {
                throw new IllegalArgumentException(re);
            }
        }
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map<? extends String, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    private <T> T convertToType(JcrPropertyMapCacheEntry entry, Class<T> type) {
        Object result = null;
        try {
            boolean array = type.isArray();
            if (entry.isMulti) {
                if (array) {
                    result = this.convertToArray(entry, type.getComponentType());
                } else if (entry.values.length > 0) {
                    result = this.convertToType(entry, -1, entry.values[0], type);
                }
            } else {
                result = array ? this.convertToArray(entry, type.getComponentType()) : this.convertToType(entry, -1, entry.values[0], type);
            }
        }
        catch (ValueFormatException vfe) {
            LOGGER.info("converToType: Cannot convert value of " + entry.getDefaultValueOrNull() + " to " + type, (Throwable)vfe);
        }
        catch (RepositoryException re) {
            LOGGER.info("converToType: Cannot get value of " + entry.getDefaultValueOrNull(), (Throwable)re);
        }
        return (T)result;
    }

    private <T> T[] convertToArray(JcrPropertyMapCacheEntry entry, Class<T> type) throws ValueFormatException, RepositoryException {
        ArrayList<T> values = new ArrayList<T>();
        for (int i = 0; i < entry.values.length; ++i) {
            T value = this.convertToType(entry, i, entry.values[i], type);
            if (value == null) continue;
            values.add(value);
        }
        Object[] result = (Object[])Array.newInstance(type, values.size());
        return values.toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T convertToType(JcrPropertyMapCacheEntry entry, int index, Value jcrValue, Class<T> type) throws ValueFormatException, RepositoryException {
        block35: {
            Object defaultValue = entry.getDefaultValue();
            if (type.isInstance(defaultValue)) {
                return (T)defaultValue;
            }
            if (String.class == type) {
                return (T)jcrValue.getString();
            }
            if (Byte.class == type) {
                return (T)Byte.valueOf((byte)jcrValue.getLong());
            }
            if (Short.class == type) {
                return (T)Short.valueOf((short)jcrValue.getLong());
            }
            if (Integer.class == type) {
                return (T)Integer.valueOf((int)jcrValue.getLong());
            }
            if (Long.class == type) {
                if (jcrValue.getType() == 2) {
                    if (index == -1) {
                        return (T)Long.valueOf(entry.property.getLength());
                    }
                    return (T)Long.valueOf(entry.property.getLengths()[index]);
                }
                return (T)Long.valueOf(jcrValue.getLong());
            }
            if (Float.class == type) {
                return (T)Float.valueOf((float)jcrValue.getDouble());
            }
            if (Double.class == type) {
                return (T)Double.valueOf(jcrValue.getDouble());
            }
            if (BigDecimal.class == type) {
                return (T)jcrValue.getDecimal();
            }
            if (Boolean.class == type) {
                return (T)Boolean.valueOf(jcrValue.getBoolean());
            }
            if (Date.class == type) {
                return (T)jcrValue.getDate().getTime();
            }
            if (Calendar.class == type) {
                return (T)jcrValue.getDate();
            }
            if (Value.class == type) {
                return (T)jcrValue;
            }
            if (Property.class == type) {
                return (T)entry.property;
            }
            if (Serializable.class.isAssignableFrom(type) && jcrValue.getType() == 2) {
                Object object;
                java.io.ObjectInputStream ois = null;
                try {
                    ois = new ObjectInputStream(jcrValue.getBinary().getStream(), this.dynamicClassLoader);
                    Object obj = ois.readObject();
                    if (!type.isInstance(obj)) break block35;
                    object = obj;
                }
                catch (ClassNotFoundException cnfe) {
                    break block35;
                }
                catch (IOException ioe) {
                    break block35;
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
                return (T)object;
            }
        }
        return null;
    }

    private Class<?> normalizeClass(Class<?> type) {
        if (Calendar.class.isAssignableFrom(type)) {
            type = Calendar.class;
        } else if (Date.class.isAssignableFrom(type)) {
            type = Date.class;
        } else if (Value.class.isAssignableFrom(type)) {
            type = Value.class;
        } else if (Property.class.isAssignableFrom(type)) {
            type = Property.class;
        }
        return type;
    }

    private Map<String, Object> transformEntries(Map<String, JcrPropertyMapCacheEntry> map) {
        LinkedHashMap<String, Object> transformedEntries = new LinkedHashMap<String, Object>(map.size());
        for (Map.Entry<String, JcrPropertyMapCacheEntry> entry : map.entrySet()) {
            transformedEntries.put(entry.getKey(), entry.getValue().getDefaultValueOrNull());
        }
        return transformedEntries;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JcrPropertyMap [node=");
        sb.append(this.node);
        sb.append(", values={");
        Iterator<Map.Entry<String, Object>> iter = this.entrySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Map.Entry<String, Object> e = iter.next();
            sb.append(e.getKey());
            sb.append("=");
            sb.append(e.getValue());
        }
        sb.append("}]");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectInputStream
    extends java.io.ObjectInputStream {
        private ClassLoader classloader;

        public ObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classloader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            if (this.classloader != null) {
                return this.classloader.loadClass(classDesc.getName());
            }
            return super.resolveClass(classDesc);
        }
    }
}

