/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.jackrabbit.api.observation.JackrabbitEvent;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrResourceListener
implements EventListener {
    private final Logger logger = LoggerFactory.getLogger(JcrResourceListener.class);
    private final ServiceTracker eventAdminTracker;
    private ServiceReference resourceResolverFactoryReference;
    private ResourceResolver resourceResolver;
    private final Session session;
    private final String startPath;
    private final String mountPrefix;
    private final boolean hasJackrabbitEventClass;
    private final LinkedBlockingQueue<Dictionary<String, Object>> osgiEventQueue;
    private final BundleContext bundleContext;
    private final Dictionary<String, Object> TERMINATE_PROCESSING = new Hashtable<String, Object>(1);

    public JcrResourceListener(String startPath, String mountPrefix, SlingRepository repository, BundleContext bundleContext) throws RepositoryException {
        boolean foundClass = false;
        try {
            this.getClass().getClassLoader().loadClass(JackrabbitEvent.class.getName());
            foundClass = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.hasJackrabbitEventClass = foundClass;
        this.startPath = startPath;
        this.mountPrefix = mountPrefix;
        this.bundleContext = bundleContext;
        this.eventAdminTracker = new ServiceTracker(bundleContext, EventAdmin.class.getName(), null);
        this.eventAdminTracker.open();
        this.session = repository.loginAdministrative(null);
        try {
            this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 31, this.startPath, true, null, null, false);
        }
        catch (RepositoryException re) {
            this.session.logout();
            throw re;
        }
        this.osgiEventQueue = new LinkedBlockingQueue();
        Thread oeqt = new Thread(new Runnable(){

            public void run() {
                JcrResourceListener.this.processOsgiEventQueue();
            }
        }, "Apche Sling JCR Resource Event Queue Processor for path '" + this.startPath + "'");
        oeqt.start();
    }

    public void deactivate() {
        if (this.session != null) {
            try {
                this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
            }
            catch (RepositoryException e) {
                this.logger.warn("Unable to remove session listener: " + this, (Throwable)e);
            }
            this.session.logout();
        }
        if (this.resourceResolver != null) {
            this.resourceResolver.close();
            this.resourceResolver = null;
        }
        if (this.resourceResolverFactoryReference != null) {
            this.bundleContext.ungetService(this.resourceResolverFactoryReference);
        }
        this.osgiEventQueue.clear();
        this.osgiEventQueue.offer(this.TERMINATE_PROCESSING);
        if (this.eventAdminTracker != null) {
            this.eventAdminTracker.close();
        }
    }

    public void onEvent(EventIterator events) {
        EventAdmin localEA = (EventAdmin)this.eventAdminTracker.getService();
        if (localEA == null) {
            return;
        }
        HashMap<String, Event> addedEvents = new HashMap<String, Event>();
        HashMap<String, ChangedAttributes> changedEvents = new HashMap<String, ChangedAttributes>();
        HashMap<String, Event> removedEvents = new HashMap<String, Event>();
        while (events.hasNext()) {
            Event event = events.nextEvent();
            try {
                String eventPath = this.mountPrefix != null ? this.mountPrefix + event.getPath() : event.getPath();
                if (event.getType() == 4 || event.getType() == 8 || event.getType() == 16) {
                    int lastSlash = eventPath.lastIndexOf(47);
                    String nodePath = eventPath.substring(0, lastSlash);
                    String propName = eventPath.substring(lastSlash + 1);
                    this.updateChangedEvent(changedEvents, nodePath, event, propName);
                    continue;
                }
                if (event.getType() == 1) {
                    addedEvents.put(eventPath, event);
                    continue;
                }
                if (event.getType() != 2) continue;
                addedEvents.remove(eventPath);
                removedEvents.put(eventPath, event);
            }
            catch (RepositoryException e) {
                this.logger.error("Error during modification: {}", (Object)e.getMessage());
            }
        }
        for (Map.Entry e : removedEvents.entrySet()) {
            this.sendOsgiEvent((String)e.getKey(), (Event)e.getValue(), "org/apache/sling/api/resource/Resource/REMOVED", null);
        }
        for (Map.Entry e : addedEvents.entrySet()) {
            this.sendOsgiEvent((String)e.getKey(), (Event)e.getValue(), "org/apache/sling/api/resource/Resource/ADDED", (ChangedAttributes)changedEvents.remove(e.getKey()));
        }
        for (Map.Entry e : changedEvents.entrySet()) {
            this.sendOsgiEvent((String)e.getKey(), ((ChangedAttributes)e.getValue()).firstEvent, "org/apache/sling/api/resource/Resource/CHANGED", (ChangedAttributes)e.getValue());
        }
    }

    private void updateChangedEvent(Map<String, ChangedAttributes> changedEvents, String path, Event event, String propName) {
        ChangedAttributes storedEvent = changedEvents.get(path);
        if (storedEvent == null) {
            storedEvent = new ChangedAttributes(event);
            changedEvents.put(path, storedEvent);
        }
        storedEvent.addEvent(event, propName);
    }

    private void sendOsgiEvent(String path, Event event, String topic, ChangedAttributes changedAttributes) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        if (event.getUserID() != null) {
            ((Dictionary)properties).put("userid", event.getUserID());
        }
        if (this.isExternal(event)) {
            ((Dictionary)properties).put("event.application", "unknown");
        }
        if (changedAttributes != null) {
            changedAttributes.addProperties(properties);
        }
        ((Dictionary)properties).put("path", path);
        ((Dictionary)properties).put("event.topics", topic);
        this.osgiEventQueue.offer(properties);
    }

    private ResourceResolver getResourceResolver() {
        ResourceResolverFactory factory;
        ServiceReference ref;
        if (this.resourceResolver == null && (ref = this.bundleContext.getServiceReference(ResourceResolverFactory.class.getName())) != null && (factory = (ResourceResolverFactory)this.bundleContext.getService(ref)) != null) {
            try {
                this.resourceResolver = factory.getAdministrativeResourceResolver(null);
                this.resourceResolverFactoryReference = ref;
            }
            catch (LoginException le) {
                this.logger.error("Unable to get administrative resource resolver.", (Throwable)le);
                this.bundleContext.ungetService(ref);
            }
        }
        return this.resourceResolver;
    }

    void processOsgiEventQueue() {
        while (true) {
            Dictionary<String, Object> event;
            try {
                event = this.osgiEventQueue.take();
            }
            catch (InterruptedException e) {
                continue;
            }
            if (event == null || event == this.TERMINATE_PROCESSING) break;
            try {
                EventAdmin localEa = (EventAdmin)this.eventAdminTracker.getService();
                ResourceResolver resolver = this.getResourceResolver();
                if (localEa == null || resolver == null) continue;
                String topic = (String)event.remove("event.topics");
                String path = (String)event.get("path");
                Resource resource = resolver.getResource(path);
                boolean sendEvent = true;
                if (!"org/apache/sling/api/resource/Resource/REMOVED".equals(topic)) {
                    if (resource != null) {
                        Node node = (Node)resource.adaptTo(Node.class);
                        if (node != null) {
                            String resourceSuperType;
                            String resourceType;
                            if (path.endsWith("/jcr:content")) {
                                try {
                                    Resource parentResource;
                                    if (node.getParent().isNodeType("nt:file") && (parentResource = resource.getParent()) != null) {
                                        resource = parentResource;
                                        event.put("path", resource.getPath());
                                    }
                                }
                                catch (RepositoryException re) {
                                    // empty catch block
                                }
                            }
                            if ((resourceType = resource.getResourceType()) != null) {
                                event.put("resourceType", resource.getResourceType());
                            }
                            if ((resourceSuperType = resource.getResourceSuperType()) != null) {
                                event.put("resourceSuperType", resource.getResourceSuperType());
                            }
                        } else {
                            sendEvent = false;
                        }
                    } else {
                        this.logger.debug("processOsgiEventQueue: Resource at {} not found, which is not expected for an added or modified node", (Object)path);
                        sendEvent = false;
                    }
                }
                if (!sendEvent) continue;
                localEa.sendEvent(new org.osgi.service.event.Event(topic, event));
            }
            catch (Exception e) {
                this.logger.warn("processOsgiEventQueue: Unexpected problem processing event " + event, (Throwable)e);
            }
        }
        this.osgiEventQueue.clear();
    }

    private boolean isExternal(Event event) {
        if (this.hasJackrabbitEventClass && event instanceof JackrabbitEvent) {
            JackrabbitEvent jEvent = (JackrabbitEvent)event;
            return jEvent.isExternal();
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChangedAttributes {
        private final Event firstEvent;
        public Set<String> addedAttributes;
        public Set<String> changedAttributes;
        public Set<String> removedAttributes;

        public ChangedAttributes(Event event) {
            this.firstEvent = event;
        }

        public void addEvent(Event event, String propName) {
            if (event.getType() == 4) {
                if (this.removedAttributes != null) {
                    this.removedAttributes.remove(propName);
                }
                if (this.addedAttributes == null) {
                    this.addedAttributes = new HashSet<String>();
                }
                this.addedAttributes.add(propName);
            } else if (event.getType() == 8) {
                if (this.addedAttributes != null) {
                    this.addedAttributes.remove(propName);
                }
                if (this.removedAttributes == null) {
                    this.removedAttributes = new HashSet<String>();
                }
                this.removedAttributes.add(propName);
            } else if (event.getType() == 16) {
                if (this.changedAttributes == null) {
                    this.changedAttributes = new HashSet<String>();
                }
                this.changedAttributes.add(propName);
            }
        }

        public void addProperties(Dictionary<String, Object> properties) {
            if (this.addedAttributes != null) {
                properties.put("resourceAddedAttributes", this.addedAttributes.toArray(new String[this.addedAttributes.size()]));
            }
            if (this.changedAttributes != null) {
                properties.put("resourceChangedAttributes", this.changedAttributes.toArray(new String[this.changedAttributes.size()]));
            }
            if (this.removedAttributes != null) {
                properties.put("resourceRemovedAttributes", this.removedAttributes.toArray(new String[this.removedAttributes.size()]));
            }
        }
    }
}

