/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.net.URLFactory;
import org.apache.sling.adapter.annotations.Adaptable;
import org.apache.sling.adapter.annotations.Adapter;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.resource.JcrModifiablePropertyMap;
import org.apache.sling.jcr.resource.JcrPropertyMap;
import org.apache.sling.jcr.resource.internal.JcrModifiableValueMap;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrItemResource;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResourceIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Adaptable(adaptableClass=Resource.class, adapters={@Adapter(value={Node.class, Map.class, Item.class, ValueMap.class, URL.class}), @Adapter(value={PersistableValueMap.class}, condition="If the resource is a JcrNodeResource and the user has set property privileges on the node."), @Adapter(value={InputStream.class}, condition="If the resource is a JcrNodeResource and has a jcr:data property or is an nt:file node.")})
public class JcrNodeResource
extends JcrItemResource {
    private static final String UNSET_RESOURCE_SUPER_TYPE = "<unset>";
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrNodeResource.class);
    private final Node node;
    private final String resourceType;
    protected String resourceSuperType;
    private final ClassLoader dynamicClassLoader;

    public JcrNodeResource(ResourceResolver resourceResolver, Node node, ClassLoader dynamicClassLoader) throws RepositoryException {
        super(resourceResolver, node.getPath());
        this.dynamicClassLoader = dynamicClassLoader;
        this.node = node;
        this.resourceType = this.getResourceTypeForNode(node);
        this.resourceSuperType = UNSET_RESOURCE_SUPER_TYPE;
        this.setMetaData(node, this.getResourceMetadata());
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceSuperType() {
        if (this.resourceSuperType == UNSET_RESOURCE_SUPER_TYPE) {
            try {
                if (this.node.hasProperty("sling:resourceSuperType")) {
                    this.resourceSuperType = this.node.getProperty("sling:resourceSuperType").getValue().getString();
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            if (this.resourceSuperType == UNSET_RESOURCE_SUPER_TYPE) {
                this.resourceSuperType = null;
            }
        }
        return this.resourceSuperType;
    }

    public <Type> Type adaptTo(Class<Type> type) {
        if (type == Node.class || type == Item.class) {
            return (Type)this.getNode();
        }
        if (type == InputStream.class) {
            return (Type)this.getInputStream();
        }
        if (type == URL.class) {
            return (Type)this.getURL();
        }
        if (type == Map.class || type == ValueMap.class) {
            return (Type)new JcrPropertyMap(this.getNode(), this.dynamicClassLoader);
        }
        if (type == PersistableValueMap.class) {
            try {
                this.getNode().getSession().checkPermission(this.getNode().getPath(), "set_property");
                return (Type)new JcrModifiablePropertyMap(this.getNode(), this.dynamicClassLoader);
            }
            catch (AccessControlException ace) {
                LOGGER.debug("adaptTo(PersistableValueMap): Cannot set properties on {}", (Object)this);
            }
            catch (RepositoryException e) {
                LOGGER.debug("adaptTo(PersistableValueMap): Unexpected problem for {}", (Object)this);
            }
        } else if (type == ModifiableValueMap.class) {
            try {
                this.getNode().getSession().checkPermission(this.getNode().getPath(), "set_property");
                return (Type)new JcrModifiableValueMap(this.getNode(), this.dynamicClassLoader);
            }
            catch (AccessControlException ace) {
                LOGGER.debug("adaptTo(ModifiableValueMap): Cannot set properties on {}", (Object)this);
            }
            catch (RepositoryException e) {
                LOGGER.debug("adaptTo(ModifiableValueMap): Unexpected problem for {}", (Object)this);
            }
        }
        return (Type)super.adaptTo(type);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ", type=" + this.getResourceType() + ", superType=" + this.getResourceSuperType() + ", path=" + this.getPath();
    }

    private Node getNode() {
        return this.node;
    }

    private InputStream getInputStream() {
        if (this.node != null) {
            try {
                Property data;
                Node content;
                Node node = content = this.node.isNodeType("nt:file") ? this.node.getNode("jcr:content") : this.node;
                if (content.hasProperty("jcr:data")) {
                    data = content.getProperty("jcr:data");
                } else {
                    try {
                        Item item = content.getPrimaryItem();
                        while (item.isNode()) {
                            item = ((Node)item).getPrimaryItem();
                        }
                        data = (Property)item;
                        this.setContentLength(data);
                    }
                    catch (ItemNotFoundException infe) {
                        LOGGER.debug("getInputStream: No primary items for {}", (Object)this.toString(), (Object)infe);
                        data = null;
                    }
                }
                if (data != null) {
                    return data.getBinary().getStream();
                }
            }
            catch (RepositoryException re) {
                LOGGER.error("getInputStream: Cannot get InputStream for " + (Object)((Object)this), (Throwable)re);
            }
        }
        return null;
    }

    private URL getURL() {
        try {
            return URLFactory.createURL(this.node.getSession(), this.node.getPath());
        }
        catch (Exception ex) {
            LOGGER.error("getURL: Cannot create URL for " + (Object)((Object)this), (Throwable)ex);
            return null;
        }
    }

    @Override
    Iterator<Resource> listJcrChildren() {
        try {
            if (this.getNode().hasNodes()) {
                return new JcrNodeResourceIterator(this.getResourceResolver(), this.getNode().getNodes(), this.dynamicClassLoader);
            }
        }
        catch (RepositoryException re) {
            LOGGER.error("listChildren: Cannot get children of " + (Object)((Object)this), (Throwable)re);
        }
        return Collections.emptyList().iterator();
    }

    private void setMetaData(Node node, ResourceMetadata metadata) {
        try {
            Property prop;
            if (node.isNodeType("nt:file")) {
                metadata.setCreationTime(node.getProperty("jcr:created").getLong());
                node = node.getNode("jcr:content");
            }
            if (node.hasProperty("jcr:mimeType")) {
                metadata.setContentType(node.getProperty("jcr:mimeType").getString());
            }
            if (node.hasProperty("jcr:encoding")) {
                metadata.setCharacterEncoding(node.getProperty("jcr:encoding").getString());
            }
            if (node.hasProperty("jcr:lastModified")) {
                prop = node.getProperty("jcr:lastModified");
                try {
                    metadata.setModificationTime(prop.getLong());
                }
                catch (ValueFormatException vfe) {
                    LOGGER.debug("Property {} cannot be converted to a long, ignored ({})", (Object)prop.getPath(), (Object)vfe);
                }
            }
            if (node.hasProperty("jcr:data")) {
                prop = node.getProperty("jcr:data");
                try {
                    metadata.setContentLength(prop.getLength());
                }
                catch (ValueFormatException vfe) {
                    LOGGER.debug("Length of Property {} cannot be retrieved, ignored ({})", (Object)prop.getPath(), (Object)vfe);
                }
            }
        }
        catch (RepositoryException re) {
            LOGGER.info("setMetaData: Problem extracting metadata information for " + this.getPath(), (Throwable)re);
        }
    }
}

