/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.jcr.resource.internal.helper.LazyInputStream;

public class JcrResourceUtil {
    public static QueryResult query(Session session, String query, String language) throws RepositoryException {
        QueryManager qManager = session.getWorkspace().getQueryManager();
        Query q = qManager.createQuery(query, language);
        return q.execute();
    }

    public static Object toJavaObject(Value value) throws RepositoryException {
        switch (value.getType()) {
            case 12: {
                return value.getDecimal();
            }
            case 2: {
                return new LazyInputStream(value);
            }
            case 6: {
                return value.getBoolean();
            }
            case 5: {
                return value.getDate();
            }
            case 4: {
                return value.getDouble();
            }
            case 3: {
                return value.getLong();
            }
        }
        return value.getString();
    }

    public static Object toJavaObject(Property property) throws RepositoryException {
        if (property.isMultiple()) {
            Object firstValue;
            Value[] values = property.getValues();
            Object object = firstValue = values.length > 0 ? JcrResourceUtil.toJavaObject(values[0]) : null;
            Object[] result = firstValue instanceof Boolean ? new Boolean[values.length] : (firstValue instanceof Calendar ? new Calendar[values.length] : (firstValue instanceof Double ? new Double[values.length] : (firstValue instanceof Long ? new Long[values.length] : (firstValue instanceof BigDecimal ? new BigDecimal[values.length] : (firstValue instanceof InputStream ? new Object[values.length] : new String[values.length])))));
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                if (value == null) continue;
                result[i] = JcrResourceUtil.toJavaObject(value);
            }
            return result;
        }
        return JcrResourceUtil.toJavaObject(property.getValue());
    }

    public static Value createValue(Object value, Session session) throws RepositoryException {
        ValueFactory fac = session.getValueFactory();
        Object val = value instanceof Calendar ? fac.createValue((Calendar)value) : (value instanceof InputStream ? fac.createValue(fac.createBinary((InputStream)value)) : (value instanceof Node ? fac.createValue((Node)value) : (value instanceof BigDecimal ? fac.createValue((BigDecimal)value) : (value instanceof Long ? fac.createValue(((Long)value).longValue()) : (value instanceof Short ? fac.createValue((long)((Short)value).shortValue()) : (value instanceof Integer ? fac.createValue((long)((Integer)value).intValue()) : (value instanceof Number ? fac.createValue(((Number)value).doubleValue()) : (value instanceof Boolean ? fac.createValue(((Boolean)value).booleanValue()) : (value instanceof String ? fac.createValue((String)value) : null)))))))));
        return val;
    }

    public static void setProperty(Node node, String propertyName, Object propertyValue) throws RepositoryException {
        if (propertyValue == null) {
            node.setProperty(propertyName, (String)null);
        } else if (propertyValue.getClass().isArray()) {
            Object[] values = (Object[])propertyValue;
            Value[] setValues = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                setValues[i] = JcrResourceUtil.createValue(values[i], node.getSession());
            }
            node.setProperty(propertyName, setValues);
        } else {
            node.setProperty(propertyName, JcrResourceUtil.createValue(propertyValue, node.getSession()));
        }
    }

    @Deprecated
    public static String resourceTypeToPath(String type) {
        return type.replaceAll("\\:", "/");
    }

    @Deprecated
    public static String getResourceSuperType(ResourceResolver resourceResolver, String resourceType) {
        return ResourceUtil.getResourceSuperType((ResourceResolver)resourceResolver, (String)resourceType);
    }

    @Deprecated
    public static String getResourceSuperType(Resource resource) {
        String resourceSuperType = resource.getResourceSuperType();
        if (resourceSuperType == null) {
            ResourceResolver resolver = resource.getResourceResolver();
            String resourceType = resource.getResourceType();
            resourceSuperType = ResourceUtil.getResourceSuperType((ResourceResolver)resolver, (String)resourceType);
        }
        return resourceSuperType;
    }

    public static Node createPath(String path, String intermediateNodeType, String nodeType, Session session, boolean autoSave) throws RepositoryException {
        if (path == null || path.length() == 0 || "/".equals(path)) {
            return session.getRootNode();
        }
        if (!session.itemExists(path)) {
            return JcrResourceUtil.createPath(session.getRootNode(), path.substring(1), intermediateNodeType, nodeType, autoSave);
        }
        return (Node)session.getItem(path);
    }

    public static Node createPath(Node parentNode, String relativePath, String intermediateNodeType, String nodeType, boolean autoSave) throws RepositoryException {
        if (relativePath == null || relativePath.length() == 0 || "/".equals(relativePath)) {
            return parentNode;
        }
        if (!parentNode.hasNode(relativePath)) {
            Node node = parentNode;
            int pos = relativePath.lastIndexOf(47);
            if (pos != -1) {
                StringTokenizer st = new StringTokenizer(relativePath.substring(0, pos), "/");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!node.hasNode(token)) {
                        try {
                            if (intermediateNodeType != null) {
                                node.addNode(token, intermediateNodeType);
                            } else {
                                node.addNode(token);
                            }
                            if (autoSave) {
                                node.getSession().save();
                            }
                        }
                        catch (RepositoryException re) {
                            node.refresh(false);
                        }
                    }
                    node = node.getNode(token);
                }
                relativePath = relativePath.substring(pos + 1);
            }
            if (!node.hasNode(relativePath)) {
                if (nodeType != null) {
                    node.addNode(relativePath, nodeType);
                } else {
                    node.addNode(relativePath);
                }
                if (autoSave) {
                    node.getSession().save();
                }
            }
            return node.getNode(relativePath);
        }
        return parentNode.getNode(relativePath);
    }
}

