/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JcrItemResource
extends AbstractResource
implements Resource {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrItemResource.class);
    private final ResourceResolver resourceResolver;
    private final String path;
    private final ResourceMetadata metadata;

    protected JcrItemResource(ResourceResolver resourceResolver, String path) {
        this.resourceResolver = resourceResolver;
        this.path = path;
        this.metadata = new ResourceMetadata();
        this.metadata.setResolutionPath(path);
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public String getPath() {
        return this.path;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    protected String getResourceTypeForNode(Node node) throws RepositoryException {
        String result = null;
        if (node.hasProperty("sling:resourceType")) {
            result = node.getProperty("sling:resourceType").getValue().getString();
        }
        if (result == null || result.length() == 0) {
            result = node.getPrimaryNodeType().getName();
        }
        return result;
    }

    protected void setContentLength(Property property) throws RepositoryException {
        if (property.isMultiple()) {
            return;
        }
        try {
            long length = property.getType() == 2 ? property.getLength() : (long)property.getString().getBytes("UTF-8").length;
            this.getResourceMetadata().setContentLength(length);
        }
        catch (UnsupportedEncodingException uee) {
            LOGGER.warn("getPropertyContentLength: Cannot determine length of non-binary property {}: {}", (Object)((Object)((Object)this)).toString(), (Object)uee);
        }
    }

    abstract Iterator<Resource> listJcrChildren();
}

