/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.net;

import java.net.MalformedURLException;
import java.net.URL;
import javax.jcr.Session;
import org.apache.jackrabbit.net.FileParts;
import org.apache.jackrabbit.net.JCRJarURLHandler;
import org.apache.jackrabbit.net.JCRURLHandler;

public final class URLFactory {
    public static final String REPOSITORY_SCHEME = "jcr";
    public static final String REPOSITORY_JAR_SCHEME = "jar";

    private URLFactory() {
    }

    public static URL createURL(Session session, String path) throws MalformedURLException {
        return new URL(REPOSITORY_SCHEME, "", -1, new FileParts(session, path, null).toString(), new JCRURLHandler(session));
    }

    public static URL createJarURL(Session session, String path, String entry) throws MalformedURLException {
        JCRJarURLHandler handler = new JCRJarURLHandler(session);
        String file = URLFactory.createURL(session, path).toExternalForm();
        if (entry != null) {
            file = file + "!/" + entry;
        }
        return new URL(REPOSITORY_JAR_SCHEME, "", -1, file, handler);
    }
}

