/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrItemAdapterFactory;
import org.osgi.service.component.ComponentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="org.apache.sling.jcr.resource.internal.LegacyJcrResourceResolverFactoryImpl")
@Service(value={JcrResourceResolverFactory.class})
@Properties(value={@Property(name="service.description", value={"Apache Sling JcrResourceResolverFactory Implementation"}), @Property(name="service.vendor", value={"The Apache Software Foundation"})})
public class JcrResourceResolverFactoryImpl
implements JcrResourceResolverFactory {
    @Reference
    private ResourceResolverFactory delegatee;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private DynamicClassLoaderManager dynamicClassLoaderManager;
    private JcrItemAdapterFactory jcrItemAdapterFactory;

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.jcrItemAdapterFactory = new JcrItemAdapterFactory(componentContext.getBundleContext(), this);
    }

    protected void deactivate(ComponentContext componentContext) {
        if (this.jcrItemAdapterFactory != null) {
            this.jcrItemAdapterFactory.dispose();
            this.jcrItemAdapterFactory = null;
        }
    }

    public ClassLoader getDynamicClassLoader() {
        DynamicClassLoaderManager dclm = this.dynamicClassLoaderManager;
        if (dclm != null) {
            return dclm.getDynamicClassLoader();
        }
        return null;
    }

    @Override
    public ResourceResolver getResourceResolver(Session session) {
        HashMap<String, Object> authInfo = new HashMap<String, Object>(1);
        authInfo.put("user.jcr.session", session);
        try {
            return this.getResourceResolver(authInfo);
        }
        catch (LoginException le) {
            throw new InternalError("Unexpected LoginException");
        }
    }

    public ResourceResolver getServiceResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return this.delegatee.getServiceResourceResolver(authenticationInfo);
    }

    public ResourceResolver getAdministrativeResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return this.delegatee.getAdministrativeResourceResolver(authenticationInfo);
    }

    public ResourceResolver getResourceResolver(Map<String, Object> arg0) throws LoginException {
        return this.delegatee.getResourceResolver(arg0);
    }

    protected void bindDelegatee(ResourceResolverFactory resourceResolverFactory) {
        this.delegatee = resourceResolverFactory;
    }

    protected void unbindDelegatee(ResourceResolverFactory resourceResolverFactory) {
        if (this.delegatee == resourceResolverFactory) {
            this.delegatee = null;
        }
    }

    protected void bindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.dynamicClassLoaderManager = dynamicClassLoaderManager;
    }

    protected void unbindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        if (this.dynamicClassLoaderManager == dynamicClassLoaderManager) {
            this.dynamicClassLoaderManager = null;
        }
    }
}

