/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.util.Collections;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceProviderFactory;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.JcrResourceListener;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProvider;
import org.apache.sling.jcr.resource.internal.helper.jcr.RepositoryHolder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service(value={ResourceProviderFactory.class})
@Properties(value={@Property(name="required", boolValue={true}), @Property(name="provider.roots", value={"/"}), @Property(name="service.description", value={"Apache Sling JCR Resource Provider Factory"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="provider.query.languages", value={"xpath", "sql", "JCR-SQL2"})})
public class JcrResourceProviderFactory
implements ResourceProviderFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String REPOSITORY_REFERNENCE_NAME = "repository";
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private DynamicClassLoaderManager dynamicClassLoaderManager;
    @Reference(name="repository", referenceInterface=SlingRepository.class)
    private ServiceReference repositoryReference;
    private SlingRepository repository;
    private JcrResourceListener listener;

    @Activate
    protected void activate(ComponentContext context) throws RepositoryException {
        SlingRepository repository = (SlingRepository)context.locateService(REPOSITORY_REFERNENCE_NAME, this.repositoryReference);
        if (repository == null) {
            this.log.warn("activate: Activation failed because SlingRepository may have been unregistered concurrently");
            return;
        }
        String root = PropertiesUtil.toString(context.getProperties().get("provider.roots"), (String)"/");
        this.repository = repository;
        this.listener = new JcrResourceListener(root, null, this.repository, context.getBundleContext());
    }

    @Deactivate
    protected void deactivate() {
        if (this.listener != null) {
            this.listener.deactivate();
            this.listener = null;
        }
    }

    ClassLoader getDynamicClassLoader() {
        DynamicClassLoaderManager dclm = this.dynamicClassLoaderManager;
        if (dclm != null) {
            return dclm.getDynamicClassLoader();
        }
        return null;
    }

    private void bindRepository(ServiceReference ref) {
        this.repositoryReference = ref;
        this.repository = null;
    }

    private void unbindRepository(ServiceReference ref) {
        if (this.repositoryReference == ref) {
            this.repositoryReference = null;
            this.repository = null;
        }
    }

    public ResourceProvider getResourceProvider(Map<String, Object> authenticationInfo) throws org.apache.sling.api.resource.LoginException {
        return this.getResourceProviderInternal(authenticationInfo, false);
    }

    public ResourceProvider getAdministrativeResourceProvider(Map<String, Object> authenticationInfo) throws org.apache.sling.api.resource.LoginException {
        return this.getResourceProviderInternal(authenticationInfo, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceProvider getResourceProviderInternal(Map<String, Object> authenticationInfo, boolean isAdmin) throws org.apache.sling.api.resource.LoginException {
        Session session;
        RepositoryHolder holder;
        boolean logoutSession;
        block19: {
            if (authenticationInfo == null) {
                authenticationInfo = Collections.emptyMap();
            }
            logoutSession = true;
            holder = new RepositoryHolder();
            try {
                String workspace = this.getWorkspace(authenticationInfo);
                if (isAdmin) {
                    session = this.repository.loginAdministrative(workspace);
                    break block19;
                }
                session = this.getSession(authenticationInfo);
                if (session == null) {
                    Object serviceBundleObject = authenticationInfo.get("sling.service.bundle");
                    if (serviceBundleObject instanceof Bundle) {
                        String subServiceName = authenticationInfo.get("sling.service.subservice") instanceof String ? (String)authenticationInfo.get("sling.service.subservice") : null;
                        BundleContext bc = ((Bundle)serviceBundleObject).getBundleContext();
                        SlingRepository repo = (SlingRepository)bc.getService(this.repositoryReference);
                        if (repo == null) {
                            this.log.warn("getResourceProviderInternal: Cannot login service because cannot get SlingRepository on behalf of bundle {} ({})", (Object)bc.getBundle().getSymbolicName(), (Object)bc.getBundle().getBundleId());
                            throw new org.apache.sling.api.resource.LoginException();
                        }
                        try {
                            session = repo.loginService(subServiceName, workspace);
                            holder.setRepositoryReference(bc, this.repositoryReference);
                            holder.setSession(session);
                            break block19;
                        }
                        finally {
                            if (session == null) {
                                bc.ungetService(this.repositoryReference);
                            }
                        }
                    }
                    Credentials credentials = this.getCredentials(authenticationInfo);
                    session = this.repository.login(credentials, workspace);
                    break block19;
                }
                if (workspace != null) {
                    Session tmpSession = null;
                    try {
                        tmpSession = this.repository.loginAdministrative(workspace);
                        if (tmpSession.getUserID().equals(session.getUserID())) {
                            session = tmpSession;
                            tmpSession = null;
                        } else {
                            session = tmpSession.impersonate((Credentials)new SimpleCredentials(session.getUserID(), new char[0]));
                        }
                        break block19;
                    }
                    finally {
                        if (tmpSession != null) {
                            tmpSession.logout();
                        }
                    }
                }
                logoutSession = false;
            }
            catch (RepositoryException re) {
                throw this.getLoginException(re);
            }
        }
        session = this.handleImpersonation(session, authenticationInfo, logoutSession);
        if (logoutSession) {
            holder.setSession(session);
        }
        return new JcrResourceProvider(session, this.getDynamicClassLoader(), holder);
    }

    private Session handleImpersonation(Session session, Map<String, Object> authenticationInfo, boolean logoutSession) throws org.apache.sling.api.resource.LoginException {
        String sudoUser = this.getSudoUser(authenticationInfo);
        if (sudoUser != null && !session.getUserID().equals(sudoUser)) {
            try {
                SimpleCredentials creds = new SimpleCredentials(sudoUser, new char[0]);
                this.copyAttributes(creds, authenticationInfo);
                creds.setAttribute("user.impersonator", (Object)session.getUserID());
                Session session2 = session.impersonate((Credentials)creds);
                return session2;
            }
            catch (RepositoryException re) {
                throw this.getLoginException(re);
            }
            finally {
                if (logoutSession) {
                    session.logout();
                }
            }
        }
        return session;
    }

    private org.apache.sling.api.resource.LoginException getLoginException(RepositoryException re) {
        if (re instanceof LoginException) {
            return new org.apache.sling.api.resource.LoginException(re.getMessage(), re.getCause());
        }
        return new org.apache.sling.api.resource.LoginException("Unable to login " + re.getMessage(), (Throwable)re);
    }

    private Credentials getCredentials(Map<String, Object> authenticationInfo) {
        if (authenticationInfo == null) {
            return null;
        }
        Object credentialsObject = authenticationInfo.get("user.jcr.credentials");
        if (credentialsObject instanceof Credentials) {
            return (Credentials)credentialsObject;
        }
        Object userId = authenticationInfo.get("user.name");
        if (userId instanceof String) {
            Object password = authenticationInfo.get("user.password");
            SimpleCredentials credentials = new SimpleCredentials((String)userId, password instanceof char[] ? (char[])password : new char[]{});
            this.copyAttributes(credentials, authenticationInfo);
            return credentials;
        }
        return null;
    }

    private void copyAttributes(SimpleCredentials target, Map<String, Object> source) {
        for (Map.Entry<String, Object> current : source.entrySet()) {
            if (!JcrResourceProviderFactory.isAttributeVisible(current.getKey())) continue;
            target.setAttribute(current.getKey(), current.getValue());
        }
    }

    public static boolean isAttributeVisible(String name) {
        return !name.equals("user.jcr.credentials") && !name.contains("password");
    }

    private String getSudoUser(Map<String, Object> authenticationInfo) {
        Object sudoObject = authenticationInfo.get("user.impersonation");
        if (sudoObject instanceof String) {
            return (String)sudoObject;
        }
        return null;
    }

    private String getWorkspace(Map<String, Object> authenticationInfo) {
        Object workspaceObject = authenticationInfo.get("user.jcr.workspace");
        if (workspaceObject instanceof String) {
            return (String)workspaceObject;
        }
        return null;
    }

    private Session getSession(Map<String, Object> authenticationInfo) {
        Object sessionObject = authenticationInfo.get("user.jcr.session");
        if (sessionObject instanceof Session) {
            return (Session)sessionObject;
        }
        return null;
    }

    protected void bindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.dynamicClassLoaderManager = dynamicClassLoaderManager;
    }

    protected void unbindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        if (this.dynamicClassLoaderManager == dynamicClassLoaderManager) {
            this.dynamicClassLoaderManager = null;
        }
    }
}

