/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.scripting;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.script.Bindings;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.scripting.api.BindingsValuesProvider;

@Component
@Service
@Properties(value={@Property(name="service.description", value={"Apache Sling CurrentNode BindingsValuesProvider"}), @Property(name="service.vendor", value={"The Apache Software Foundation"})})
public class JcrObjectsBindingsValuesProvider
implements BindingsValuesProvider {
    private static final String PROP_CURRENT_NODE = "currentNode";
    private static final String PROP_CURRENT_SESSION = "currentSession";

    public void addBindings(Bindings bindings) {
        Resource resource = (Resource)bindings.get("resource");
        if (resource != null) {
            Session session;
            Node node = (Node)resource.adaptTo(Node.class);
            if (node != null) {
                bindings.put(PROP_CURRENT_NODE, (Object)node);
            }
            if (bindings.get(PROP_CURRENT_SESSION) == null && (session = (Session)resource.getResourceResolver().adaptTo(Session.class)) != null) {
                bindings.put(PROP_CURRENT_SESSION, (Object)session);
            }
        }
    }
}

