/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.internal.HelperData;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrNodeResourceIterator
implements Iterator<Resource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrNodeResourceIterator.class);
    private final ResourceResolver resourceResolver;
    private final NodeIterator nodes;
    private Resource nextResult;
    private final HelperData helper;
    private final String parentPath;
    private final String parentVersion;

    public JcrNodeResourceIterator(ResourceResolver resourceResolver, NodeIterator nodes, HelperData helper) {
        this(resourceResolver, null, null, nodes, helper);
    }

    public JcrNodeResourceIterator(ResourceResolver resourceResolver, String parentPath, String parentVersion, NodeIterator nodes, HelperData helper) {
        this.resourceResolver = resourceResolver;
        this.parentPath = parentPath;
        this.parentVersion = parentVersion;
        this.nodes = nodes;
        this.helper = helper;
        this.nextResult = this.seek();
    }

    @Override
    public boolean hasNext() {
        return this.nextResult != null;
    }

    @Override
    public Resource next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Resource result = this.nextResult;
        this.nextResult = this.seek();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Resource seek() {
        while (this.nodes.hasNext()) {
            try {
                Node n = this.nodes.nextNode();
                String path = this.getPath(n);
                if (path == null) continue;
                JcrNodeResource resource = new JcrNodeResource(this.resourceResolver, path, this.parentVersion, n, this.helper);
                LOGGER.debug("seek: Returning Resource {}", (Object)resource);
                return resource;
            }
            catch (Throwable t) {
                LOGGER.error("seek: Problem creating Resource for next node, skipping", t);
            }
        }
        LOGGER.debug("seek: No more nodes, iterator exhausted");
        return null;
    }

    private String getPath(Node node) throws RepositoryException {
        String path = this.parentPath == null ? node.getPath() : String.format("%s/%s", "/".equals(this.parentPath) ? "" : this.parentPath, node.getName());
        return this.helper.pathMapper.mapJCRPathToResourcePath(path);
    }
}

