/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.serviceusermapping.ServiceUserValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={ServiceUserValidator.class})
public class JcrSystemUserValidator
implements ServiceUserValidator {
    private final Logger log = LoggerFactory.getLogger(JcrSystemUserValidator.class);
    @Reference
    private volatile SlingRepository repository;
    private final Method isSystemUserMethod;
    private final Set<String> validIds = new CopyOnWriteArraySet<String>();

    public JcrSystemUserValidator() {
        Method m = null;
        try {
            m = User.class.getMethod("isSystemUser", new Class[0]);
        }
        catch (Exception e) {
            this.log.debug("Exception while accessing isSystemUser method", (Throwable)e);
        }
        this.isSystemUserMethod = m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid(String serviceUserId, String serviceName, String subServiceName) {
        block7: {
            boolean bl;
            if (serviceUserId == null) {
                this.log.debug("the provided service user id is null");
                return false;
            }
            if (this.validIds.contains(serviceUserId)) {
                this.log.debug("the provided service user id {} has been already validated", (Object)serviceUserId);
                return true;
            }
            Session administrativeSession = null;
            try {
                UserManager userManager;
                Authorizable authorizable;
                administrativeSession = this.repository.loginAdministrative(null);
                if (!(administrativeSession instanceof JackrabbitSession) || (authorizable = (userManager = ((JackrabbitSession)administrativeSession).getUserManager()).getAuthorizable(serviceUserId)) == null || authorizable.isGroup() || !this.isSystemUser((User)authorizable)) break block7;
                this.validIds.add(serviceUserId);
                bl = true;
                if (administrativeSession == null) return bl;
            }
            catch (RepositoryException e) {
                this.log.debug(e.getMessage());
                return false;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            administrativeSession.logout();
            return bl;
        }
        return false;
    }

    private boolean isSystemUser(User user) {
        if (this.isSystemUserMethod != null) {
            try {
                return (Boolean)this.isSystemUserMethod.invoke((Object)user, new Object[0]);
            }
            catch (Exception e) {
                this.log.debug("Exception while invoking isSystemUser method", (Throwable)e);
                return true;
            }
        }
        return true;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

