/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.plugins.observation.NodeObserver;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserver;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.internal.ObservationListenerSupport;
import org.apache.sling.jcr.resource.internal.helper.jcr.PathMapper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OakResourceListener
extends NodeObserver
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String mountPrefix;
    private final ServiceRegistration serviceRegistration;
    final ObservationListenerSupport support;
    private final PathMapper pathMapper;

    public OakResourceListener(String mountPrefix, ObservationListenerSupport support, BundleContext bundleContext, Executor executor, PathMapper pathMapper, final int observationQueueLength) throws RepositoryException {
        super("/", new String[]{"jcr:primaryType", "sling:resourceType", "sling:resourceSuperType"});
        this.support = support;
        this.pathMapper = pathMapper;
        this.mountPrefix = mountPrefix == null || mountPrefix.length() == 0 || mountPrefix.equals("/") ? null : mountPrefix;
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("service.description", "Apache Sling JCR Observation Listener for Oak");
        BackgroundObserver observer = new BackgroundObserver((Observer)this, executor, observationQueueLength){

            protected void added(int queueSize) {
                if (queueSize == observationQueueLength) {
                    OakResourceListener.this.logger.warn("Revision queue for observer {} is full (max = {}). Further revisions will be compacted.", (Object)((Object)((Object)this)).getClass().getName(), (Object)observationQueueLength);
                }
            }
        };
        this.serviceRegistration = bundleContext.registerService(Observer.class.getName(), (Object)observer, props);
    }

    @Override
    public void close() throws IOException {
        this.serviceRegistration.unregister();
        this.support.dispose();
    }

    protected void added(String path, Set<String> added, Set<String> deleted, Set<String> changed, Map<String, String> properties, CommitInfo commitInfo) {
        Map<String, Object> changes = OakResourceListener.toEventProperties(added, deleted, changed);
        OakResourceListener.addCommitInfo(changes, commitInfo);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("added(path={}, added={}, deleted={}, changed={})", new Object[]{path, added, deleted, changed});
        }
        this.sendOsgiEvent(path, "org/apache/sling/api/resource/Resource/ADDED", changes, properties);
    }

    protected void deleted(String path, Set<String> added, Set<String> deleted, Set<String> changed, Map<String, String> properties, CommitInfo commitInfo) {
        Map<String, Object> changes = OakResourceListener.toEventProperties(added, deleted, changed);
        OakResourceListener.addCommitInfo(changes, commitInfo);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("deleted(path={}, added={}, deleted={}, changed={})", new Object[]{path, added, deleted, changed});
        }
        this.sendOsgiEvent(path, "org/apache/sling/api/resource/Resource/REMOVED", changes, properties);
    }

    protected void changed(String path, Set<String> added, Set<String> deleted, Set<String> changed, Map<String, String> properties, CommitInfo commitInfo) {
        Map<String, Object> changes = OakResourceListener.toEventProperties(added, deleted, changed);
        OakResourceListener.addCommitInfo(changes, commitInfo);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("changed(path={}, added={}, deleted={}, changed={})", new Object[]{path, added, deleted, changed});
        }
        this.sendOsgiEvent(path, "org/apache/sling/api/resource/Resource/CHANGED", changes, properties);
    }

    private static void addCommitInfo(Map<String, Object> changes, CommitInfo commitInfo) {
        if (commitInfo.getUserId() != null) {
            changes.put("userid", commitInfo.getUserId());
        }
        if (commitInfo == CommitInfo.EMPTY) {
            changes.put("event.application", "unknown");
        }
    }

    private static Map<String, Object> toEventProperties(Set<String> added, Set<String> deleted, Set<String> changed) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (added != null && added.size() > 0) {
            properties.put("resourceAddedAttributes", added.toArray(new String[added.size()]));
        }
        if (changed != null && changed.size() > 0) {
            properties.put("resourceChangedAttributes", changed.toArray(new String[changed.size()]));
        }
        if (deleted != null && deleted.size() > 0) {
            properties.put("resourceRemovedAttributes", deleted.toArray(new String[deleted.size()]));
        }
        return properties;
    }

    private void sendOsgiEvent(String path, String topic, Map<String, Object> changes, Map<String, String> properties) {
        block21: {
            String changePath = this.mountPrefix == null ? path : this.mountPrefix + path;
            changes.put("path", changePath);
            try {
                EventAdmin localEa = this.support.getEventAdmin();
                if (localEa == null) break block21;
                boolean sendEvent = true;
                if (!"org/apache/sling/api/resource/Resource/REMOVED".equals(topic)) {
                    String resourceType = properties.get("sling:resourceType");
                    String resourceSuperType = properties.get("sling:resourceSuperType");
                    String nodeType = properties.get("jcr:primaryType");
                    if (path.endsWith("/jcr:content")) {
                        ResourceResolver resolver = this.support.getResourceResolver();
                        if (resolver == null) {
                            sendEvent = false;
                            this.logger.debug("resource resolver is null");
                        } else {
                            Resource rsrc = resolver.getResource(changePath);
                            if (rsrc == null) {
                                resolver.refresh();
                                sendEvent = false;
                                this.logger.debug("not able to get resource for changes path {}", (Object)changePath);
                            } else {
                                Node node = (Node)rsrc.adaptTo(Node.class);
                                if (node != null) {
                                    try {
                                        Resource parentResource;
                                        if (node.getParent().isNodeType("nt:file") && (parentResource = rsrc.getParent()) != null) {
                                            resourceType = parentResource.getResourceType();
                                            resourceSuperType = parentResource.getResourceSuperType();
                                            changes.put("path", parentResource.getPath());
                                        }
                                    }
                                    catch (RepositoryException re) {
                                        this.logger.error(re.getMessage(), (Throwable)re);
                                    }
                                } else {
                                    sendEvent = false;
                                    this.logger.debug("not able to adapt resource {} to node", (Object)changePath);
                                }
                            }
                        }
                        if (!sendEvent) {
                            this.logger.debug("processOsgiEventQueue: Resource at {} not found, which is not expected for an added or modified node", (Object)changePath);
                        }
                    }
                    if (sendEvent) {
                        if (resourceType == null) {
                            changes.put("resourceType", nodeType);
                        } else {
                            changes.put("resourceType", resourceType);
                        }
                        if (resourceSuperType != null) {
                            changes.put("resourceSuperType", resourceSuperType);
                        }
                    }
                }
                if (sendEvent) {
                    String resourcePath = this.pathMapper.mapJCRPathToResourcePath(changes.get("path").toString());
                    if (resourcePath != null) {
                        changes.put("path", resourcePath);
                        localEa.sendEvent(new Event(topic, (Map)new EventProperties(changes)));
                    } else {
                        this.logger.debug("Dropping observation event for {}", changes.get("path"));
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("sendOsgiEvent: Unexpected problem processing event " + topic + " at " + path + " with " + changes, (Throwable)e);
            }
        }
    }
}

