/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.HashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservationListenerSupport {
    private final Logger logger = LoggerFactory.getLogger(ObservationListenerSupport.class);
    private final ServiceTracker eventAdminTracker;
    private volatile ServiceTracker resourceResolverFactoryTracker;
    private volatile int resourceResolverFactoryChangeCount = -1;
    private volatile ResourceResolver resourceResolver;
    private final BundleContext bundleContext;
    private final Session session;

    public ObservationListenerSupport(BundleContext bundleContext, SlingRepository repository) throws RepositoryException {
        this.bundleContext = bundleContext;
        this.eventAdminTracker = new ServiceTracker(bundleContext, EventAdmin.class.getName(), null);
        this.eventAdminTracker.open();
        this.session = repository.loginAdministrative(null);
    }

    public void dispose() {
        if (this.resourceResolver != null) {
            this.resourceResolver.close();
            this.resourceResolver = null;
        }
        if (this.resourceResolverFactoryTracker != null) {
            this.resourceResolverFactoryTracker.close();
            this.resourceResolverFactoryTracker = null;
        }
        this.eventAdminTracker.close();
        this.session.logout();
    }

    public Session getSession() {
        return this.session;
    }

    public EventAdmin getEventAdmin() {
        return (EventAdmin)this.eventAdminTracker.getService();
    }

    public ResourceResolver getResourceResolver() {
        if (this.resourceResolver == null || this.resourceResolverFactoryTracker != null && this.resourceResolverFactoryChangeCount < this.resourceResolverFactoryTracker.getTrackingCount()) {
            ResourceResolverFactory factory;
            if (this.resourceResolver != null) {
                this.resourceResolver.close();
                this.resourceResolver = null;
            }
            if (this.resourceResolverFactoryTracker == null) {
                this.resourceResolverFactoryTracker = new ServiceTracker(this.bundleContext, ResourceResolverFactory.class.getName(), null);
                this.resourceResolverFactoryTracker.open();
            }
            if ((factory = (ResourceResolverFactory)this.resourceResolverFactoryTracker.getService()) != null) {
                HashMap<String, Session> authInfo = new HashMap<String, Session>();
                authInfo.put("user.jcr.session", this.session);
                try {
                    this.resourceResolver = factory.getResourceResolver(authInfo);
                    this.resourceResolverFactoryChangeCount = this.resourceResolverFactoryTracker.getTrackingCount();
                }
                catch (LoginException le) {
                    this.logger.error("Unable to get administrative resource resolver.", (Throwable)le);
                }
            }
        }
        if (this.resourceResolver != null) {
            this.resourceResolver.refresh();
        }
        return this.resourceResolver;
    }
}

