/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.HelperData;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrProviderState;
import org.apache.sling.jcr.resource.internal.helper.jcr.PathMapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrProviderStateFactory {
    private final Logger logger = LoggerFactory.getLogger(JcrProviderStateFactory.class);
    private final ServiceReference repositoryReference;
    private final SlingRepository repository;
    private final AtomicReference<DynamicClassLoaderManager> dynamicClassLoaderManagerReference;
    private final PathMapper pathMapper;

    public JcrProviderStateFactory(ServiceReference repositoryReference, SlingRepository repository, AtomicReference<DynamicClassLoaderManager> dynamicClassLoaderManagerReference, PathMapper pathMapper) {
        this.repository = repository;
        this.repositoryReference = repositoryReference;
        this.dynamicClassLoaderManagerReference = dynamicClassLoaderManagerReference;
        this.pathMapper = pathMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JcrProviderState createProviderState(@Nonnull Map<String, Object> authenticationInfo) throws org.apache.sling.api.resource.LoginException {
        Session session;
        BundleContext bc;
        boolean logoutSession;
        block18: {
            logoutSession = true;
            bc = null;
            try {
                String workspace = JcrProviderStateFactory.getWorkspace(authenticationInfo);
                if (Boolean.TRUE.equals(authenticationInfo.get("provider.auth.admin"))) {
                    session = this.repository.loginAdministrative(workspace);
                    break block18;
                }
                session = JcrProviderStateFactory.getSession(authenticationInfo);
                if (session == null) {
                    Object serviceBundleObject = authenticationInfo.get("sling.service.bundle");
                    if (serviceBundleObject instanceof Bundle) {
                        String subServiceName = authenticationInfo.get("sling.service.subservice") instanceof String ? (String)authenticationInfo.get("sling.service.subservice") : null;
                        bc = ((Bundle)serviceBundleObject).getBundleContext();
                        SlingRepository repo = (SlingRepository)bc.getService(this.repositoryReference);
                        if (repo == null) {
                            this.logger.warn("getResourceProviderInternal: Cannot login service because cannot get SlingRepository on behalf of bundle {} ({})", (Object)bc.getBundle().getSymbolicName(), (Object)bc.getBundle().getBundleId());
                            throw new org.apache.sling.api.resource.LoginException();
                        }
                        try {
                            session = repo.loginService(subServiceName, workspace);
                            break block18;
                        }
                        finally {
                            if (session == null) {
                                bc.ungetService(this.repositoryReference);
                            }
                        }
                    }
                    Credentials credentials = JcrProviderStateFactory.getCredentials(authenticationInfo);
                    session = this.repository.login(credentials, workspace);
                    break block18;
                }
                if (workspace != null) {
                    Session tmpSession = null;
                    try {
                        tmpSession = this.repository.loginAdministrative(workspace);
                        if (tmpSession.getUserID().equals(session.getUserID())) {
                            session = tmpSession;
                            tmpSession = null;
                        } else {
                            session = tmpSession.impersonate((Credentials)new SimpleCredentials(session.getUserID(), new char[0]));
                        }
                        break block18;
                    }
                    finally {
                        if (tmpSession != null) {
                            tmpSession.logout();
                        }
                    }
                }
                logoutSession = false;
            }
            catch (RepositoryException re) {
                throw JcrProviderStateFactory.getLoginException(re);
            }
        }
        session = JcrProviderStateFactory.handleImpersonation(session, authenticationInfo, logoutSession);
        HelperData data = new HelperData(this.dynamicClassLoaderManagerReference, this.pathMapper);
        if (bc == null) {
            return new JcrProviderState(session, data, logoutSession);
        }
        return new JcrProviderState(session, data, logoutSession, bc, this.repositoryReference);
    }

    private static Session handleImpersonation(Session session, Map<String, Object> authenticationInfo, boolean logoutSession) throws org.apache.sling.api.resource.LoginException {
        String sudoUser = JcrProviderStateFactory.getSudoUser(authenticationInfo);
        if (sudoUser != null && !session.getUserID().equals(sudoUser)) {
            try {
                SimpleCredentials creds = new SimpleCredentials(sudoUser, new char[0]);
                JcrProviderStateFactory.copyAttributes(creds, authenticationInfo);
                creds.setAttribute("user.impersonator", (Object)session.getUserID());
                Session session2 = session.impersonate((Credentials)creds);
                return session2;
            }
            catch (RepositoryException re) {
                throw JcrProviderStateFactory.getLoginException(re);
            }
            finally {
                if (logoutSession) {
                    session.logout();
                }
            }
        }
        return session;
    }

    private static org.apache.sling.api.resource.LoginException getLoginException(RepositoryException re) {
        if (re instanceof LoginException) {
            return new org.apache.sling.api.resource.LoginException(re.getMessage(), re.getCause());
        }
        return new org.apache.sling.api.resource.LoginException("Unable to login " + re.getMessage(), (Throwable)re);
    }

    private static Credentials getCredentials(Map<String, Object> authenticationInfo) {
        Credentials creds = null;
        if (authenticationInfo != null) {
            Object credentialsObject = authenticationInfo.get("user.jcr.credentials");
            if (credentialsObject instanceof Credentials) {
                creds = (Credentials)credentialsObject;
            } else {
                Object userId = authenticationInfo.get("user.name");
                if (userId instanceof String) {
                    Object password = authenticationInfo.get("user.password");
                    SimpleCredentials credentials = new SimpleCredentials((String)userId, password instanceof char[] ? (char[])password : new char[]{});
                    JcrProviderStateFactory.copyAttributes(credentials, authenticationInfo);
                    creds = credentials;
                }
            }
        }
        if (creds instanceof SimpleCredentials && authenticationInfo.get("user.newpassword") instanceof String) {
            ((SimpleCredentials)creds).setAttribute("user.newpassword", authenticationInfo.get("user.newpassword"));
        }
        return creds;
    }

    private static void copyAttributes(SimpleCredentials target, Map<String, Object> source) {
        for (Map.Entry<String, Object> current : source.entrySet()) {
            if (!JcrProviderStateFactory.isAttributeVisible(current.getKey())) continue;
            target.setAttribute(current.getKey(), current.getValue());
        }
    }

    private static boolean isAttributeVisible(String name) {
        return !name.equals("user.jcr.credentials") && !name.contains("password");
    }

    private static String getSudoUser(Map<String, Object> authenticationInfo) {
        Object sudoObject = authenticationInfo.get("user.impersonation");
        if (sudoObject instanceof String) {
            return (String)sudoObject;
        }
        return null;
    }

    private static String getWorkspace(Map<String, Object> authenticationInfo) {
        Object workspaceObject = authenticationInfo.get("user.jcr.workspace");
        if (workspaceObject instanceof String) {
            return (String)workspaceObject;
        }
        return null;
    }

    private static Session getSession(Map<String, Object> authenticationInfo) {
        Object sessionObject = authenticationInfo.get("user.jcr.session");
        if (sessionObject instanceof Session) {
            return (Session)sessionObject;
        }
        return null;
    }
}

