/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.io.Closeable;
import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.JcrModifiableValueMap;
import org.apache.sling.jcr.resource.internal.JcrResourceListener;
import org.apache.sling.jcr.resource.internal.OakResourceListener;
import org.apache.sling.jcr.resource.internal.helper.jcr.BasicQueryLanguageProvider;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrItemResource;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResource;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrProviderState;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrProviderStateFactory;
import org.apache.sling.jcr.resource.internal.helper.jcr.PathMapper;
import org.apache.sling.spi.resource.provider.ProviderContext;
import org.apache.sling.spi.resource.provider.QueryLanguageProvider;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, label="Apache Sling JCR Resource Provider Factory", description="This provider adds  JCR resources to the resource tree")
@Service(value={ResourceProvider.class})
@Properties(value={@Property(name="provider.name", value={"JCR"}), @Property(name="provider.root", value={"/"}), @Property(name="provider.modifiable", boolValue={true}), @Property(name="provider.adaptable", boolValue={true}), @Property(name="provider.authenticate", value={"required"}), @Property(name="provider.attributable", boolValue={true}), @Property(name="provider.refreshable", boolValue={true})})
@Reference(name="dynamicClassLoaderManager", referenceInterface=DynamicClassLoaderManager.class, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
public class JcrResourceProvider
extends ResourceProvider<JcrProviderState> {
    private final Logger logger = LoggerFactory.getLogger(JcrResourceProvider.class);
    private static final String REPOSITORY_REFERNENCE_NAME = "repository";
    private static final Set<String> IGNORED_PROPERTIES = new HashSet<String>();
    private static final boolean DEFAULT_OPTIMIZE_FOR_OAK = true;
    @Property(boolValue={true}, label="Optimize For Oak", description="If this switch is enabled, and Oak is used as the repository implementation, some optimized components are used.")
    private static final String PROPERTY_OPTIMIZE_FOR_OAK = "optimize.oak";
    private static final int DEFAULT_OBSERVATION_QUEUE_LENGTH = 1000;
    @Property(intValue={1000}, label="Observation queue length", description="Maximum number of pending revisions in a observation listener queue")
    private static final String OBSERVATION_QUEUE_LENGTH = "oak.observation.queue-length";
    @Reference(name="repository", referenceInterface=SlingRepository.class)
    private ServiceReference repositoryReference;
    @Reference
    private PathMapper pathMapper;
    @Reference(policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private Executor executor;
    private volatile Closeable listener;
    private volatile SlingRepository repository;
    private int observationQueueLength;
    private volatile boolean optimizeForOak;
    private volatile String root;
    private volatile BundleContext bundleCtx;
    private volatile JcrProviderStateFactory stateFactory;
    private final AtomicReference<DynamicClassLoaderManager> classLoaderManagerReference = new AtomicReference();

    @Activate
    protected void activate(ComponentContext context) throws RepositoryException {
        SlingRepository repository = (SlingRepository)context.locateService(REPOSITORY_REFERNENCE_NAME, this.repositoryReference);
        if (repository == null) {
            this.logger.warn("activate: Activation failed because SlingRepository may have been unregistered concurrently");
            return;
        }
        this.repository = repository;
        this.observationQueueLength = PropertiesUtil.toInteger(context.getProperties().get(OBSERVATION_QUEUE_LENGTH), (int)1000);
        this.optimizeForOak = PropertiesUtil.toBoolean(context.getProperties().get(PROPERTY_OPTIMIZE_FOR_OAK), (boolean)true);
        this.root = PropertiesUtil.toString(context.getProperties().get("provider.root"), (String)"/");
        this.bundleCtx = context.getBundleContext();
        this.stateFactory = new JcrProviderStateFactory(this.repositoryReference, repository, this.classLoaderManagerReference, this.pathMapper);
    }

    @Deactivate
    protected void deactivate() {
        this.bundleCtx = null;
        this.stateFactory = null;
    }

    protected void bindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.classLoaderManagerReference.set(dynamicClassLoaderManager);
    }

    protected void unbindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.classLoaderManagerReference.compareAndSet(dynamicClassLoaderManager, null);
    }

    public void start(ProviderContext ctx) {
        super.start(ctx);
        this.registerListener(ctx);
    }

    public void stop() {
        this.unregisterListener();
        super.stop();
    }

    public void update(long changeSet) {
        super.update(changeSet);
        this.unregisterListener();
        this.registerListener(this.getProviderContext());
    }

    private void bindRepository(ServiceReference ref) {
        this.repositoryReference = ref;
        this.repository = null;
    }

    private void unbindRepository(ServiceReference ref) {
        if (this.repositoryReference == ref) {
            this.repositoryReference = null;
            this.repository = null;
        }
    }

    private void registerListener(ProviderContext ctx) {
        String repoDesc;
        boolean isOak = false;
        if (this.optimizeForOak && (repoDesc = this.repository.getDescriptor("jcr.repository.name")) != null && repoDesc.toLowerCase().contains(" oak")) {
            if (this.executor != null) {
                isOak = true;
            } else {
                this.logger.error("Detected Oak based repository but no executor service available! Unable to use improved JCR Resource listener");
            }
        }
        try {
            if (isOak) {
                try {
                    this.listener = new OakResourceListener(this.root, ctx, this.bundleCtx, this.executor, this.pathMapper, this.observationQueueLength, this.repository);
                    this.logger.info("Detected Oak based repository. Using improved JCR Resource Listener with observation queue length {}", (Object)this.observationQueueLength);
                }
                catch (RepositoryException re) {
                    throw new SlingException("Can't create the OakResourceListener", (Throwable)re);
                }
                catch (Throwable t) {
                    this.logger.error("Unable to instantiate improved JCR Resource listener for Oak. Using fallback.", t);
                }
            }
            if (this.listener == null) {
                this.listener = new JcrResourceListener(ctx, this.root, this.pathMapper, this.repository);
            }
        }
        catch (RepositoryException e) {
            throw new SlingException("Can't create the listener", (Throwable)e);
        }
    }

    private void unregisterListener() {
        if (this.listener != null) {
            try {
                this.listener.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.listener = null;
        }
    }

    @Nonnull
    public JcrProviderState authenticate(@Nonnull Map<String, Object> authenticationInfo) throws LoginException {
        return this.stateFactory.createProviderState(authenticationInfo);
    }

    public void logout(@Nonnull JcrProviderState state) {
        state.logout();
    }

    public boolean isLive(@Nonnull ResolveContext<JcrProviderState> ctx) {
        return ((JcrProviderState)ctx.getProviderState()).getSession().isLive();
    }

    public Resource getResource(ResolveContext<JcrProviderState> ctx, String path, ResourceContext rCtx, Resource parent) {
        try {
            return ((JcrProviderState)ctx.getProviderState()).getResourceFactory().createResource(ctx.getResourceResolver(), path, parent, rCtx.getResolveParameters());
        }
        catch (RepositoryException e) {
            throw new SlingException("Can't get resource", (Throwable)e);
        }
    }

    public Iterator<Resource> listChildren(ResolveContext<JcrProviderState> ctx, Resource parent) {
        JcrItemResource<?> parentItemResource;
        if (parent instanceof JcrItemResource) {
            parentItemResource = (JcrItemResource<?>)parent;
        } else {
            try {
                parentItemResource = ((JcrProviderState)ctx.getProviderState()).getResourceFactory().createResource(parent.getResourceResolver(), parent.getPath(), null, parent.getResourceMetadata().getParameterMap());
            }
            catch (RepositoryException re) {
                throw new SlingException("Can't list children", (Throwable)re);
            }
        }
        return parentItemResource != null ? parentItemResource.listJcrChildren() : null;
    }

    @CheckForNull
    public Resource getParent(@Nonnull ResolveContext<JcrProviderState> ctx, @Nonnull Resource child) {
        block7: {
            if (child instanceof JcrItemResource) {
                try {
                    Node parentNode;
                    String version = null;
                    if (child.getResourceMetadata().getParameterMap() != null) {
                        version = (String)child.getResourceMetadata().getParameterMap().get("v");
                    }
                    if (version != null) break block7;
                    Object item = ((JcrItemResource)child).getItem();
                    if ("/".equals(item.getPath())) {
                        return null;
                    }
                    try {
                        parentNode = item.getParent();
                    }
                    catch (AccessDeniedException e) {
                        return null;
                    }
                    String parentPath = ResourceUtil.getParent((String)child.getPath());
                    return new JcrNodeResource(ctx.getResourceResolver(), parentPath, version, parentNode, ((JcrProviderState)ctx.getProviderState()).getHelperData());
                }
                catch (RepositoryException e) {
                    this.logger.warn("Can't get parent for {}", (Object)child, (Object)e);
                    return null;
                }
            }
        }
        return super.getParent(ctx, child);
    }

    public Collection<String> getAttributeNames(@Nonnull ResolveContext<JcrProviderState> ctx) {
        String[] sessionNames;
        HashSet<String> names = new HashSet<String>();
        for (String name : sessionNames = ((JcrProviderState)ctx.getProviderState()).getSession().getAttributeNames()) {
            if (!JcrResourceProvider.isAttributeVisible(name)) continue;
            names.add(name);
        }
        return names;
    }

    public Object getAttribute(@Nonnull ResolveContext<JcrProviderState> ctx, @Nonnull String name) {
        if (JcrResourceProvider.isAttributeVisible(name)) {
            if ("user.name".equals(name)) {
                return ((JcrProviderState)ctx.getProviderState()).getSession().getUserID();
            }
            return ((JcrProviderState)ctx.getProviderState()).getSession().getAttribute(name);
        }
        return null;
    }

    public Resource create(@Nonnull ResolveContext<JcrProviderState> ctx, String path, Map<String, Object> properties) throws PersistenceException {
        String nodeType;
        Object nodeObj;
        Object object = nodeObj = properties != null ? properties.get("jcr:primaryType") : null;
        if (nodeObj != null) {
            nodeType = nodeObj.toString();
        } else {
            String resourceType;
            Object rtObj = properties != null ? properties.get("sling:resourceType") : null;
            boolean isNodeType = false;
            if (rtObj != null && (resourceType = rtObj.toString()).indexOf(58) != -1 && resourceType.indexOf(47) == -1) {
                try {
                    ((JcrProviderState)ctx.getProviderState()).getSession().getWorkspace().getNodeTypeManager().getNodeType(resourceType);
                    isNodeType = true;
                }
                catch (RepositoryException ignore) {
                    // empty catch block
                }
            }
            nodeType = isNodeType ? rtObj.toString() : null;
        }
        String jcrPath = this.pathMapper.mapResourcePathToJCRPath(path);
        if (jcrPath == null) {
            throw new PersistenceException("Unable to create node at " + path, null, path, null);
        }
        Node node = null;
        try {
            int lastPos = jcrPath.lastIndexOf(47);
            Node parent = lastPos == 0 ? ((JcrProviderState)ctx.getProviderState()).getSession().getRootNode() : (Node)((JcrProviderState)ctx.getProviderState()).getSession().getItem(jcrPath.substring(0, lastPos));
            String name = jcrPath.substring(lastPos + 1);
            node = nodeType != null ? parent.addNode(name, nodeType) : parent.addNode(name);
            if (properties != null) {
                JcrModifiableValueMap jcrMap = new JcrModifiableValueMap(node, ((JcrProviderState)ctx.getProviderState()).getHelperData());
                Object value = properties.get("jcr:mixinTypes");
                if (value != null) {
                    jcrMap.put("jcr:mixinTypes", value);
                }
                for (Map.Entry<String, Object> entry : properties.entrySet()) {
                    if (IGNORED_PROPERTIES.contains(entry.getKey())) continue;
                    try {
                        jcrMap.put(entry.getKey(), entry.getValue());
                    }
                    catch (IllegalArgumentException iae) {
                        try {
                            node.remove();
                        }
                        catch (RepositoryException re) {
                            // empty catch block
                        }
                        throw new PersistenceException(iae.getMessage(), (Throwable)iae, path, entry.getKey());
                    }
                }
            }
            return new JcrNodeResource(ctx.getResourceResolver(), path, null, node, ((JcrProviderState)ctx.getProviderState()).getHelperData());
        }
        catch (RepositoryException e) {
            throw new PersistenceException("Unable to create node at " + jcrPath, (Throwable)e, path, null);
        }
    }

    public void delete(@Nonnull ResolveContext<JcrProviderState> ctx, @Nonnull Resource resource) throws PersistenceException {
        Item item = (Item)resource.adaptTo(Item.class);
        try {
            if (item == null) {
                String jcrPath = this.pathMapper.mapResourcePathToJCRPath(resource.getPath());
                if (jcrPath == null) {
                    this.logger.debug("delete: {} maps to an empty JCR path", (Object)resource.getPath());
                    throw new PersistenceException("Unable to delete resource", null, resource.getPath(), null);
                }
                item = ((JcrProviderState)ctx.getProviderState()).getSession().getItem(jcrPath);
            }
            item.remove();
        }
        catch (RepositoryException e) {
            throw new PersistenceException("Unable to delete resource", (Throwable)e, resource.getPath(), null);
        }
    }

    public void revert(@Nonnull ResolveContext<JcrProviderState> ctx) {
        try {
            ((JcrProviderState)ctx.getProviderState()).getSession().refresh(false);
        }
        catch (RepositoryException ignore) {
            this.logger.warn("Unable to revert pending changes.", (Throwable)ignore);
        }
    }

    public void commit(@Nonnull ResolveContext<JcrProviderState> ctx) throws PersistenceException {
        try {
            ((JcrProviderState)ctx.getProviderState()).getSession().save();
        }
        catch (RepositoryException e) {
            throw new PersistenceException("Unable to commit changes to session.", (Throwable)e);
        }
    }

    public boolean hasChanges(@Nonnull ResolveContext<JcrProviderState> ctx) {
        try {
            return ((JcrProviderState)ctx.getProviderState()).getSession().hasPendingChanges();
        }
        catch (RepositoryException ignore) {
            this.logger.warn("Unable to check session for pending changes.", (Throwable)ignore);
            return false;
        }
    }

    public void refresh(@Nonnull ResolveContext<JcrProviderState> ctx) {
        try {
            ((JcrProviderState)ctx.getProviderState()).getSession().refresh(true);
        }
        catch (RepositoryException ignore) {
            this.logger.warn("Unable to refresh session.", (Throwable)ignore);
        }
    }

    @CheckForNull
    public <AdapterType> AdapterType adaptTo(@Nonnull ResolveContext<JcrProviderState> ctx, @Nonnull Class<AdapterType> type) {
        Session session = ((JcrProviderState)ctx.getProviderState()).getSession();
        if (type == Session.class) {
            return (AdapterType)session;
        }
        if (type == Principal.class) {
            try {
                Authorizable auth;
                JackrabbitSession s;
                UserManager um;
                if (session instanceof JackrabbitSession && session.getUserID() != null && (um = (s = (JackrabbitSession)session).getUserManager()) != null && (auth = um.getAuthorizable(s.getUserID())) != null) {
                    return (AdapterType)auth.getPrincipal();
                }
                this.logger.debug("not able to adapto Resource to Principal, let the base class try to adapt");
            }
            catch (RepositoryException e) {
                this.logger.warn("error while adapting Resource to Principal, let the base class try to adapt", (Throwable)e);
            }
        }
        return (AdapterType)super.adaptTo(ctx, type);
    }

    public boolean copy(@Nonnull ResolveContext<JcrProviderState> ctx, String srcAbsPath, String destAbsPath) throws PersistenceException {
        return false;
    }

    public boolean move(@Nonnull ResolveContext<JcrProviderState> ctx, String srcAbsPath, String destAbsPath) throws PersistenceException {
        String srcNodePath = this.pathMapper.mapResourcePathToJCRPath(srcAbsPath);
        String dstNodePath = this.pathMapper.mapResourcePathToJCRPath(destAbsPath + '/' + ResourceUtil.getName((String)srcAbsPath));
        try {
            ((JcrProviderState)ctx.getProviderState()).getSession().move(srcNodePath, dstNodePath);
            return true;
        }
        catch (RepositoryException e) {
            throw new PersistenceException("Unable to move resource to " + destAbsPath, (Throwable)e, srcAbsPath, null);
        }
    }

    @CheckForNull
    public QueryLanguageProvider<JcrProviderState> getQueryLanguageProvider() {
        ProviderContext ctx = this.getProviderContext();
        if (ctx != null) {
            return new BasicQueryLanguageProvider(ctx);
        }
        return null;
    }

    private static boolean isAttributeVisible(String name) {
        return !name.equals("user.jcr.credentials") && !name.contains("password");
    }

    static {
        IGNORED_PROPERTIES.add("jcr:mixinTypes");
        IGNORED_PROPERTIES.add("jcr:primaryType");
        IGNORED_PROPERTIES.add("jcr:created");
        IGNORED_PROPERTIES.add("jcr:createdBy");
    }

    protected void bindPathMapper(PathMapper pathMapper) {
        this.pathMapper = pathMapper;
    }

    protected void unbindPathMapper(PathMapper pathMapper) {
        if (this.pathMapper == pathMapper) {
            this.pathMapper = null;
        }
    }

    protected void bindExecutor(Executor executor) {
        this.executor = executor;
    }

    protected void unbindExecutor(Executor executor) {
        if (this.executor == executor) {
            this.executor = null;
        }
    }
}

