/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.api.observation.JackrabbitEventFilter;
import org.apache.jackrabbit.api.observation.JackrabbitObservationManager;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.JcrResourceListener;
import org.apache.sling.jcr.resource.internal.helper.jcr.PathMapper;
import org.apache.sling.spi.resource.provider.ObservationReporter;
import org.apache.sling.spi.resource.provider.ObserverConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrListenerBaseConfig
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(JcrResourceListener.class);
    private final Session session;
    private final PathMapper pathMapper;
    private final ObservationReporter reporter;

    public JcrListenerBaseConfig(ObservationReporter reporter, PathMapper pathMapper, SlingRepository repository) throws RepositoryException {
        this.pathMapper = pathMapper;
        this.reporter = reporter;
        this.session = repository.loginAdministrative(repository.getDefaultWorkspace());
    }

    @Override
    public void close() throws IOException {
        this.session.logout();
    }

    public void register(final JcrResourceListener listener, final ObserverConfiguration config) throws RepositoryException {
        JcrResourceListener regListener;
        JackrabbitEventFilter filter;
        ObservationManager mgr = this.session.getWorkspace().getObservationManager();
        if (mgr instanceof JackrabbitObservationManager) {
            filter = new JackrabbitEventFilter();
            Set paths = config.getPaths().toStringSet();
            String[] pathArray = new String[paths.size()];
            int i = 0;
            boolean hasGlob = false;
            for (String p : paths) {
                if (p.startsWith("glob:")) {
                    hasGlob = true;
                }
                pathArray[i] = p.startsWith("glob:") ? p.substring("glob:".length()) : p;
                ++i;
            }
            if (hasGlob) {
                filter.setAbsPath("/");
                regListener = new EventListener(){

                    public void onEvent(final EventIterator events) {
                        listener.onEvent(new EventIterator(){
                            Event next = this.seek();

                            private Event seek() {
                                while (events.hasNext()) {
                                    Event e = events.nextEvent();
                                    String path = null;
                                    try {
                                        path = e.getPath();
                                        if (e.getType() == 4 || e.getType() == 16 || e.getType() == 8) {
                                            path = ResourceUtil.getParent((String)path);
                                        }
                                        if (config.getPaths().matches(path) != null) {
                                            return e;
                                        }
                                        if (!path.endsWith("/jcr:content") || config.getPaths().matches(path.substring(0, path.length() - 12)) == null) continue;
                                        return e;
                                    }
                                    catch (RepositoryException repositoryException) {
                                    }
                                }
                                return null;
                            }

                            public void remove() {
                            }

                            public Object next() {
                                return this.nextEvent();
                            }

                            public boolean hasNext() {
                                return this.next != null;
                            }

                            public void skip(long skipNum) {
                            }

                            public long getSize() {
                                return 0L;
                            }

                            public long getPosition() {
                                return 0L;
                            }

                            public Event nextEvent() {
                                Event result = this.next;
                                this.next = this.seek();
                                return result;
                            }
                        });
                    }
                };
            } else {
                filter.setAdditionalPaths(pathArray);
                regListener = listener;
            }
            filter.setIsDeep(true);
            Set excludePaths = config.getExcludedPaths().toStringSet();
            if (!excludePaths.isEmpty()) {
                filter.setExcludedPaths(excludePaths.toArray(new String[excludePaths.size()]));
            }
        } else {
            throw new RepositoryException("Observation manager is not a JackrabbitObservationManager");
        }
        filter.setNoExternal(config.includeExternal());
        filter.setEventTypes(this.getTypes(config));
        ((JackrabbitObservationManager)mgr).addEventListener((EventListener)regListener, filter);
    }

    private int getTypes(ObserverConfiguration c) {
        int result = 0;
        for (ResourceChange.ChangeType t : c.getChangeTypes()) {
            switch (t) {
                case ADDED: {
                    result |= 1;
                    break;
                }
                case REMOVED: {
                    result |= 2;
                    break;
                }
                case CHANGED: {
                    result |= 4;
                    result |= 0x10;
                    result |= 8;
                    break;
                }
            }
        }
        return result;
    }

    public void unregister(JcrResourceListener listener) {
        try {
            this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)listener);
        }
        catch (RepositoryException e) {
            this.logger.warn("Unable to remove session listener: " + this, (Throwable)e);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ObservationReporter getReporter() {
        return this.reporter;
    }

    public PathMapper getPathMapper() {
        return this.pathMapper;
    }

    public Session getSession() {
        return this.session;
    }
}

