/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.api.observation.JackrabbitEventFilter;
import org.apache.jackrabbit.api.observation.JackrabbitObservationManager;
import org.apache.jackrabbit.oak.jcr.observation.filter.FilterFactory;
import org.apache.jackrabbit.oak.jcr.observation.filter.OakEventFilter;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.JcrResourceListener;
import org.apache.sling.jcr.resource.internal.helper.jcr.PathMapper;
import org.apache.sling.spi.resource.provider.ObservationReporter;
import org.apache.sling.spi.resource.provider.ObserverConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrListenerBaseConfig
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(JcrResourceListener.class);
    private final Session session;
    private final PathMapper pathMapper;
    private final ObservationReporter reporter;

    public JcrListenerBaseConfig(ObservationReporter reporter, PathMapper pathMapper, SlingRepository repository) throws RepositoryException {
        this.pathMapper = pathMapper;
        this.reporter = reporter;
        this.session = repository.loginAdministrative(repository.getDefaultWorkspace());
    }

    @Override
    public void close() throws IOException {
        this.session.logout();
    }

    public void register(EventListener listener, ObserverConfiguration config) throws RepositoryException {
        OakEventFilter filter;
        ObservationManager mgr = this.session.getWorkspace().getObservationManager();
        if (mgr instanceof JackrabbitObservationManager) {
            filter = FilterFactory.wrap((JackrabbitEventFilter)new JackrabbitEventFilter());
            Set paths = config.getPaths().toStringSet();
            int globCount = 0;
            int pathCount = 0;
            for (String p : paths) {
                if (p.startsWith("glob:")) {
                    ++globCount;
                    continue;
                }
                ++pathCount;
            }
            String[] pathArray = pathCount > 0 ? new String[pathCount] : null;
            String[] globArray = globCount > 0 ? new String[globCount] : null;
            pathCount = 0;
            globCount = 0;
            for (String p : paths) {
                if (p.startsWith("glob:")) {
                    globArray[globCount] = p.substring("glob:".length());
                    ++globCount;
                    continue;
                }
                pathArray[pathCount] = p;
                ++pathCount;
            }
            if (globArray != null) {
                filter.withIncludeGlobPaths(globArray);
            }
            if (pathArray != null) {
                filter.setAdditionalPaths(pathArray);
            }
            filter.setIsDeep(true);
            Set excludePaths = config.getExcludedPaths().toStringSet();
            if (!excludePaths.isEmpty()) {
                filter.setExcludedPaths(excludePaths.toArray(new String[excludePaths.size()]));
            }
        } else {
            throw new RepositoryException("Observation manager is not a JackrabbitObservationManager");
        }
        filter.setNoExternal(config.includeExternal());
        filter.setEventTypes(this.getTypes(config));
        filter.withNodeTypeAggregate(new String[]{"nt:file"}, new String[]{"", "jcr:content"});
        filter.withIncludeAncestorsRemove();
        ((JackrabbitObservationManager)mgr).addEventListener(listener, (JackrabbitEventFilter)filter);
    }

    private int getTypes(ObserverConfiguration c) {
        int result = 0;
        for (ResourceChange.ChangeType t : c.getChangeTypes()) {
            switch (t) {
                case ADDED: {
                    result |= 1;
                    break;
                }
                case REMOVED: {
                    result |= 2;
                    break;
                }
                case CHANGED: {
                    result |= 4;
                    result |= 0x10;
                    result |= 8;
                    break;
                }
            }
        }
        return result;
    }

    public void unregister(EventListener listener) {
        try {
            this.session.getWorkspace().getObservationManager().removeEventListener(listener);
        }
        catch (RepositoryException e) {
            this.logger.warn("Unable to remove session listener: " + this, (Throwable)e);
        }
    }

    public ObservationReporter getReporter() {
        return this.reporter;
    }

    public PathMapper getPathMapper() {
        return this.pathMapper;
    }
}

