/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.io.Closeable;
import java.io.IOException;
import javax.jcr.Session;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.HelperData;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrItemResourceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

class JcrProviderState
implements Closeable {
    private final Session session;
    private final BundleContext bundleContext;
    private final ServiceReference<SlingRepository> repositoryRef;
    private final boolean logout;
    private final JcrItemResourceFactory resourceFactory;
    private final HelperData helperData;

    JcrProviderState(Session session, HelperData helperData, boolean logout) {
        this(session, helperData, logout, null, null);
    }

    JcrProviderState(Session session, HelperData helperData, boolean logout, BundleContext bundleContext, ServiceReference<SlingRepository> repositoryRef) {
        this.session = session;
        this.bundleContext = bundleContext;
        this.repositoryRef = repositoryRef;
        this.logout = logout;
        this.helperData = helperData;
        this.resourceFactory = new JcrItemResourceFactory(session, helperData);
    }

    Session getSession() {
        return this.session;
    }

    JcrItemResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    HelperData getHelperData() {
        return this.helperData;
    }

    @Override
    public void close() throws IOException {
        this.logout();
    }

    void logout() {
        if (this.logout) {
            this.session.logout();
        }
        if (this.bundleContext != null) {
            try {
                this.bundleContext.ungetService(this.repositoryRef);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }
}

