/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.io.Closeable;
import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.external.URIProvider;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.JcrListenerBaseConfig;
import org.apache.sling.jcr.resource.internal.JcrModifiableValueMap;
import org.apache.sling.jcr.resource.internal.JcrResourceListener;
import org.apache.sling.jcr.resource.internal.helper.jcr.BasicQueryLanguageProvider;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrItemResource;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResource;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrProviderState;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrProviderStateFactory;
import org.apache.sling.spi.resource.provider.ObserverConfiguration;
import org.apache.sling.spi.resource.provider.ProviderContext;
import org.apache.sling.spi.resource.provider.QueryLanguageProvider;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderFactory", service={ResourceProvider.class}, property={"provider.name=JCR", "provider.root=/", "provider.modifiable:Boolean=true", "provider.adaptable:Boolean=true", "provider.attributable:Boolean=true", "provider.refreshable:Boolean=true", "provider.authenticate=required", "service.vendor=The Apache Software Foundation"})
public class JcrResourceProvider
extends ResourceProvider<JcrProviderState> {
    private final Logger logger = LoggerFactory.getLogger(JcrResourceProvider.class);
    private static final String REPOSITORY_REFERNENCE_NAME = "repository";
    private static final Set<String> IGNORED_PROPERTIES = new HashSet<String>();
    @Reference(name="repository", service=SlingRepository.class)
    private ServiceReference<SlingRepository> repositoryReference;
    private volatile JcrListenerBaseConfig listenerConfig;
    private final Map<ObserverConfiguration, Closeable> listeners = new HashMap<ObserverConfiguration, Closeable>();
    private final Map<URIProvider, URIProvider> providers = new ConcurrentHashMap<URIProvider, URIProvider>();
    private volatile SlingRepository repository;
    private volatile JcrProviderStateFactory stateFactory;
    private final AtomicReference<DynamicClassLoaderManager> classLoaderManagerReference = new AtomicReference();
    private AtomicReference<URIProvider[]> uriProviderReference = new AtomicReference();

    @Activate
    protected void activate(ComponentContext context) throws RepositoryException {
        SlingRepository repository = (SlingRepository)context.locateService(REPOSITORY_REFERNENCE_NAME, this.repositoryReference);
        if (repository == null) {
            this.logger.warn("activate: Activation failed because SlingRepository may have been unregistered concurrently");
            return;
        }
        this.repository = repository;
        this.stateFactory = new JcrProviderStateFactory(this.repositoryReference, repository, this.classLoaderManagerReference, this.uriProviderReference);
    }

    @Deactivate
    protected void deactivate() {
        this.stateFactory = null;
    }

    @Reference(name="dynamicClassLoaderManager", service=DynamicClassLoaderManager.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void bindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.classLoaderManagerReference.set(dynamicClassLoaderManager);
    }

    protected void unbindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.classLoaderManagerReference.compareAndSet(dynamicClassLoaderManager, null);
    }

    @Reference(name="uriprovider", service=URIProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindUriProvider", unbind="unbindUriProvider")
    private void bindUriProvider(URIProvider uriProvider) {
        this.providers.put(uriProvider, uriProvider);
        this.updateURIProviders();
    }

    private void unbindUriProvider(URIProvider uriProvider) {
        this.providers.remove(uriProvider);
        this.updateURIProviders();
    }

    private void updateURIProviders() {
        URIProvider[] ups = this.providers.values().toArray(new URIProvider[this.providers.size()]);
        this.uriProviderReference.set(ups);
    }

    public void start(ProviderContext ctx) {
        super.start(ctx);
        this.registerListeners();
    }

    public void stop() {
        this.unregisterListeners();
        super.stop();
    }

    public void update(long changeSet) {
        super.update(changeSet);
        this.updateListeners();
    }

    private void bindRepository(ServiceReference<SlingRepository> ref) {
        this.repositoryReference = ref;
        this.repository = null;
    }

    private void unbindRepository(ServiceReference<SlingRepository> ref) {
        if (this.repositoryReference == ref) {
            this.repositoryReference = null;
            this.repository = null;
        }
    }

    private void registerListeners() {
        if (this.repository != null) {
            this.logger.debug("Registering resource listeners...");
            try {
                this.listenerConfig = new JcrListenerBaseConfig(this.getProviderContext().getObservationReporter(), this.repository);
                for (ObserverConfiguration config : this.getProviderContext().getObservationReporter().getObserverConfigurations()) {
                    this.logger.debug("Registering listener for {}", (Object)config.getPaths());
                    JcrResourceListener listener = new JcrResourceListener(this.listenerConfig, config);
                    this.listeners.put(config, listener);
                }
            }
            catch (RepositoryException e) {
                throw new SlingException("Can't create the JCR event listener.", (Throwable)e);
            }
            this.logger.debug("Registered resource listeners");
        }
    }

    private void unregisterListeners() {
        this.logger.debug("Unregistering resource listeners...");
        for (Closeable c : this.listeners.values()) {
            try {
                this.logger.debug("Removing listener for {}", (Object)((JcrResourceListener)c).getConfig().getPaths());
                c.close();
            }
            catch (IOException iOException) {}
        }
        this.listeners.clear();
        if (this.listenerConfig != null) {
            try {
                this.listenerConfig.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.listenerConfig = null;
        }
        this.logger.debug("Unregistered resource listeners");
    }

    private void updateListeners() {
        if (this.listenerConfig == null) {
            this.unregisterListeners();
            this.registerListeners();
        } else {
            this.logger.debug("Updating resource listeners...");
            HashMap<ObserverConfiguration, Closeable> oldMap = new HashMap<ObserverConfiguration, Closeable>(this.listeners);
            this.listeners.clear();
            try {
                for (ObserverConfiguration config : this.getProviderContext().getObservationReporter().getObserverConfigurations()) {
                    Closeable listener = (Closeable)oldMap.remove(config);
                    if (listener == null) {
                        this.logger.debug("Registering listener for {}", (Object)config.getPaths());
                        listener = new JcrResourceListener(this.listenerConfig, config);
                    } else {
                        this.logger.debug("Updating listener for {}", (Object)config.getPaths());
                        ((JcrResourceListener)listener).update(config);
                    }
                    this.listeners.put(config, listener);
                }
            }
            catch (RepositoryException e) {
                throw new SlingException("Can't create the JCR event listener.", (Throwable)e);
            }
            for (Closeable c : oldMap.values()) {
                try {
                    this.logger.debug("Removing listener for {}", (Object)((JcrResourceListener)c).getConfig().getPaths());
                    c.close();
                }
                catch (IOException iOException) {}
            }
            this.logger.debug("Updated resource listeners");
        }
    }

    @NotNull
    public JcrProviderState authenticate(@NotNull Map<String, Object> authenticationInfo) throws LoginException {
        return this.stateFactory.createProviderState(authenticationInfo);
    }

    public void logout(@NotNull JcrProviderState state) {
        state.logout();
    }

    public boolean isLive(@NotNull ResolveContext<JcrProviderState> ctx) {
        return ((JcrProviderState)ctx.getProviderState()).getSession().isLive();
    }

    public Resource getResource(ResolveContext<JcrProviderState> ctx, String path, ResourceContext rCtx, Resource parent) {
        try {
            return ((JcrProviderState)ctx.getProviderState()).getResourceFactory().createResource(ctx.getResourceResolver(), path, parent, rCtx.getResolveParameters());
        }
        catch (RepositoryException e) {
            throw new SlingException("Can't get resource", (Throwable)e);
        }
    }

    public Iterator<Resource> listChildren(ResolveContext<JcrProviderState> ctx, Resource parent) {
        JcrItemResource<?> parentItemResource;
        if (parent instanceof JcrItemResource) {
            parentItemResource = (JcrItemResource<?>)parent;
        } else {
            try {
                parentItemResource = ((JcrProviderState)ctx.getProviderState()).getResourceFactory().createResource(parent.getResourceResolver(), parent.getPath(), null, parent.getResourceMetadata().getParameterMap());
            }
            catch (RepositoryException re) {
                throw new SlingException("Can't list children", (Throwable)re);
            }
        }
        return parentItemResource != null ? parentItemResource.listJcrChildren() : null;
    }

    @Nullable
    public Resource getParent(@NotNull ResolveContext<JcrProviderState> ctx, @NotNull Resource child) {
        block7: {
            if (child instanceof JcrItemResource) {
                try {
                    Node parentNode;
                    String version = null;
                    if (child.getResourceMetadata().getParameterMap() != null) {
                        version = (String)child.getResourceMetadata().getParameterMap().get("v");
                    }
                    if (version != null) break block7;
                    Object item = ((JcrItemResource)child).getItem();
                    if ("/".equals(item.getPath())) {
                        return null;
                    }
                    try {
                        parentNode = item.getParent();
                    }
                    catch (AccessDeniedException e) {
                        return null;
                    }
                    String parentPath = ResourceUtil.getParent((String)child.getPath());
                    return new JcrNodeResource(ctx.getResourceResolver(), parentPath, version, parentNode, ((JcrProviderState)ctx.getProviderState()).getHelperData());
                }
                catch (RepositoryException e) {
                    this.logger.warn("Can't get parent for {}", (Object)child, (Object)e);
                    return null;
                }
            }
        }
        return super.getParent(ctx, child);
    }

    public Collection<String> getAttributeNames(@NotNull ResolveContext<JcrProviderState> ctx) {
        String[] sessionNames;
        HashSet<String> names = new HashSet<String>();
        for (String name : sessionNames = ((JcrProviderState)ctx.getProviderState()).getSession().getAttributeNames()) {
            if (!JcrResourceProvider.isAttributeVisible(name)) continue;
            names.add(name);
        }
        return names;
    }

    public Object getAttribute(@NotNull ResolveContext<JcrProviderState> ctx, @NotNull String name) {
        if (JcrResourceProvider.isAttributeVisible(name)) {
            if ("user.name".equals(name)) {
                return ((JcrProviderState)ctx.getProviderState()).getSession().getUserID();
            }
            return ((JcrProviderState)ctx.getProviderState()).getSession().getAttribute(name);
        }
        return null;
    }

    public Resource create(@NotNull ResolveContext<JcrProviderState> ctx, String path, Map<String, Object> properties) throws PersistenceException {
        String nodeType;
        Object nodeObj;
        Object object = nodeObj = properties != null ? properties.get("jcr:primaryType") : null;
        if (nodeObj != null) {
            nodeType = nodeObj.toString();
        } else {
            String resourceType;
            Object rtObj = properties != null ? properties.get("sling:resourceType") : null;
            boolean isNodeType = false;
            if (rtObj != null && (resourceType = rtObj.toString()).indexOf(58) != -1 && resourceType.indexOf(47) == -1) {
                try {
                    ((JcrProviderState)ctx.getProviderState()).getSession().getWorkspace().getNodeTypeManager().getNodeType(resourceType);
                    isNodeType = true;
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
            nodeType = isNodeType ? rtObj.toString() : null;
        }
        String jcrPath = path;
        if (jcrPath == null) {
            throw new PersistenceException("Unable to create node at " + path, null, path, null);
        }
        Node node = null;
        try {
            int lastPos = jcrPath.lastIndexOf(47);
            Node parent = lastPos == 0 ? ((JcrProviderState)ctx.getProviderState()).getSession().getRootNode() : (Node)((JcrProviderState)ctx.getProviderState()).getSession().getItem(jcrPath.substring(0, lastPos));
            String name = jcrPath.substring(lastPos + 1);
            node = nodeType != null ? parent.addNode(name, nodeType) : parent.addNode(name);
            if (properties != null) {
                JcrModifiableValueMap jcrMap = new JcrModifiableValueMap(node, ((JcrProviderState)ctx.getProviderState()).getHelperData());
                Object value = properties.get("jcr:mixinTypes");
                if (value != null) {
                    jcrMap.put("jcr:mixinTypes", value);
                }
                for (Map.Entry<String, Object> entry : properties.entrySet()) {
                    if (IGNORED_PROPERTIES.contains(entry.getKey())) continue;
                    try {
                        jcrMap.put(entry.getKey(), entry.getValue());
                    }
                    catch (IllegalArgumentException iae) {
                        try {
                            node.remove();
                        }
                        catch (RepositoryException repositoryException) {
                            // empty catch block
                        }
                        throw new PersistenceException(iae.getMessage(), (Throwable)iae, path, entry.getKey());
                    }
                }
            }
            return new JcrNodeResource(ctx.getResourceResolver(), path, null, node, ((JcrProviderState)ctx.getProviderState()).getHelperData());
        }
        catch (RepositoryException e) {
            throw new PersistenceException("Unable to create node at " + jcrPath, (Throwable)e, path, null);
        }
    }

    public void delete(@NotNull ResolveContext<JcrProviderState> ctx, @NotNull Resource resource) throws PersistenceException {
        Item item = (Item)resource.adaptTo(Item.class);
        try {
            if (item == null) {
                String jcrPath = resource.getPath();
                if (jcrPath == null) {
                    this.logger.debug("delete: {} maps to an empty JCR path", (Object)resource.getPath());
                    throw new PersistenceException("Unable to delete resource", null, resource.getPath(), null);
                }
                item = ((JcrProviderState)ctx.getProviderState()).getSession().getItem(jcrPath);
            }
            item.remove();
        }
        catch (RepositoryException e) {
            throw new PersistenceException("Unable to delete resource", (Throwable)e, resource.getPath(), null);
        }
    }

    public void revert(@NotNull ResolveContext<JcrProviderState> ctx) {
        try {
            ((JcrProviderState)ctx.getProviderState()).getSession().refresh(false);
        }
        catch (RepositoryException ignore) {
            this.logger.warn("Unable to revert pending changes.", (Throwable)ignore);
        }
    }

    public void commit(@NotNull ResolveContext<JcrProviderState> ctx) throws PersistenceException {
        try {
            ((JcrProviderState)ctx.getProviderState()).getSession().save();
        }
        catch (RepositoryException e) {
            throw new PersistenceException("Unable to commit changes to session.", (Throwable)e);
        }
    }

    public boolean hasChanges(@NotNull ResolveContext<JcrProviderState> ctx) {
        try {
            return ((JcrProviderState)ctx.getProviderState()).getSession().hasPendingChanges();
        }
        catch (RepositoryException ignore) {
            this.logger.warn("Unable to check session for pending changes.", (Throwable)ignore);
            return false;
        }
    }

    public void refresh(@NotNull ResolveContext<JcrProviderState> ctx) {
        try {
            ((JcrProviderState)ctx.getProviderState()).getSession().refresh(true);
        }
        catch (RepositoryException ignore) {
            this.logger.warn("Unable to refresh session.", (Throwable)ignore);
        }
    }

    @Nullable
    public <AdapterType> AdapterType adaptTo(@NotNull ResolveContext<JcrProviderState> ctx, @NotNull Class<AdapterType> type) {
        Session session = ((JcrProviderState)ctx.getProviderState()).getSession();
        if (type == Session.class) {
            return (AdapterType)session;
        }
        if (type == Principal.class) {
            try {
                Authorizable auth;
                JackrabbitSession s;
                UserManager um;
                if (session instanceof JackrabbitSession && session.getUserID() != null && (um = (s = (JackrabbitSession)session).getUserManager()) != null && (auth = um.getAuthorizable(s.getUserID())) != null) {
                    return (AdapterType)auth.getPrincipal();
                }
                this.logger.debug("not able to adapto Resource to Principal, let the base class try to adapt");
            }
            catch (RepositoryException e) {
                this.logger.warn("error while adapting Resource to Principal, let the base class try to adapt", (Throwable)e);
            }
        }
        return (AdapterType)super.adaptTo(ctx, type);
    }

    public boolean copy(@NotNull ResolveContext<JcrProviderState> ctx, String srcAbsPath, String destAbsPath) throws PersistenceException {
        return false;
    }

    public boolean move(@NotNull ResolveContext<JcrProviderState> ctx, String srcAbsPath, String destAbsPath) throws PersistenceException {
        String srcNodePath = srcAbsPath;
        String dstNodePath = destAbsPath + '/' + ResourceUtil.getName((String)srcAbsPath);
        try {
            ((JcrProviderState)ctx.getProviderState()).getSession().move(srcNodePath, dstNodePath);
            return true;
        }
        catch (RepositoryException e) {
            throw new PersistenceException("Unable to move resource to " + destAbsPath, (Throwable)e, srcAbsPath, null);
        }
    }

    @Nullable
    public QueryLanguageProvider<JcrProviderState> getQueryLanguageProvider() {
        ProviderContext ctx = this.getProviderContext();
        if (ctx != null) {
            return new BasicQueryLanguageProvider(ctx);
        }
        return null;
    }

    private static boolean isAttributeVisible(String name) {
        return !name.equals("user.jcr.credentials") && !name.contains("password");
    }

    static {
        IGNORED_PROPERTIES.add("jcr:mixinTypes");
        IGNORED_PROPERTIES.add("jcr:primaryType");
        IGNORED_PROPERTIES.add("jcr:created");
        IGNORED_PROPERTIES.add("jcr:createdBy");
    }
}

