/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.QuerySyntaxException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.jcr.resource.internal.helper.JcrResourceUtil;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResourceIterator;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrProviderState;
import org.apache.sling.spi.resource.provider.ProviderContext;
import org.apache.sling.spi.resource.provider.QueryLanguageProvider;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicQueryLanguageProvider
implements QueryLanguageProvider<JcrProviderState> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_QUERY_LANGUAGE = "xpath";
    private static final String QUERY_COLUMN_PATH = "jcr:path";
    private static final String QUERY_COLUMN_SCORE = "jcr:score";
    private final ProviderContext providerContext;

    public BasicQueryLanguageProvider(ProviderContext ctx) {
        this.providerContext = ctx;
    }

    public String[] getSupportedLanguages(ResolveContext<JcrProviderState> ctx) {
        try {
            return ((JcrProviderState)ctx.getProviderState()).getSession().getWorkspace().getQueryManager().getSupportedQueryLanguages();
        }
        catch (RepositoryException e) {
            throw new SlingException("Unable to discover supported query languages", (Throwable)e);
        }
    }

    public Iterator<Resource> findResources(ResolveContext<JcrProviderState> ctx, String query, String language) {
        try {
            QueryResult res = JcrResourceUtil.query(((JcrProviderState)ctx.getProviderState()).getSession(), query, language);
            return new JcrNodeResourceIterator(ctx.getResourceResolver(), null, null, res.getNodes(), ((JcrProviderState)ctx.getProviderState()).getHelperData(), this.providerContext.getExcludedPaths());
        }
        catch (InvalidQueryException iqe) {
            throw new QuerySyntaxException(iqe.getMessage(), query, language, (Throwable)iqe);
        }
        catch (RepositoryException re) {
            throw new SlingException(re.getMessage(), (Throwable)re);
        }
    }

    public Iterator<ValueMap> queryResources(ResolveContext<JcrProviderState> ctx, String query, String language) {
        String queryLanguage = ArrayUtils.contains((Object[])this.getSupportedLanguages(ctx), (Object)language) ? language : DEFAULT_QUERY_LANGUAGE;
        try {
            QueryResult result = JcrResourceUtil.query(((JcrProviderState)ctx.getProviderState()).getSession(), query, queryLanguage);
            final String[] colNames = result.getColumnNames();
            final RowIterator rows = result.getRows();
            return new Iterator<ValueMap>(){
                private ValueMap next = this.seek();

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public ValueMap next() {
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                    ValueMap result = this.next;
                    this.next = this.seek();
                    return result;
                }

                private ValueMap seek() {
                    ValueMapDecorator result = null;
                    while (result == null && rows.hasNext()) {
                        try {
                            Row jcrRow = rows.nextRow();
                            String resourcePath = jcrRow.getPath();
                            if (resourcePath == null || BasicQueryLanguageProvider.this.providerContext.getExcludedPaths().matches(resourcePath) != null) continue;
                            HashMap<String, Object> row = new HashMap<String, Object>();
                            boolean didPath = false;
                            boolean didScore = false;
                            Value[] values = jcrRow.getValues();
                            for (int i = 0; i < values.length; ++i) {
                                Value v = values[i];
                                if (v == null) continue;
                                String colName = colNames[i];
                                row.put(colName, JcrResourceUtil.toJavaObject(values[i]));
                                if (colName.equals(BasicQueryLanguageProvider.QUERY_COLUMN_PATH)) {
                                    didPath = true;
                                    row.put(colName, JcrResourceUtil.toJavaObject(values[i]).toString());
                                }
                                if (!colName.equals(BasicQueryLanguageProvider.QUERY_COLUMN_SCORE)) continue;
                                didScore = true;
                            }
                            if (!didPath) {
                                row.put(BasicQueryLanguageProvider.QUERY_COLUMN_PATH, jcrRow.getPath());
                            }
                            if (!didScore) {
                                row.put(BasicQueryLanguageProvider.QUERY_COLUMN_SCORE, jcrRow.getScore());
                            }
                            result = new ValueMapDecorator(row);
                        }
                        catch (RepositoryException re) {
                            BasicQueryLanguageProvider.this.logger.error("queryResources$next: Problem accessing row values", (Throwable)re);
                        }
                    }
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }
        catch (InvalidQueryException iqe) {
            throw new QuerySyntaxException(iqe.getMessage(), query, language, (Throwable)iqe);
        }
        catch (RepositoryException re) {
            throw new SlingException(re.getMessage(), (Throwable)re);
        }
    }
}

