/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.HashSet;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.jetbrains.annotations.NotNull;

public abstract class NodeUtil {
    public static void handleMixinTypes(Node node, String[] mixinTypes) throws RepositoryException {
        HashSet<String> newTypes = new HashSet<String>();
        if (mixinTypes != null) {
            for (String value : mixinTypes) {
                newTypes.add(value);
            }
        }
        HashSet<String> oldTypes = new HashSet<String>();
        for (NodeType mixinType : node.getMixinNodeTypes()) {
            oldTypes.add(mixinType.getName());
        }
        for (String name : oldTypes) {
            if (!newTypes.contains(name)) {
                node.removeMixin(name);
                continue;
            }
            newTypes.remove(name);
        }
        for (String name : newTypes) {
            node.addMixin(name);
        }
    }

    @NotNull
    public static Property getPrimaryProperty(@NotNull Node node) throws RepositoryException {
        Property data;
        Node content;
        Node node2 = node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}file") || node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}frozenNode") && node.getProperty("{http://www.jcp.org/jcr/1.0}frozenPrimaryType").getString().equals("{http://www.jcp.org/jcr/nt/1.0}file") ? node.getNode("{http://www.jcp.org/jcr/1.0}content") : (content = node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}linkedFile") ? node.getProperty("{http://www.jcp.org/jcr/1.0}content").getNode() : node);
        if (content.hasProperty("{http://www.jcp.org/jcr/1.0}data")) {
            data = content.getProperty("{http://www.jcp.org/jcr/1.0}data");
        } else {
            Item item = content.getPrimaryItem();
            while (item.isNode()) {
                item = ((Node)item).getPrimaryItem();
            }
            data = (Property)item;
        }
        return data;
    }
}

