/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.jackrabbit.api.observation.JackrabbitEvent;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.jcr.resource.api.JcrResourceChange;
import org.apache.sling.jcr.resource.internal.JcrListenerBaseConfig;
import org.apache.sling.spi.resource.provider.ObserverConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrResourceListener
implements EventListener,
Closeable {
    private volatile ObserverConfiguration config;
    private final JcrListenerBaseConfig baseConfig;
    private static final Logger logger = LoggerFactory.getLogger(JcrResourceListener.class);

    public JcrResourceListener(JcrListenerBaseConfig listenerConfig, ObserverConfiguration config) throws RepositoryException {
        this.baseConfig = listenerConfig;
        this.config = config;
        this.baseConfig.register(this, config);
    }

    public void update(ObserverConfiguration cfg) {
        this.config = cfg;
    }

    public ObserverConfiguration getConfig() {
        return this.config;
    }

    @Override
    public void close() {
        this.baseConfig.unregister(this);
    }

    public void onEvent(EventIterator events) {
        HashMap<String, ResourceChange> addedEvents = new HashMap<String, ResourceChange>();
        HashMap<String, ResourceChange> changedEvents = new HashMap<String, ResourceChange>();
        HashMap<String, ResourceChange> removedEvents = new HashMap<String, ResourceChange>();
        while (events.hasNext()) {
            String path;
            String identifier;
            Event event = events.nextEvent();
            try {
                identifier = event.getIdentifier();
                path = event.getPath();
            }
            catch (RepositoryException e) {
                continue;
            }
            String eventPath = identifier != null && identifier.startsWith("/") ? identifier : path;
            int type = event.getType();
            if (type == 4 && path.endsWith("/jcr:primaryType")) {
                int lastSlash = path.lastIndexOf(47);
                String rsrcPath = path.substring(0, lastSlash);
                changedEvents.remove(rsrcPath);
                addedEvents.put(rsrcPath, JcrResourceListener.createResourceChange(event, rsrcPath, ResourceChange.ChangeType.ADDED));
                continue;
            }
            if (type == 4 || type == 8 || type == 16) {
                String rsrcPath;
                if (identifier == null || !identifier.startsWith("/")) {
                    int lastSlash = eventPath.lastIndexOf(47);
                    rsrcPath = eventPath.substring(0, lastSlash);
                } else {
                    rsrcPath = eventPath;
                }
                if (addedEvents.containsKey(rsrcPath) || removedEvents.containsKey(rsrcPath) || changedEvents.containsKey(rsrcPath)) continue;
                changedEvents.put(rsrcPath, JcrResourceListener.createResourceChange(event, rsrcPath, ResourceChange.ChangeType.CHANGED));
                continue;
            }
            if (type == 1) {
                changedEvents.remove(eventPath);
                addedEvents.put(eventPath, JcrResourceListener.createResourceChange(event, eventPath, ResourceChange.ChangeType.ADDED));
                continue;
            }
            if (type != 2) continue;
            addedEvents.remove(eventPath);
            changedEvents.remove(eventPath);
            removedEvents.put(eventPath, JcrResourceListener.createResourceChange(event, eventPath, ResourceChange.ChangeType.REMOVED));
        }
        ArrayList changes = new ArrayList();
        changes.addAll(addedEvents.values());
        changes.addAll(removedEvents.values());
        changes.addAll(changedEvents.values());
        this.baseConfig.getReporter().reportChanges(this.config, changes, false);
    }

    private static ResourceChange createResourceChange(Event event, String path, ResourceChange.ChangeType changeType) {
        boolean isExternal = JcrResourceListener.isExternal(event);
        String userId = !isExternal ? event.getUserID() : null;
        String userData = null;
        try {
            userData = event.getUserData();
        }
        catch (RepositoryException e) {
            logger.debug("Could not access user data from event " + event, (Throwable)e);
        }
        return new JcrResourceChange(changeType, path, isExternal, userId, userData);
    }

    private static boolean isExternal(Event event) {
        if (event instanceof JackrabbitEvent) {
            JackrabbitEvent jEvent = (JackrabbitEvent)event;
            return jEvent.isExternal();
        }
        return false;
    }

    public String toString() {
        return "JcrResourceListener [" + this.config + "]";
    }
}

