/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webdav.impl.servlets;

import java.io.IOException;
import javax.jcr.Repository;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.webdav.simple.SimpleWebdavServlet;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.webdav.impl.helper.SlingResourceConfig;

public class SlingSimpleWebDavServlet
extends SimpleWebdavServlet {
    private final SlingResourceConfig resourceConfig;
    private final Repository repository;

    SlingSimpleWebDavServlet(SlingResourceConfig resourceConfig, Repository repository) {
        this.resourceConfig = resourceConfig;
        this.repository = repository;
    }

    public void init() throws ServletException {
        super.init();
        this.setResourceConfig(this.resourceConfig);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pinfo = request.getPathInfo();
        if (pinfo != null && pinfo.length() > 1) {
            super.service(request, response);
        } else if ("OPTIONS".equals(request.getMethod())) {
            response.setContentLength(0);
            response.setStatus(200);
            response.setHeader("Allow", "OPTIONS, GET, HEAD");
        } else {
            SlingRepository slingRepo = (SlingRepository)this.getRepository();
            if (slingRepo.getDefaultWorkspace() == null) {
                response.sendError(404, "JCR workspace name required, please add it to the end of the URL (for the Jackrabbit embedded repository the default name is 'default') ");
            } else {
                String uri = request.getRequestURI();
                if (pinfo == null) {
                    uri = uri + "/";
                }
                uri = uri + slingRepo.getDefaultWorkspace();
                response.sendRedirect(uri);
            }
        }
    }

    public Repository getRepository() {
        return this.repository;
    }
}

