/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webdav.impl.servlets;

import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.jackrabbit.server.SessionProvider;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.simple.SimpleWebdavServlet;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.webdav.impl.helper.SlingLocatorFactory;
import org.apache.sling.jcr.webdav.impl.helper.SlingResourceConfig;
import org.apache.sling.jcr.webdav.impl.helper.SlingSessionProvider;
import org.apache.sling.jcr.webdav.impl.servlets.SlingSimpleWebDavServlet;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class SlingWebDavServlet
extends SimpleWebdavServlet {
    public static final String PROP_CONTEXT = "dav.root";
    public static final String PROP_REALM = "dav.realm";
    public static final String COLLECTION_TYPES = "collection.types";
    public static final String FILTER_PREFIXES = "filter.prefixes";
    public static final String FILTER_TYPES = "filter.types";
    public static final String FILTER_URIS = "filter.uris";
    public static final String TYPE_COLLECTIONS = "type.collections";
    public static final String TYPE_NONCOLLECTIONS = "type.noncollections";
    public static final String TYPE_CONTENT = "type.content";
    public static final String DEFAULT_CONTEXT = "/dav";
    public static final String DEFAULT_REALM = "Sling WebDAV";
    public static final String[] EMPTY_DEFAULT = new String[0];
    public static final String[] FILTER_PREFIXES_DEFAULT = new String[]{"rep", "jcr"};
    public static final String TYPE_COLLECTIONS_DEFAULT = "sling:Folder";
    public static final String TYPE_NONCOLLECTIONS_DEFAULT = "nt:file";
    public static final String TYPE_CONTENT_DEFAULT = "nt:resource";
    public static final String[] COLLECTION_TYPES_DEFAULT = new String[]{"nt:file", "nt:resource"};
    private SlingRepository repository;
    private HttpService httpService;
    private MimeTypeService mimeTypeService;
    private SlingResourceConfig resourceConfig;
    private DavLocatorFactory locatorFactory;
    private SessionProvider sessionProvider;
    private boolean simpleWebDavServletRegistered;

    public void init() throws ServletException {
        super.init();
        this.setResourceConfig(this.resourceConfig);
    }

    public Repository getRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DavLocatorFactory getLocatorFactory() {
        if (this.locatorFactory == null) {
            SlingRepository slingRepo = (SlingRepository)this.getRepository();
            String workspace = slingRepo.getDefaultWorkspace();
            if (workspace == null || workspace.length() == 0) {
                Session tmp = null;
                try {
                    tmp = slingRepo.login();
                    workspace = tmp.getWorkspace().getName();
                }
                catch (Throwable t) {
                    workspace = "default";
                }
                finally {
                    if (tmp != null) {
                        tmp.logout();
                    }
                }
            }
            this.locatorFactory = new SlingLocatorFactory(workspace);
        }
        return this.locatorFactory;
    }

    public synchronized SessionProvider getSessionProvider() {
        if (this.sessionProvider == null) {
            this.sessionProvider = new SlingSessionProvider();
        }
        return this.sessionProvider;
    }

    protected void activate(ComponentContext context) throws NamespaceException, ServletException {
        this.resourceConfig = new SlingResourceConfig(this.mimeTypeService, context.getProperties());
        SlingSimpleWebDavServlet simpleServlet = new SlingSimpleWebDavServlet(this.resourceConfig, this.getRepository());
        this.httpService.registerServlet(this.resourceConfig.getServletContextPath(), (Servlet)simpleServlet, this.resourceConfig.getServletInitParams(), null);
        this.simpleWebDavServletRegistered = true;
    }

    protected void deactivate(ComponentContext context) {
        if (this.simpleWebDavServletRegistered) {
            this.httpService.unregister(this.resourceConfig.getServletContextPath());
            this.simpleWebDavServletRegistered = false;
        }
        this.resourceConfig = null;
    }

    protected void bindHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unbindHttpService(HttpService httpService) {
        if (this.httpService == httpService) {
            this.httpService = null;
        }
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

