/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webdav.impl.helper;

import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.server.io.DefaultHandler;
import org.apache.jackrabbit.server.io.DirListingExportHandler;
import org.apache.jackrabbit.server.io.IOHandler;
import org.apache.jackrabbit.server.io.IOManager;
import org.apache.jackrabbit.server.io.IOManagerImpl;
import org.apache.jackrabbit.server.io.PropertyHandler;
import org.apache.jackrabbit.server.io.PropertyManager;
import org.apache.jackrabbit.server.io.PropertyManagerImpl;
import org.apache.jackrabbit.webdav.simple.DefaultItemFilter;
import org.apache.jackrabbit.webdav.simple.ItemFilter;
import org.apache.jackrabbit.webdav.simple.ResourceConfig;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.webdav.impl.helper.SlingTikaDetector;
import org.apache.sling.jcr.webdav.impl.servlets.SlingWebDavServlet;
import org.apache.tika.detect.Detector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingResourceConfig
extends ResourceConfig {
    private final String[] collectionTypes;
    private final ItemFilter itemFilter;
    private final IOManager ioManager;
    private final PropertyManager propertyManager;
    private final String servletContextPath;
    private final Dictionary<String, String> servletInitParams;

    public SlingResourceConfig(MimeTypeService mimeTypeService, Dictionary<?, ?> config) {
        super((Detector)new SlingTikaDetector(mimeTypeService));
        this.collectionTypes = OsgiUtil.toStringArray(config.get("collection.types"), (String[])SlingWebDavServlet.COLLECTION_TYPES_DEFAULT);
        String[] filterPrefixes = OsgiUtil.toStringArray(config.get("filter.prefixes"), (String[])SlingWebDavServlet.FILTER_PREFIXES_DEFAULT);
        String[] filterNodeTypes = OsgiUtil.toStringArray(config.get("filter.types"), (String[])SlingWebDavServlet.EMPTY_DEFAULT);
        String[] filterURIs = OsgiUtil.toStringArray(config.get("filter.uris"), (String[])SlingWebDavServlet.EMPTY_DEFAULT);
        this.itemFilter = new DefaultItemFilter();
        this.itemFilter.setFilteredPrefixes(filterPrefixes);
        this.itemFilter.setFilteredURIs(filterURIs);
        this.itemFilter.setFilteredNodetypes(filterNodeTypes);
        String collectionType = OsgiUtil.toString(config.get("type.collections"), (String)"sling:Folder");
        String nonCollectionType = OsgiUtil.toString(config.get("type.noncollections"), (String)"nt:file");
        String contentType = OsgiUtil.toString(config.get("type.content"), (String)"nt:resource");
        DirListingExportHandler dirHandler = new DirListingExportHandler();
        DefaultHandler defaultHandler = new DefaultHandler(null, collectionType, nonCollectionType, contentType);
        this.ioManager = new IOManagerImpl();
        this.ioManager.addIOHandler((IOHandler)dirHandler);
        this.ioManager.addIOHandler((IOHandler)defaultHandler);
        this.propertyManager = new PropertyManagerImpl();
        this.propertyManager.addPropertyHandler((PropertyHandler)dirHandler);
        this.propertyManager.addPropertyHandler((PropertyHandler)defaultHandler);
        this.servletContextPath = OsgiUtil.toString(config.get("dav.root"), (String)"/dav");
        this.servletInitParams = new Hashtable<String, String>();
        this.servletInitParams.put("resource-path-prefix", this.servletContextPath);
        String value = OsgiUtil.toString(config.get("dav.realm"), (String)"Sling WebDAV");
        this.servletInitParams.put("authenticate-header", "Basic Realm=\"" + value + "\"");
    }

    public IOManager getIOManager() {
        return this.ioManager;
    }

    public ItemFilter getItemFilter() {
        return this.itemFilter;
    }

    public PropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public boolean isCollectionResource(Item item) {
        if (item.isNode()) {
            Node node = (Node)item;
            for (String type : this.collectionTypes) {
                try {
                    if (node.isNodeType(type)) {
                        return false;
                    }
                }
                catch (RepositoryException re) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    public void parse(URL configURL) {
    }

    public String getServletContextPath() {
        return this.servletContextPath;
    }

    public Dictionary<String, String> getServletInitParams() {
        return this.servletInitParams;
    }
}

