/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webdav.impl.helper;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class SlingTikaDetector
implements Detector {
    private final MimeTypeService mimeTypeService;

    public SlingTikaDetector(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    public MediaType detect(InputStream rawData, Metadata metadata) {
        String name = metadata.get("resourceName");
        if (name != null) {
            String type;
            int percent;
            int backslash;
            int slash;
            int hash;
            int question = name.indexOf(63);
            if (question != -1) {
                name = name.substring(0, question);
            }
            if ((hash = name.indexOf(35)) != -1) {
                name = name.substring(0, hash);
            }
            if ((slash = name.lastIndexOf(47)) != -1) {
                name = name.substring(slash + 1);
            }
            if ((backslash = name.lastIndexOf(92)) != -1) {
                name = name.substring(backslash + 1);
            }
            if ((percent = name.indexOf(37)) != -1) {
                try {
                    name = URLDecoder.decode(name, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionError((Object)"UTF-8 not supported");
                }
            }
            if ((name = name.trim()).length() > 0 && (type = this.mimeTypeService.getMimeType(name)) != null) {
                return MediaType.parse((String)type);
            }
        }
        return MediaType.OCTET_STREAM;
    }
}

