/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webdav.impl.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingHandlerManager<ManagedType> {
    private final TreeMap<ServiceReference, ManagedType> handlerServices = new TreeMap();
    private ComponentContext componentContext;
    private final String referenceName;
    private ManagedType[] handlers;

    protected SlingHandlerManager(String referenceName) {
        this.referenceName = referenceName;
    }

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ManagedType[] getHandlers(ManagedType[] type) {
        if (this.handlers == null) {
            Set<Map.Entry<ServiceReference, ManagedType>> entries;
            TreeMap<ServiceReference, ManagedType> treeMap = this.handlerServices;
            synchronized (treeMap) {
                entries = this.handlerServices.entrySet();
            }
            ArrayList<ManagedType> ioHandlers = new ArrayList<ManagedType>(entries.size());
            HashMap<ServiceReference, ManagedType> updates = new HashMap<ServiceReference, ManagedType>();
            for (Map.Entry<ServiceReference, ManagedType> entry : entries) {
                Object ioHandler;
                if (entry.getValue() == null) {
                    ServiceReference key = entry.getKey();
                    ioHandler = this.componentContext.locateService(this.referenceName, key);
                    if (ioHandler != null) {
                        updates.put(key, ioHandler);
                    }
                } else {
                    ioHandler = entry.getValue();
                }
                ioHandlers.add(ioHandler);
            }
            if (!updates.isEmpty()) {
                TreeMap<ServiceReference, ManagedType> treeMap2 = this.handlerServices;
                synchronized (treeMap2) {
                    this.handlerServices.putAll(updates);
                }
            }
            this.handlers = ioHandlers.toArray(type);
        }
        return this.handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindHandler(ServiceReference ref) {
        TreeMap<ServiceReference, ManagedType> treeMap = this.handlerServices;
        synchronized (treeMap) {
            this.handlerServices.put(ref, null);
            this.handlers = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindHandler(ServiceReference ref) {
        TreeMap<ServiceReference, ManagedType> treeMap = this.handlerServices;
        synchronized (treeMap) {
            this.handlerServices.remove(ref);
            this.handlers = null;
        }
    }
}

