/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webdav.impl.servlets;

import java.io.IOException;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.server.SessionProvider;
import org.apache.jackrabbit.server.io.CopyMoveHandler;
import org.apache.jackrabbit.server.io.IOHandler;
import org.apache.jackrabbit.server.io.PropertyHandler;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.simple.SimpleWebdavServlet;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.webdav.impl.handler.SlingCopyMoveManager;
import org.apache.sling.jcr.webdav.impl.handler.SlingIOManager;
import org.apache.sling.jcr.webdav.impl.handler.SlingPropertyManager;
import org.apache.sling.jcr.webdav.impl.helper.SlingLocatorFactory;
import org.apache.sling.jcr.webdav.impl.helper.SlingResourceConfig;
import org.apache.sling.jcr.webdav.impl.helper.SlingSessionProvider;
import org.apache.sling.jcr.webdav.impl.servlets.SlingSimpleWebDavServlet;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

@Component(name="org.apache.sling.jcr.webdav.impl.servlets.SimpleWebDavServlet", label="%dav.name", description="%dav.description", metatype=true, policy=ConfigurationPolicy.REQUIRE)
@Service(value={Servlet.class})
@Properties(value={@Property(name="service.description", value={"Sling WebDAV Servlet"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}, propertyPrivate=true), @Property(name="sling.servlet.methods", value={"*"}, propertyPrivate=true)})
@References(value={@Reference(name="IOHandler", referenceInterface=IOHandler.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="PropertyHandler", referenceInterface=PropertyHandler.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="CopyMoveHandler", referenceInterface=CopyMoveHandler.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)})
public class SlingWebDavServlet
extends SimpleWebdavServlet {
    public static final String DEFAULT_CONTEXT = "/dav";
    @Property(value={"/dav"})
    public static final String PROP_CONTEXT = "dav.root";
    public static final boolean DEFAULT_CREATE_ABSOLUTE_URI = true;
    @Property(boolValue={true})
    public static final String PROP_CREATE_ABSOLUTE_URI = "dav.create-absolute-uri";
    public static final String DEFAULT_REALM = "Sling WebDAV";
    @Property(value={"Sling WebDAV"})
    public static final String PROP_REALM = "dav.realm";
    public static final String COLLECTION_TYPES = "collection.types";
    public static final String TYPE_NONCOLLECTIONS_DEFAULT = "nt:file";
    public static final String TYPE_CONTENT_DEFAULT = "nt:resource";
    @Property(name="collection.types")
    public static final String[] COLLECTION_TYPES_DEFAULT = new String[]{"nt:file", "nt:resource"};
    public static final String FILTER_PREFIXES = "filter.prefixes";
    @Property(name="filter.prefixes")
    public static final String[] FILTER_PREFIXES_DEFAULT = new String[]{"rep", "jcr"};
    public static final String[] EMPTY_DEFAULT = new String[0];
    @Property(value={})
    public static final String FILTER_TYPES = "filter.types";
    @Property(value={})
    public static final String FILTER_URIS = "filter.uris";
    public static final String TYPE_COLLECTIONS_DEFAULT = "sling:Folder";
    @Property(value={"sling:Folder"})
    public static final String TYPE_COLLECTIONS = "type.collections";
    @Property(value={"nt:file"})
    public static final String TYPE_NONCOLLECTIONS = "type.noncollections";
    @Property(value={"nt:resource"})
    public static final String TYPE_CONTENT = "type.content";
    static final String IOHANDLER_REF_NAME = "IOHandler";
    static final String PROPERTYHANDLER_REF_NAME = "PropertyHandler";
    static final String COPYMOVEHANDLER_REF_NAME = "CopyMoveHandler";
    @Reference
    private SlingRepository repository;
    @Reference
    private HttpService httpService;
    @Reference
    private MimeTypeService mimeTypeService;
    private final SlingIOManager ioManager = new SlingIOManager("IOHandler");
    private final SlingPropertyManager propertyManager = new SlingPropertyManager("PropertyHandler");
    private final SlingCopyMoveManager copyMoveManager = new SlingCopyMoveManager("CopyMoveHandler");
    private SlingResourceConfig resourceConfig;
    private DavLocatorFactory locatorFactory;
    private SessionProvider sessionProvider;
    private boolean simpleWebDavServletRegistered;

    @Override
    public void init() throws ServletException {
        super.init();
        this.setResourceConfig(this.resourceConfig);
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DavLocatorFactory getLocatorFactory() {
        if (this.locatorFactory == null) {
            SlingRepository slingRepo = (SlingRepository)this.getRepository();
            String workspace = slingRepo.getDefaultWorkspace();
            if (workspace == null || workspace.length() == 0) {
                Session tmp = null;
                try {
                    tmp = slingRepo.login();
                    workspace = tmp.getWorkspace().getName();
                }
                catch (Throwable t) {
                    workspace = "default";
                }
                finally {
                    if (tmp != null) {
                        tmp.logout();
                    }
                }
            }
            this.locatorFactory = new SlingLocatorFactory(workspace);
        }
        return this.locatorFactory;
    }

    @Override
    public synchronized SessionProvider getSessionProvider() {
        if (this.sessionProvider == null) {
            this.sessionProvider = new SlingSessionProvider();
        }
        return this.sessionProvider;
    }

    protected void activate(ComponentContext context) throws NamespaceException, ServletException {
        this.ioManager.setComponentContext(context);
        this.propertyManager.setComponentContext(context);
        this.copyMoveManager.setComponentContext(context);
        this.resourceConfig = new SlingResourceConfig(this.mimeTypeService, context.getProperties(), this.ioManager, this.propertyManager, this.copyMoveManager);
        SlingSimpleWebDavServlet simpleServlet = new SlingSimpleWebDavServlet(this.resourceConfig, this.getRepository());
        this.httpService.registerServlet(this.resourceConfig.getServletContextPath(), (Servlet)simpleServlet, this.resourceConfig.getServletInitParams(), null);
        this.simpleWebDavServletRegistered = true;
    }

    protected void deactivate(ComponentContext context) {
        if (this.simpleWebDavServletRegistered) {
            this.httpService.unregister(this.resourceConfig.getServletContextPath());
            this.simpleWebDavServletRegistered = false;
        }
        this.resourceConfig = null;
        this.ioManager.setComponentContext(null);
        this.propertyManager.setComponentContext(null);
        this.copyMoveManager.setComponentContext(null);
    }

    public void bindIOHandler(ServiceReference ioHandlerReference) {
        this.ioManager.bindIOHandler(ioHandlerReference);
    }

    public void unbindIOHandler(ServiceReference ioHandlerReference) {
        this.ioManager.unbindIOHandler(ioHandlerReference);
    }

    public void bindPropertyHandler(ServiceReference propertyHandlerReference) {
        this.propertyManager.bindPropertyHandler(propertyHandlerReference);
    }

    public void unbindPropertyHandler(ServiceReference propertyHandlerReference) {
        this.propertyManager.unbindPropertyHandler(propertyHandlerReference);
    }

    public void bindCopyMoveHandler(ServiceReference copyMoveHandlerReference) {
        this.copyMoveManager.bindCopyMoveHandler(copyMoveHandlerReference);
    }

    public void unbindCopyMoveHandler(ServiceReference copyMoveHandlerReference) {
        this.copyMoveManager.unbindCopyMoveHandler(copyMoveHandlerReference);
    }

    protected void sendUnauthorized(WebdavRequest request, WebdavResponse response, DavException error) throws IOException {
        response.setHeader("WWW-Authenticate", this.getAuthenticateHeaderValue());
        response.setStatus(401);
        if (error != null) {
            response.getWriter().write(error.getStatusPhrase());
            response.getWriter().write("\n");
        }
        response.getWriter().flush();
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unbindHttpService(HttpService httpService) {
        if (this.httpService == httpService) {
            this.httpService = null;
        }
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }
}

